/*

LPDRAWITEMSTRUCT  lpdis;

case WM_DRAWITEM:
    // Sent to the parent window of an owner-drawn button, combo box, list box, or menu when a visual aspect of
    // the button, combo box, list box, or menu has changed.
    lpdis = (LPDRAWITEMSTRUCT)lParam;

    bDrawButtonRGB(SOBDATA * , (LPDRAWITEMSTRUCT)lParam );
    return 0;
*/

    #include "project.h"

    const COLORREF CLR_BTN_WHITE = RGB(255, 255, 255);
    const COLORREF CLR_BTN_BLACK = RGB(0, 0, 0);
    const COLORREF CLR_BTN_DGREY = RGB(128, 128, 128);
    const COLORREF CLR_BTN_GREY = RGB(192, 192, 192);
    const COLORREF CLR_BTN_LLGREY = RGB(223, 223, 223);

    const myInt BUTTON_IN = 0x01;
    const myInt BUTTON_OUT = 0x02;
    const myInt BUTTON_BLACK_BORDER = 0x04;
    COLORREF text_colour, background_colour, disabled_background_colour;
    COLORREF light, highlight, shadow, dark_shadow;

    //void bDrawCircle(HDC* dc, RECT r, COLORREF colour);

    // void bDrawLine(HDC* dc, long sx, long sy, long ex, long ey, COLORREF colour);

    void bDrawFilledRect(HDC* dc, RECT r, COLORREF colour)
    {
        HBRUSH  B;

        B = CreateSolidBrush(colour);
        FillRect(*dc, &r, B);
        DeleteObject(B);
    }

    void bDrawCircle(HDC* dc, RECT r, COLORREF colour)
    {
        HPEN  new_pen;
        HPEN* old_pen;

        new_pen = CreatePen(PS_SOLID, 1, colour);
        old_pen = (HPEN*) SelectObject(*dc, new_pen);

        Arc(*dc, r.left, r.top, r.right, r.bottom
        , r.left, r.top, r.left, r.top);

        SelectObject(*dc, old_pen);
        DeleteObject(new_pen);
    }

    void bDrawLine(HDC* dc, long sx, long sy, long ex, long ey, COLORREF colour)
    {
        HPEN  new_pen;
        HPEN* old_pen;

        new_pen = CreatePen(PS_SOLID, 1, colour);
        old_pen = (HPEN*) SelectObject(*dc, new_pen);

        MoveToEx(*dc, sx, sy, NULL);
        LineTo(*dc, ex, ey);
        SelectObject(*dc, old_pen);
        DeleteObject(new_pen);
    }

    void bDrawButtonText(HDC* dc, RECT r, const TCHAR* Buf, COLORREF text_colour, DWORD Tstyles)
    {
        COLORREF previous_colour;
        int  h, origH, origW, newW, deltaW;
        previous_colour = SetTextColor(*dc, text_colour);
        SetBkMode(*dc, TRANSPARENT);

        if ((Tstyles BAND DT_WORDBREAK) EQU DT_WORDBREAK)
        {
            // BS_MULTILINE and BS_OWNERDRAWN
            // the text is NOT vertically aligned

            //    debugMessage      (_TEXT("DT_WORDBREAK"), 1);

            origH = r.bottom;
            origW = r.right - r.left;

            // get height of text with word break (no text drawing occurs here)
            h = DrawText(*dc, Buf, (int)_tcslen(Buf), &r, DT_CALCRECT + DT_WORDBREAK);

            // Set new positions so text will be vertically centered
            r.top = r.top + (origH - h) / 2;
            r.bottom = origH;

            //     debugIntn(origW); debugInt( (myUInt)r.right);
            newW = (r.right - r.left);
            deltaW = origW - newW;
            r.left = r.left + deltaW / 2;
            r.right = r.left + newW;

        }

        DrawText(*dc, Buf, (int)_tcslen(Buf), &r, Tstyles);

        SetTextColor(*dc, previous_colour);
    }

    void bDrawFrame(HDC* dc, RECT r, myInt state)
    {
        COLORREF colour;
        long shift_it;

        if ( state BAND BUTTON_BLACK_BORDER)
        {
            colour = CLR_BTN_BLACK;

            bDrawLine(dc, r.left, r.top, r.right, r.top, colour); // Across top
            bDrawLine(dc, r.left, r.top, r.left, r.bottom, colour); // Down left
            bDrawLine(dc, r.left, r.bottom - 1, r.right, r.bottom - 1, colour); // Across bottom
            bDrawLine(dc, r.right - 1, r.top, r.right - 1, r.bottom, colour); // Down right

            shift_it = 1;
            r.left += shift_it;
            r.right -= shift_it;
            r.top += shift_it;
            r.bottom -= shift_it;
        }

        if (state BAND BUTTON_OUT)
        {
            colour = light;

            bDrawLine(dc, r.left, r.top, r.right, r.top, colour); // Across top
            bDrawLine(dc, r.left, r.top, r.left, r.bottom, colour); // Down left

            colour = shadow;

            bDrawLine(dc, r.left, r.bottom - 1, r.right, r.bottom - 1, colour); // Across bottom
            bDrawLine(dc, r.right - 1, r.top, r.right - 1, r.bottom, colour); // Down right

            shift_it = 1;
            r.left += shift_it;
            r.right -= shift_it;
            r.top += shift_it;
            r.bottom -= shift_it;

            colour = light;

            bDrawLine(dc, r.left, r.top, r.right, r.top, colour); // Across top
            bDrawLine(dc, r.left, r.top, r.left, r.bottom, colour); // Down left

            colour = dark_shadow;

            bDrawLine(dc, r.left, r.bottom - 1, r.right, r.bottom - 1, colour); // Across bottom
            bDrawLine(dc, r.right - 1, r.top, r.right - 1, r.bottom, colour); // Down right
        }

        if (state BAND BUTTON_IN)
        {
            colour = dark_shadow;

            bDrawLine(dc, r.left, r.top, r.right, r.top, colour); // Across top
            bDrawLine(dc, r.left, r.top, r.left, r.bottom, colour); // Down left

            colour = light; // shadow;
            bDrawLine(dc, r.left, r.bottom - 1, r.right, r.bottom - 1, colour); // Across bottom
            bDrawLine(dc, r.right - 1, r.top, r.right - 1, r.bottom, colour); // Down right

            shift_it = 1;
            r.left += shift_it;
            r.right -= shift_it;
            r.top += shift_it;
            r.bottom -= shift_it;

            colour = shadow;

            bDrawLine(dc, r.left, r.top, r.right, r.top, colour); // Across top
            bDrawLine(dc, r.left, r.top, r.left, r.bottom, colour); // Down left

            colour = light; // shadow;
            bDrawLine(dc, r.left, r.bottom - 1, r.right, r.bottom - 1, colour); // Across bottom
            bDrawLine(dc, r.right - 1, r.top, r.right - 1, r.bottom, colour); // Down right
        }
    }

    #define SOBTYPE myUInt

    void CClrButton()
    {
        text_colour = GetSysColor(COLOR_BTNTEXT);
        background_colour = GetSysColor(COLOR_BTNFACE);
        disabled_background_colour = background_colour;
        light = GetSysColor(COLOR_3DLIGHT);
        highlight = GetSysColor(COLOR_BTNHIGHLIGHT);
        shadow = GetSysColor(COLOR_BTNSHADOW);
        dark_shadow = GetSysColor(COLOR_3DDKSHADOW);
    }

    void bDrawButtonRGB(SOBDATA* sData ,   LPDRAWITEMSTRUCT  lpDrawItemStruct)
    {
        HDC   dc;
        RECT  focus_rect, button_rect;
        UINT  state;
        COLORREF bg_col;
        #define bufSize   512
        TCHAR buffer[bufSize];
        DWORD dwStyles, Tstyles;
        HWND hwnd;

        hwnd = lpDrawItemStruct->hwndItem;
        dwStyles = GetWindowLong(hwnd, GWL_STYLE);
        Tstyles = 0;

        if (!((dwStyles BAND BS_MULTILINE) EQU BS_MULTILINE)) Tstyles = Tstyles BOR  DT_SINGLELINE;
        else  Tstyles = Tstyles BOR  DT_WORDBREAK;

        if ((dwStyles BAND BS_VCENTER) EQU BS_VCENTER)Tstyles = Tstyles BOR DT_VCENTER;
        else if ((dwStyles BAND BS_TOP) EQU BS_TOP)Tstyles = Tstyles BOR DT_TOP;
        else if ((dwStyles BAND BS_BOTTOM) EQU BS_BOTTOM)Tstyles = Tstyles BOR DT_BOTTOM;
        else Tstyles = Tstyles BOR DT_VCENTER;

        if ((dwStyles BAND BS_CENTER) EQU BS_CENTER)Tstyles = Tstyles BOR DT_CENTER;
        else if ((dwStyles BAND BS_LEFT) EQU BS_LEFT)Tstyles = Tstyles BOR DT_LEFT;
        else if ((dwStyles BAND BS_RIGHT) EQU BS_RIGHT)Tstyles = Tstyles BOR DT_RIGHT;
        else Tstyles = Tstyles BOR DT_CENTER;

        dc = lpDrawItemStruct->hDC;
        state = lpDrawItemStruct->itemState;

        focus_rect.left = lpDrawItemStruct->rcItem.left;
        focus_rect.right = lpDrawItemStruct->rcItem.right;
        focus_rect.top = lpDrawItemStruct->rcItem.top;
        focus_rect.bottom = lpDrawItemStruct->rcItem.bottom;

        button_rect.left = lpDrawItemStruct->rcItem.left;
        button_rect.right = lpDrawItemStruct->rcItem.right;
        button_rect.top = lpDrawItemStruct->rcItem.top;
        button_rect.bottom = lpDrawItemStruct->rcItem.bottom;

        // Set the focus rectangle to just past the border decoration
        focus_rect.left += 4;
        focus_rect.right -= 4;
        focus_rect.top += 4;
        focus_rect.bottom -= 4;

        // Retrieve the control's caption
        GetWindowText(lpDrawItemStruct->hwndItem, buffer, bufSize);

        bg_col = (COLORREF)sData->bgRGB;

        if (bg_col EQU - 1) bg_col = background_colour;

        bDrawFilledRect(&dc, button_rect, bg_col);

        bg_col = (COLORREF)sData->txtRGB;
        if (bg_col EQU - 1)   bg_col = text_colour;

        bDrawButtonText(&dc, button_rect, buffer, bg_col, Tstyles);

    }

    void bDrawButtonRGB2(SOBDATA* sData, LPDRAWITEMSTRUCT  lpDrawItemStruct)
    {

        HDC   dc;
        RECT  focus_rect, button_rect, offset_button_rect;
        UINT  state;
        int bg_col, shift_it;
        #define bufSize   512
        TCHAR buffer[bufSize];
        DWORD dwStyles, Tstyles;
        HWND hwnd;

        hwnd = lpDrawItemStruct->hwndItem;
        dwStyles = GetWindowLong(hwnd, GWL_STYLE);
        Tstyles = 0;
        if (!((dwStyles BAND BS_MULTILINE) EQU BS_MULTILINE)) Tstyles = Tstyles BOR  DT_SINGLELINE;
        else  Tstyles = Tstyles BOR  DT_WORDBREAK;

        if ((dwStyles BAND BS_VCENTER) EQU BS_VCENTER)Tstyles = Tstyles BOR DT_VCENTER;
        else if ((dwStyles BAND BS_TOP) EQU BS_TOP)Tstyles = Tstyles BOR DT_TOP;
        else if ((dwStyles BAND BS_BOTTOM) EQU BS_BOTTOM)Tstyles = Tstyles BOR DT_BOTTOM;
        else Tstyles = Tstyles BOR DT_VCENTER;

        if ((dwStyles BAND BS_CENTER) EQU BS_CENTER)Tstyles = Tstyles BOR DT_CENTER;
        else if ((dwStyles BAND BS_LEFT) EQU BS_LEFT)Tstyles = Tstyles BOR DT_LEFT;
        else if ((dwStyles BAND BS_RIGHT) EQU BS_RIGHT)Tstyles = Tstyles BOR DT_RIGHT;
        else Tstyles = Tstyles BOR DT_CENTER;

        dc = lpDrawItemStruct->hDC;
        state = lpDrawItemStruct->itemState;

        focus_rect.left = lpDrawItemStruct->rcItem.left;
        focus_rect.right = lpDrawItemStruct->rcItem.right;
        focus_rect.top = lpDrawItemStruct->rcItem.top;
        focus_rect.bottom = lpDrawItemStruct->rcItem.bottom;

        button_rect.left = lpDrawItemStruct->rcItem.left;
        button_rect.right = lpDrawItemStruct->rcItem.right;
        button_rect.top = lpDrawItemStruct->rcItem.top;
        button_rect.bottom = lpDrawItemStruct->rcItem.bottom;

        // Set the focus rectangle to just past the border decoration
        focus_rect.left += 4;
        focus_rect.right -= 4;
        focus_rect.top += 4;
        focus_rect.bottom -= 4;

        // Retrieve the button's caption
        GetWindowText(lpDrawItemStruct->hwndItem, buffer, bufSize);

        //     bDrawCircle(& dc, button_rect, BUTTON_IN) ;
        //     bDrawButtonText(& dc, button_rect       , buffer, CLR_BTN_DGREY , Tstyles) ;
        // return ;

        if (state BAND ODS_DISABLED)
        {
            bDrawFilledRect(&dc, button_rect, disabled_background_colour);
        }
        else
        {
            bg_col = 0x0e0e0e0; //  sob_get(SOB_BKGROUND_COL, sob_index);
            if (bg_col EQU - 1) bg_col = background_colour;

            bDrawFilledRect(&dc, button_rect, bg_col);
        }

        if (state BAND ODS_SELECTED)
        {
            bDrawFrame(&dc, button_rect, BUTTON_IN);
        }
        else
        {
            if ((state BAND ODS_DEFAULT) LOR(state BAND ODS_FOCUS))
            {
                bDrawFrame(&dc, button_rect, BUTTON_OUT  BOR   BUTTON_BLACK_BORDER);
            }
            else
            {
                bDrawFrame(&dc, button_rect, BUTTON_OUT);
            }
        }

        if (state BAND ODS_DISABLED)
        {
            offset_button_rect = button_rect;
            shift_it = 1;
            offset_button_rect.left += shift_it;
            offset_button_rect.right -= shift_it;
            offset_button_rect.top += shift_it;
            offset_button_rect.bottom -= shift_it;

            bDrawButtonText(&dc, offset_button_rect, buffer, CLR_BTN_WHITE, Tstyles);
            bDrawButtonText(&dc, button_rect, buffer, CLR_BTN_DGREY, Tstyles);
        }
        else
        {
            bg_col = 0xe000e0; // sob_get(SOB_TEXT_COL, sob_index);
            if (bg_col) bDrawButtonText(&dc, button_rect, buffer, bg_col, Tstyles);
            else bDrawButtonText(&dc, button_rect, buffer, text_colour, Tstyles);
        }

        if (state BAND ODS_FOCUS)
        {
            DrawFocusRect(lpDrawItemStruct->hDC, (LPRECT)&focus_rect);
        }
    }

