#pragma once
#if 1

#define MENUV_IS_2D 0
#define MENUV_HAS_RGB 0
#define MENUV_HAS_EMPTY 0
#define MENUV_HAS_STATE 1
#define MENUV_HAS_EVENTHANDLER 1
#define MENUV_HAS_OWNERDRAWN 0
#define MENUV_HAS_GREY 1
#define MENUV_HAS_SELECTION 0
#define MENUV_HAS_TEXT 0 
#define MENUV_HAS_SUBCLASS 0
#define MENUV_HAS_TITLE 1
#define MENUV_HAS_STRETCH 0
#define MENUV_HAS_LAST 1

#define MENUVCREATEPARAMETERS TCHAR* txt   

// ----------------------------------------------------------------
// forward definition using a typedef
// the actual structure 

// typedef struct MENUVOBJECT  MENUVOBJECT;
// ----------------------------------------------------------------
// do NOT alter the following
// It is overlaid on a SOBDATA structure so they MUST be the same

typedef struct MENUVOBJECT
{
    GENERICSOB
} MENUVOBJECT;

// ----------------------------------------------------------------
// forward definition using a typedef for
// a widget object  (in this case MENUV) specific functional prototypes

typedef myUInt MENUVFNC_SHAKE(MENUVOBJECT*);
typedef MENUVOBJECT* MENUVFNC_LASTOBJECT();

typedef TCHAR* MENUVFNC_GETTEXT(MENUVOBJECT*);
typedef myUInt MENUVFNC_SETTEXT(MENUVOBJECT*, TCHAR*);

typedef myUInt MENUVFNC_NEWITEMTEXT(MENUVOBJECT* thisObject, TCHAR* pText);
typedef TCHAR* MENUVFNC_GETITEMTEXT(MENUVOBJECT*, myUInt );
typedef myUInt MENUVFNC_SETITEMTEXT(MENUVOBJECT*, myUInt , TCHAR*);

typedef myUInt MENUVFNC_GETVALUE(MENUVOBJECT*);
typedef myUInt MENUVFNC_SETVALUE(MENUVOBJECT*, myUInt);
typedef myUInt MENUVFNC_SETEVENTHANDLER(MENUVOBJECT*, EVENTHANDLER);

typedef MENUVOBJECT* MENUVFNC_GETSIBLING(MENUVOBJECT*);

typedef MENUVOBJECT * MENUVFNC_GETOBJECT(MENUVCREATEPARAMETERS);   // some CREATORs only need the new objects "title"
//typedef MENUVOBJECT* MENUVFNC_GETOBJECT(TCHAR* , int nbr); // some need a integer usually to help define the objects height
 
// ----------------------------------------------------------------

typedef struct MENUVMETHODTABLE_ 
{
    MENUVFNC_GETOBJECT* Create;
    MENUVFNC_SHAKE* Delete;


#if MENUV_HAS_RGB
    MENUVFNC_SETVALUE* SetRGB;
#endif


#if MENUV_HAS_EMPTY
    MENUVFNC_SHAKE* Empty;
#endif


#if MENUV_HAS_STATE
    MENUVFNC_GETVALUE* GetState;
    MENUVFNC_SETVALUE* SetState;
    MENUVFNC_SHAKE* ToggleState;
#endif


#if MENUV_HAS_EVENTHANDLER
        MENUVFNC_SETEVENTHANDLER* SetEventHandler;
#endif


#if  MENUV_HAS_GREY
        MENUVFNC_GETVALUE* GetGrey;
        MENUVFNC_SETVALUE* SetGrey;
#endif


#if  MENUV_HAS_SELECTION
        MENUVFNC_GETVALUE* GetSelectionIndex;
        MENUVFNC_SETVALUE* SetSelectionIndex;
        MENUVFNC_NEWITEMTEXT* AddItem;
        MENUVFNC_GETVALUE* GetItemCount;
        MENUVFNC_GETITEMTEXT* GetItemText;
        MENUVFNC_SETITEMTEXT* SetItemCText;
        MENUVFNC_SETVALUE* DeleteIndex;
#endif

#if MENUV_HAS_TITLE
        MENUVFNC_GETTEXT* GetTitle;
        MENUVFNC_SETTEXT* SetTitle;
#endif

#if MENUV_HAS_STRETCH
        MENUVFNC_SETTEXT* SetStretch;
#endif

#if MENUV_HAS_LAST
        MENUVFNC_LASTOBJECT * LastWidget;
#endif


        MENUVFNC_SHAKE * UnStateAll;
        MENUVFNC_GETVALUE* GetUserData;
        MENUVFNC_SETVALUE* SetUserData;

        MENUVFNC_LASTOBJECT*   Spacer;

        MENUVFNC_GETSIBLING* GetChecked;

} MENUVMETHODTABLE;

// ----------------------------------------------------------------
// functional prototype for the  "external" methods of this OBJECT


// ---------------------------------
// this lets us write code of the form
//     MENUVOBJECT myWidget = MENUV.Create( "hello" ) ;   // create a new widget 
//     TCHAR * pwidType = MENUV.GetType (myWid) ;          // get the "type"   of the widget
//     

extern MENUVMETHODTABLE  MENUV;

#endif
