#include "project.h"

#include "sob_con_row_w.h"
CONTAINERINFORM  fnAddToParent, fnUpdateContainer;

static  myUInt fnUpdateContainer(SOBDATA* conData)
{   // conData   = & SOBDATA for the CONTAINER   being updated

    if (conData->subType NEQU SOB_CONTAINER_ROW_W)
    {
        swprintf_s(txtBuffer, szTxtBuffer, L"fnUpdateContainer: SOB_CONTAINER_ROW_W\n");  ReportError(txtBuffer);
        swprintf_s(txtBuffer, szTxtBuffer, L" ***Received a: \n %ws   \n %ws  \n"
        , sob_container_to_text(conData->subType)
        , sob_type_to_text(conData->type)

        );  ReportError(txtBuffer);
        SOB.Report(conData );

        return 0;
    }

    conData->displayX = 0;
    conData->displayY = 0;
    conData->minWidth = 0;

/*

    int ChildFlag = 0;
    SOBDATA* childObject = sob_get_first_child(conData);
    while (childObject)
    {
        childObject->displayHeight = childObject->minHeight;  // unmanaged
        childObject->displayWidth = conData->effectiveWidth;// managed

        childObject->displayX = conData->minWidth;
        childObject->displayY = 0;

        conData->minWidth += conData->effectiveWidth; // managed
        if (conData->nbrChildren > 1)   conData->minWidth += (lEdge + rEdge);

        childObject = sob_get_next_child(childObject);
    }
    conData->minHeight = conData->effectiveHeight;

    conData->ppSobData->pVtbl->Update(conData->ppSobData);

*/
    conData->minWidth = 0;
    conData->minHeight = 0;
    conData->effectiveWidth = 0;
    conData->effectiveHeight = 0;

    int cnt = conData->nbrChildren;
    SOBDATA* childObject = sob_get_first_child(conData);

    while (childObject)
    {
        if (childObject->minWidth > conData->effectiveWidth)  conData->effectiveWidth = childObject->minWidth;
        if (childObject->minHeight > conData->effectiveHeight) conData->effectiveHeight = childObject->minHeight;
        childObject = sob_get_next_child(childObject);
    }

    childObject = sob_get_first_child(conData);

    while (childObject)
    {
        childObject->displayHeight = childObject->minHeight;   // unmanaged
        childObject->displayWidth = conData->effectiveWidth; //   managed

        childObject->displayX = conData->minWidth;
        childObject->displayY = 0;

        conData->minWidth += childObject->displayWidth;
        if (--cnt)   conData->minWidth += (lEdge + rEdge);

        childObject = sob_get_next_child(childObject);
    }
    conData->minHeight = conData->effectiveHeight;

    conData->ppSobData->pVtbl->Update(conData->ppSobData);

    return 0;

}

static myUInt fnAddToParent(SOBDATA* cData)
{   // cData   = & SOBDATA for the CHILD being created

    #if DebuggingAid
        swprintf_s(txtBuffer, szTxtBuffer, L"SOB_CONTAINER_ROW_W  fnAddToParent\n");  ReportError(txtBuffer);
    #endif

    SOBDATA* pData = cData->ppSobData;
    if (cData->minWidth > pData->effectiveWidth)  pData->effectiveWidth = cData->minWidth;
    if (cData->minHeight > pData->effectiveHeight) pData->effectiveHeight = cData->minHeight;

    (void)fnUpdateContainer(pData);  // yes, we call our own fnUpdateContainer

    return 0;
}

static  PVTBL* get_container_vtbl()
{
    static PVTBL conTable;
    static int  conTableFlag = 0;

    if (!conTableFlag)
    {
        conTable.AddChild = fnAddToParent;
        conTable.Update = fnUpdateContainer;

        conTableFlag = 1;
    }
    return &conTable;
}

SOBDATA* sob_con_row_w_new()
{
    int height = 0;
    int width = 0;

    SOBDATA* sData = sob_new_new(SOB_TYPE_CONTAINER, SOB_CONTAINER_ROW_W, width, height);
    if (sData EQU NULL) return NULL;

    sData->pVtbl = (MNGR_METHOD_TABLE_GENERIC*)get_container_vtbl();
    sData->cVtbl = get_container_ctbl_generic();
    DWORD style = (WS_CHILD |   WS_VISIBLE) BAND ~(WS_HSCROLL | WS_VSCROLL);

    (void)sob_CreateWindowExNew(sData, 0, szWindowClass, _TEXT("  "), style);

    return sData;
}

