#if 1

    #include "project.h"

    CONTYPE COLUMNId = SOB_CONTAINER_NO;

SOBDATA* COLUMNLastCreated;

// ---------------------------------

static  myUInt ReSize_COLUMN(SOBDATA* conData)
{   // conData   = address of the SOBDATA of the COLUMN CONTAINER

    // We have a number of things to do here:
    //  set the display height and display width of a child
    //  set the display X and displayY of a child with respect to the containers CLIENT area
    //  set the containers minWidth and minHeight

    // ---------------------------------
    // this container template is configured to
    // - have a border
    // - place its children in a simple column

    // ---------------------------------

    // this function / method is triggered by:
    //  1) adding a new child
    //  2) a change in size of a child that is itself a container
    // so we can NOT assume that we know the largest WIDTH or largest HEIGHT of its children

    // in some types of container we might not care about one or the other
    // but we ALWAYS care about atleast one of them ( i.e.  largest WIDTH or largest HEIGHT )

    //  swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.ReSize\n"));  ReportError(txtBuffer);

    // WARNING: by    managed  I mean that atleast one dimension of a child is managed
    // I can think of the following container types
    //     1 row      unmanaged
    //     1 row      with managed height
    //     n rows     with managed height and managed width
    //     1 row      with managed width   // can look ugly. A row of same width but different heights?

    //     1 column    unmanaged
    //     1 column    with managed width
    //     n columns   with managed height and managed width
    //     1 column    with managed height   // can look ugly. A row of different width but same heights?

    // and then we have the each of these with/without a container border
    // the following code can be used of rall of the above E
    // EXCEPT
    //     n rows     with managed height and managed width
    //     n columns   with managed height and managed width
    //
    // the necessary changes are to values

    // ---------------------------------
    // CUSTOMISE THIS     the initialisation value of   ColOrRow
    // 0    for a ROW  orientated container
    // 1    for a COLUMN  orientated container
    // ---------------------------------

    int ColOrRow = 1;

    // ---------------------------------
    // CUSTOMISE THIS     the initialisation value of   setDefault
    // 0    no width/height management
    // 1         manage HEIGHT  if   ColOrRow   selects ROW = 0
    //      or   manage WIDTH  if   ColOrRow   selects COL = 1
    // ---------------------------------

    int useDefault = 0;

    // ---------------------------------

    int WidestChild = 0, HighestChild = 0;
    conData->minWidth = 0;
    conData->minHeight = 0;

    int cnt = 0;

    // ---------------------------------
    SOBDATA* childObject = COLUMN.FirstChild(conData);

    while (childObject)
    {
        cnt++;

        if (childObject->minWidth > WidestChild)     WidestChild = childObject->minWidth;
        if (childObject->minHeight > HighestChild)   HighestChild = childObject->minHeight;

        conData->minHeight += childObject->minHeight ;
        conData->minWidth += childObject->minWidth ;

        childObject = SOB.GetNextChild(childObject);
    }
    // ---------------------------------

    if(cnt)
    {
        conData->minHeight += ( sobBnd.top +sobBnd.bottom ) * (cnt - 1) ;
        conData->minWidth += (sobBnd.left + sobBnd.right) * (cnt - 1) ;

        conData->minHeight += conData->top + conData->bottom;
        conData->minWidth += conData->left + conData->right;
    }

    // ---------------------------------
    // It took me a long time to sort out containers that have boundaries.
    //
    // If you request a container of says 10 pixels across and 5 pixels down
    // then, IF there is no boundary then that is what you get.
    // No issues!
    //
    //
    // BUT, If you include a boundary in the containers style when calling
    // sob_CreateWindowExNew THEN what happens is:
    //
    // the top and left boundaries, typically of thickness one pixel,
    // are drawn in the top and left edges of the  10 x 5 pixels shape.
    // Is okay.
    // BUT the right and bottom boundaries are drawn AFTER the 10 * 5 pixel area.
    // So the requested 10 x5 shapes occupies   11 x 6 pixels on the screen.
    // AND THEN I want a 1 pixel spacing between the boundaries and the children shape(s).
    // So, if says the area occuppied by the children is say 50 x 25 pixels
    // then we must ask the WINDOWsS drawing routines to draw our container as
    //   boundary width + spacing +  50 + spacing
    //      by
    //   boundary width + spacing + 25 + spacing
    //
    // Whilst for our own management / sizing/ positioning purposes the container is
    // seen as being
    //   boundary width + spacing +  50 + spacing + boundary
    //      by
    //   boundary width + spacing + 25 + spacing + boundary

    //
    // ---------------------------------

    int defaultWidth = 0, defaultHeight = 0;

    if (ColOrRow) // Col or Row
    {
        // COLUMN  orientated container

        conData->minWidth = WidestChild + conData->left + conData->right  ;
        if (useDefault) defaultWidth = WidestChild;
    }
    else
    {
        // ROW  orientated container

        conData->minHeight = HighestChild + conData->top + conData->bottom ;
        if (useDefault) defaultHeight = HighestChild;
    }
    // ---------------------------------

    conData->minWidth  += conData->left + conData->right;
    conData->minHeight += conData->top + conData->bottom;

    // ---------------------------------

    if (conData->displayWidth > conData->minWidth)  WidestChild = conData->displayWidth - (conData->left + conData->right);
    if (conData->displayHeight > conData->minHeight)  HighestChild = conData->displayHeight - (conData->top + conData->bottom);

    // conData->effectiveWidth = conData->minWidth   ;
    // conData->effectiveHeight = conData->minHeight  ;

    // ---------------------------------
    // now set childrens display WIDTH/HEIGHT
    // Ignore any STRETCH effects.
    // Ignore any surround/boundaries.
    // Just set  the width/height of the area that the widget's pixels occupy

    double widthFactor = 0.0;
    double heightFactor = 0.0;

    if (conData->share)
    {
        widthFactor = 1.0 * (double)conData->displayWidth / (double)conData->minWidth;
        heightFactor = 1.0 * (double)conData->displayHeight / (double)conData->minHeight;

        childObject = COLUMN.FirstChild(conData);
        while (childObject)
        {
            if (defaultHeight)  childObject->displayHeight = defaultHeight;
            else childObject->displayHeight = childObject->minHeight;

            childObject->displayHeight = (int) ( childObject->displayHeight * heightFactor);

            if (defaultWidth)  childObject->displayWidth = defaultWidth;
            else childObject->displayWidth = childObject->minWidth;

            childObject->displayWidth = (int)(childObject->displayWidth * widthFactor);

            childObject = SOB.GetNextChild(childObject);
        }

    }
    else
    {
        childObject = COLUMN.FirstChild(conData);
        while (childObject)
        {
            if (defaultHeight)  childObject->displayHeight = defaultHeight;
            else childObject->displayHeight = childObject->minHeight;

            if (defaultWidth)  childObject->displayWidth = defaultWidth;
            else childObject->displayWidth = childObject->minWidth;

            childObject = SOB.GetNextChild(childObject);
        }

    }

    // ---------------------------------
    // now set childrens display POSITIONS
    // of the object in the CLIENT area of the host.
    // So take account of the  sobBnd  values,
    // and of any STRETCHING

    int Xpos = conData->left ;
    int Ypos = conData->top ;
    int freeWidth = 0, freeHeight = 0;

    cnt = 0;

    childObject = COLUMN.FirstChild(conData);
    while (childObject)
    {
        // ---------------------------------
        //   child positioning
        // ---------------------------------
        // Following is good for all container types discussed above.
        // This container does NOT manage its childrens width/height
        // except for a STRETCHED child.

        childObject->displayX = Xpos;
        childObject->displayY = Ypos;

        // ---------------------------------

        if ( conData->stretchSobData EQU childObject)
        {
            if (ColOrRow)
            {
                freeWidth = conData->displayWidth
                - childObject->minWidth
                - conData->left; // -conData->right; // true. weird
                if (defaultWidth) freeWidth = 0;

                freeHeight = conData->displayHeight - conData->minHeight  ;
            }
            else
            {
                // for ROW orientated
                freeWidth = conData->displayWidth - conData->minWidth;

                freeHeight = conData->displayHeight
                - childObject->minHeight
                - conData->top; // -conData->bottom; // true. weird

                if (defaultHeight) freeHeight = 0;
            }
            childObject->displayWidth  += freeWidth  ;
            childObject->displayHeight += freeHeight ;
        }

        // ---------------------------------

        if (ColOrRow)
        {
            Ypos += childObject->displayHeight + sobBnd.bottom + sobBnd.top;
            if (SELF_COLUMN) childObject->displayWidth = WidestChild;
        }

        else
        {
            Xpos += childObject->displayWidth + sobBnd.left + sobBnd.right;

            if (SELF_COLUMN) childObject->displayHeight = HighestChild;

        }
        childObject = SOB.GetNextChild(childObject);
    }

    return SOB_OK;
}

// ---------------------------------

CONTAINERINFORM Display_COLUMN;
static  myUInt Display_COLUMN(SOBDATA* conData)
{   // conData   = & SOBDATA for the CONTAINER   being displayed

    // typically called by a parent container
    // we should display this container and its SOB children, and trigger any child containers to do the same!

    if (fnInvalidSobGeneric(conData))
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.Display given an invalid SOBOBJ\n"));  ReportError(txtBuffer);
        return NULLV;
    }
    if (conData->subType NEQU COLUMNId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.Display given a non COLUMN object\n"));  ReportError(txtBuffer);
        SOB.Report(conData);
        return SOB_NOK;
    }

    //    swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.Display\n"));  addText(txtBuffer);

    // ---------------------------------

    ReSize_COLUMN(conData);

    SOBDATA* childObject = NULL;

    childObject = COLUMN.FirstChild(conData);
    while (childObject)
    {
        if ((childObject->type EQU SOB_TYPE_CONTAINER) LAND(childObject->pVtbl)   LAND(childObject->pVtbl->UpDateChildren))
        CONTAINER.Display(childObject);
        childObject = SOB.GetNextChild(childObject);
    }

    return SOB_OK;
}

// ---------------------------------

CONTAINERCREATE LastWidget_COLUMN;
static SOBDATA* LastWidget_COLUMN()
{
    return  COLUMNLastCreated;
}

// ---------------------------------

SOBFNC_GETTEXT COLUMN_SOB_GetTypeText;
static TCHAR* COLUMN_SOB_GetTypeText(SOBDATA* thisSob)
{
    static TCHAR objType[] = TEXT("COLUMN");
    return  objType;
}

CONTAINERGETTEXT GetTypeText_COLUMN;
static  TCHAR* GetTypeText_COLUMN(SOBDATA* conData)
{

    if (fnInvalidSobGeneric(conData))
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.GetTypeText given an invalid SOBOBJ\n"));  ReportError(txtBuffer);
        return NULL;
    }

    if (conData->subType NEQU COLUMNId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.GetTypeText given a non COLUMN object\n"));  ReportError(txtBuffer);
        SOB.Report(conData);
        return NULL;
    }

    //  swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.GetTypeText\n"));  addText(txtBuffer);

    return   COLUMN_SOB_GetTypeText(conData);
}

// ---------------------------------

CONTAINERINFORM  UpDateChildren_COLUMN;

static  myUInt UpDateChildren_COLUMN(SOBDATA* conData)
{   // conData   = address of the SOBDATA of the COLUMN CONTAINER   that is UPDATING it's children

    // ---------------------------------

    if (fnInvalidSobGeneric(conData))
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.UpDateChildren given an invalid SOBOBJ\n"));  ReportError(txtBuffer);
        return SOB_NOK;
    }

    if (conData->subType NEQU COLUMNId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.UpDateChildren given a non COLUMN object\n"));  ReportError(txtBuffer);
        return SOB_NOK;
    }

    //   swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.UpDateChildren %04i\n"), conData->sIndex)  ;  addText(txtBuffer);

    ReSize_COLUMN(conData);

    SOBDATA* childObject = NULL;

    childObject = COLUMN.FirstChild(conData);
    while (childObject)
    {
        if ((childObject->type EQU SOB_TYPE_CONTAINER) LAND(childObject->pVtbl)   LAND(childObject->pVtbl->UpDateChildren))
        CONTAINER.UpDateChildren(childObject);
        childObject = SOB.GetNextChild(childObject);
    }

    return SOB_OK;
}

// ---------------------------------

CONTAINERINFORM  Open_COLUMN;
static  myUInt Open_COLUMN(SOBDATA* conData)
{   // conData   = address of the SOBDATA of the COLUMN CONTAINER   being Opened
    // i.e. made the parent of container of subsequent children

    // ---------------------------------

    if (fnInvalidSobGeneric(conData))
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.Open given an invalid SOBOBJ\n"));  ReportError(txtBuffer);
        return SOB_NOK;
    }

    if (conData->subType NEQU COLUMNId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.Open given a non COLUMN object\n"));  ReportError(txtBuffer);
        return SOB_NOK;
    }

    // swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.Open\n"));  addText(txtBuffer);

    sob_set_pSobObj(conData);

    return SOB_OK;
}

CONTAINERINFORM  Update_COLUMN;
static  myUInt Update_COLUMN(SOBDATA* conData)
{   // conData   = address of the SOBDATA of the COLUMN CONTAINER   being UPDATED

    // ---------------------------------

    if (fnInvalidSobGeneric(conData))
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.Update given an invalid SOBOBJ\n"));  ReportError(txtBuffer);
        return SOB_NOK;
    }

    if (conData->subType NEQU COLUMNId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.Update given a non COLUMN object\n"));  ReportError(txtBuffer);
        return SOB_NOK;
    }

    // swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.Update\n" )  );  addText(txtBuffer);

    ReSize_COLUMN(conData);

    CONTAINER.Update(conData->ppSobData);

    return SOB_OK;
}

// ---------------------------------
CONTAINERINFORM   UpDateParent_COLUMN ;

static  myUInt UpDateParent_COLUMN(SOBDATA* childObject)
{   // childObject   = address of the SOBDATA of the CHILD object   being added

    // ---------------------------------
    // This is only invoked in the generic function    sob_new_new
    // ---------------------------------

    #if DeveloperMode

        if (fnInvalidSobGeneric(childObject))
        {
            swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.UpDateParent given an invalid SOBOBJ\n"));  ReportError(txtBuffer);
            return SOB_NOK;
        }

        if (childObject->ppSobData->subType NEQU COLUMNId)
        {
            swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.UpDateParent given a CHILD object belonging to a different container\n"));  ReportError(txtBuffer);
            SOB.Report(childObject);
            return SOB_NOK;
        }

        //  swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.UpDateParent\n"));  addText(txtBuffer);
    #endif

    // ---------------------------------

    (void) Update_COLUMN(childObject->ppSobData);

    return SOB_OK;
}
// ---------------------------------
CONTAINERINFORM   Delete_COLUMN;

static  myUInt Delete_COLUMN (SOBDATA* conData)
{   // conData   = address of the SOBDATA of the COLUMN CONTAINER   being DELETED

    // you MUST do checks on the validity of the input
    // Must protect against a "user" trying to delete an already deleted SOB

    if (fnInvalidSobGeneric(conData))
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.Delete given an invalid SOBOBJ\n"));  ReportError(txtBuffer);
        return SOB_NOK;
    }

    if (conData->subType NEQU COLUMNId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.Delete given a non COLUMN object\n"));  ReportError(txtBuffer);
        SOB.Report(conData);
        return SOB_NOK;
    }

    //   swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.Delete\n"));  addText(txtBuffer);

    // ---------------------------------
    // trigger a delete on each child of the container

    SOBDATA* childObject = COLUMN.FirstChild(conData);
    while (childObject)
    {
        if (childObject->type EQU SOB_TYPE_CONTAINER)  CONTAINER.Delete(childObject);  // this "child" is itself a container
        else sobObj_delete(childObject);  //  delete the child's  SOBOBJ

        childObject = SOB.GetFirstChild(conData);  // yes   GetFirstChild,   since we just deleted the original FIRST
    }

    // ---------------------------------

    SOBDATA* pDate = conData->ppSobData;  // get the PARENT of this contaner

    sobObj_delete(conData);  //  delete the container's  SOBOBJ

    CONTAINER.Update(pDate); // trigger an update of the PARENT of the container we have deleted

    return SOB_OK;
}

// ---------------------------------

CONTAINERINFORM   DeleteChildren_COLUMN;
static  myUInt DeleteChildren_COLUMN(SOBDATA* conData)
{   // conData   = address of the SOBDATA of the   CONTAINER  whose children are to be DELETED

    return CONTAINER.DeleteChildren(conData);
}

// ---------------------------------

CONTAINERSETVALUE Stretch_COLUMN;
static myUInt Stretch_COLUMN(SOBDATA* conData, myUInt value)
{   // conData   = address of the SOBDATA of the COLUMN CONTAINER

    // you MUST do checks on the validity of the input
    // Must protect against a "user" trying to do an action on  deleted SOB

    if (fnInvalidSobGeneric(conData))
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.Stretch given an invalid SOBOBJ\n"));  ReportError(txtBuffer);
        return SOB_NOK;
    }

    if (conData->subType NEQU COLUMNId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.Stretch given a non COLUMN object\n"));  ReportError(txtBuffer);
        SOB.Report(conData);
        return SOB_NOK;
    }

    return SOB.SetStretch(conData,   value);
}

// ---------------------------------

CONTAINERSETVALUE Share_COLUMN;
static myUInt Share_COLUMN(SOBDATA* conData, myUInt value)
{   // conData   = address of the SOBDATA of the COLUMN CONTAINER

    // you MUST do checks on the validity of the input
    // Must protect against a "user" trying to do an action on  deleted SOB

    if (fnInvalidSobGeneric(conData))
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.Share given an invalid SOBOBJ\n"));  ReportError(txtBuffer);
        return SOB_NOK;
    }

    if (conData->subType NEQU COLUMNId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.Share given a non COLUMN object\n"));  ReportError(txtBuffer);
        SOB.Report(conData);
        return SOB_NOK;
    }

    return SOB.SetShare(conData, value);
}

// ---------------------------------

CONTAINERGETSOBDATA FirstChild_COLUMN;
static  SOBDATA* FirstChild_COLUMN(SOBDATA* conData)
{
    if (fnInvalidSobGeneric(conData))
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.FirstChild given an invalid SOBOBJ\n"));  ReportError(txtBuffer);
        return NULL;
    }

    if (conData->subType NEQU COLUMNId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COLUMN.FirstChild given a non COLUMN object\n"));  ReportError(txtBuffer);
        SOB.Report(conData);
        return NULL;
    }

    return  conData->headLink;
}

// ---------------------------------

CONTAINERCREATE Create_COLUMN;

static  PVTBL* COLUMN_get_container_vtbl()
{
    static PVTBL conTable;
    static int  conTableFlag = 0;

    if (!conTableFlag)
    {
        // only need to initialise this table once since it is common to all containers of type   COLUMN

        conTable.AddChild = UpDateParent_COLUMN;
        conTable.Update = Update_COLUMN;
        conTable.Delete = Delete_COLUMN;
        conTable.Display = Display_COLUMN;
        conTable.TypeText = GetTypeText_COLUMN;
        conTable.Stretch = Stretch_COLUMN;
        conTable.Create = Create_COLUMN;
        conTable.UpDateChildren = UpDateChildren_COLUMN;
        conTable.ReSize = ReSize_COLUMN;
        conTable.Open = Open_COLUMN;
        conTable.LastWidget = LastWidget_COLUMN;
        conTable.FirstChild = FirstChild_COLUMN;
        conTable.Delete = DeleteChildren_COLUMN;

        conTableFlag = 1;
    }
    return &conTable;
}

// ----------------------------------------------------------------
// the COLUMN "constructor" function
// ----------------------------------------------------------------
// some   containers do not need any parameters
// Modify this to suit your needs

static SOBDATA* internalCreate_COLUMN( )
{
    if (!COLUMNId)   COLUMNId = int_next_contype();

    int height = 0;
    int width = 0;

    SOBDATA* sData = sob_new_new(SOB_TYPE_CONTAINER, COLUMNId, width, height);
    if (sData EQU NULL) return NULL;

    // ---------------------------------
    //  special properties that are COLUMN dependent   and   need to be initialised in the instances data

    // sData->fncCustomDelete;    
    // sData->fncCustomGetTypeText;
    sData->fncCustomGetSubTypeText = COLUMN_SOB_GetTypeText;
    // sData->fncCustomShow;

    // ---------------------------------

    sData->pVtbl = (MNGR_METHOD_TABLE_GENERIC *) COLUMN_get_container_vtbl();
    // sData->cVtbl = get_container_ctbl_generic();

    // ---------------------------------

    DWORD objStyle = (WS_CHILD | WS_VISIBLE | 0) BAND ~(WS_HSCROLL | WS_VSCROLL);

    (void)sob_CreateWindowExNew(sData, 0, szWindowClass, _TEXT("  "), objStyle);

    WINDOWINFO myWI = {0};
    myWI.cbSize = sizeof(WINDOWINFO);
    GetWindowInfo(sData->hWnd, &myWI);
    sData->right = sData->bottom = 0;

    sData->left = (short int) abs(myWI.rcClient.left - myWI.rcWindow.left );
    sData->top =  (short int) abs(myWI.rcWindow.top - myWI.rcClient.top);

    if (sData->left) sData->right = 1 * sData->left;
    if (sData->top) sData->bottom = 1 * sData->top;

    COLUMNLastCreated = sData;

    return sData;
}

static  SOBDATA* Create_COLUMN()
{
    return internalCreate_COLUMN();
}

// ---------------------------------

PVTBL  COLUMN =
{
    UpDateParent_COLUMN
    , Update_COLUMN
    , Delete_COLUMN
    , Display_COLUMN
    , GetTypeText_COLUMN
    , Stretch_COLUMN

    , ReSize_COLUMN
    , UpDateChildren_COLUMN
    , Open_COLUMN
    , LastWidget_COLUMN
    , FirstChild_COLUMN
    , DeleteChildren_COLUMN

    , Create_COLUMN

    , Share_COLUMN
};

#endif
