#pragma once
#if 1

#define RADIOBUTTON_IS_2D 0
#define RADIOBUTTON_HAS_RGB 1
#define RADIOBUTTON_HAS_EMPTY 0
#define RADIOBUTTON_HAS_STATE 1
#define RADIOBUTTON_HAS_EVENTHANDLER 1
#define RADIOBUTTON_HAS_OWNERDRAWN 1
#define RADIOBUTTON_HAS_GREY 0
#define RADIOBUTTON_HAS_SELECTION 0
#define RADIOBUTTON_HAS_TEXT 0 
#define RADIOBUTTON_HAS_SUBCLASS 0
#define RADIOBUTTON_HAS_TITLE 1
#define RADIOBUTTON_HAS_STRETCH 1
#define RADIOBUTTON_HAS_LAST 1


#define RADIOBUTTONCREATEPARAMETERS TCHAR* txt 

// ----------------------------------------------------------------
// forward definition using a typedef
// the actual structure 

// typedef struct RADIOBUTTONOBJECT  RADIOBUTTONOBJECT;
// ----------------------------------------------------------------
// do NOT alter the following
// It is overlaid on a SOBDATA structure so they MUST be the same

typedef struct RADIOBUTTONOBJECT
{
    GENERICSOB
} RADIOBUTTONOBJECT;

// ----------------------------------------------------------------
// forward definition using a typedef for
// a widget object  (in this case RADIOBUTTON) specific functional prototypes

typedef myUInt RADIOBUTTONFNC_SHAKE(RADIOBUTTONOBJECT*);
typedef RADIOBUTTONOBJECT*  RADIOBUTTONFNC_LASTOBJECT();

typedef TCHAR* RADIOBUTTONFNC_GETTEXT(RADIOBUTTONOBJECT*);
typedef myUInt RADIOBUTTONFNC_SETTEXT(RADIOBUTTONOBJECT*, TCHAR*);

typedef myUInt RADIOBUTTONFNC_NEWITEMTEXT(RADIOBUTTONOBJECT* thisObject, TCHAR* pText);
typedef TCHAR* RADIOBUTTONFNC_GETITEMTEXT(RADIOBUTTONOBJECT*, myUInt );
typedef myUInt RADIOBUTTONFNC_SETITEMTEXT(RADIOBUTTONOBJECT*, myUInt , TCHAR*);

typedef myUInt RADIOBUTTONFNC_GETVALUE(RADIOBUTTONOBJECT*);
typedef myUInt RADIOBUTTONFNC_SETVALUE(RADIOBUTTONOBJECT*, myUInt);

typedef myUInt RADIOBUTTONFNC_GETITEMDATA(RADIOBUTTONOBJECT*, myUInt);
typedef myUInt RADIOBUTTONFNC_SETITEMDATA(RADIOBUTTONOBJECT*, myUInt, myUInt);

typedef myUInt RADIOBUTTONFNC_SETEVENTHANDLER(RADIOBUTTONOBJECT*, EVENTHANDLER);

typedef RADIOBUTTONOBJECT * RADIOBUTTONFNC_GETOBJECT(RADIOBUTTONCREATEPARAMETERS);   // some CREATORs only need the new objects "title"
//typedef RADIOBUTTONOBJECT* RADIOBUTTONFNC_GETOBJECT(TCHAR* , int nbr); // some need a integer usually to help define the objects height
 
// ----------------------------------------------------------------

typedef struct RADIOBUTTONMETHODTABLE_ 
{
    RADIOBUTTONFNC_GETOBJECT* Create;
    RADIOBUTTONFNC_SHAKE* Delete;


#if RADIOBUTTON_HAS_RGB
    RADIOBUTTONFNC_SETVALUE* SetRGB;
#endif


#if RADIOBUTTON_HAS_EMPTY
    RADIOBUTTONFNC_SHAKE* Empty;
#endif


#if RADIOBUTTON_HAS_STATE
    RADIOBUTTONFNC_GETVALUE* GetState;
    RADIOBUTTONFNC_SETVALUE* SetState;
    RADIOBUTTONFNC_SHAKE* ToggleState;
#endif


#if RADIOBUTTON_HAS_EVENTHANDLER
        RADIOBUTTONFNC_SETEVENTHANDLER* SetEventHandler;
#endif


#if  RADIOBUTTON_HAS_GREY
        RADIOBUTTONFNC_GETVALUE* GetGrey;
        RADIOBUTTONFNC_SETVALUE* SetGrey;
#endif


#if  RADIOBUTTON_HAS_SELECTION
        RADIOBUTTONFNC_GETVALUE* GetSelectionIndex;
        RADIOBUTTONFNC_SETVALUE* SetSelectionIndex;
        RADIOBUTTONFNC_NEWITEMTEXT* AddItem;
        RADIOBUTTONFNC_GETVALUE* GetItemCount;
        RADIOBUTTONFNC_GETITEMTEXT* GetItemText;
        RADIOBUTTONFNC_SETITEMTEXT* SetItemCText;
        RADIOBUTTONFNC_GETITEMDATA* GetItemData;
        RADIOBUTTONFNC_SETITEMDATA* SetItemData;

        RADIOBUTTONFNC_SETVALUE* DeleteIndex;
#endif

#if RADIOBUTTON_HAS_TITLE
        RADIOBUTTONFNC_GETTEXT* GetTitle;
        RADIOBUTTONFNC_SETTEXT* SetTitle;
#endif

#if RADIOBUTTON_HAS_STRETCH
        RADIOBUTTONFNC_SETVALUE* SetStretch;
#endif

#if RADIOBUTTON_HAS_LAST
        RADIOBUTTONFNC_LASTOBJECT * LastWidget;
#endif
        
        RADIOBUTTONFNC_GETVALUE* GetUserData;
        RADIOBUTTONFNC_SETVALUE* SetUserData;

} RADIOBUTTONMETHODTABLE;

// ----------------------------------------------------------------
// functional prototype for the  "external" methods of this OBJECT


// ---------------------------------
// this lets us write code of the form
//     RADIOBUTTONOBJECT myWidget = RADIOBUTTON.Create( "hello" ) ;   // create a new widget 
//     TCHAR * pwidType = RADIOBUTTON.GetType (myWid) ;          // get the "type"   of the widget
//     

extern RADIOBUTTONMETHODTABLE  RADIOBUTTON;

#endif
