#if 1

    #include "project.h"

    // ----------------------------------------------------------------
    // every function in this source file can be marked as   static
    // except for the "constructor" function
    // ----------------------------------------------------------------

    static MAINTYPE RADIOBUTTONId = SOB_TYPE_NO;

// to allow a widget to change the default handling of a SOB
//  1) create a COPY of the default SOB METHODS TABLE in the widget's code scope
//  2) overwrite the functional pointer, in that COPY, to the address of an
//     appropriate custom function.
//     We do that when the first instance of this widget class is instantiated.
//  3) and then the pointer, in the SOB data, to the default  SOB METHODS TABLE
//     with a pointer to our COPY
//     We do that, after step 2, when the first instance of this widget class is instantiated.

//  here we make SPACE for the COPY of the SOB METHODS TABLE

SOBMETHODSTABLE  RADIOBUTTONSOBMETHODSTABLE;

WNDPROC    wpOrigRADIOBUTTONProc ;

RADIOBUTTONOBJECT* RADIOBUTTONLastCreated;

// ---------------------------------

#if RADIOBUTTON_HAS_SUBCLASS

    // ----------------------------------------------------------------
    //  example of a custom  interception function     for a  subclassed   widget
    // ----------------------------------------------------------------

    static LRESULT CALLBACK RADIOBUTTON_SUBCLASS_proc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    // (demo) function causes the widget to change colour when the mouse hovers over the widget.
    // does not work for all widget types

    TRACKMOUSEEVENT tme = { sizeof(tme) };
    static myInt trackingFlag = 0;
    static COLORREF bgRGBenter = 0;

    union
    {
        SOBDATA* thisSob;
        RADIOBUTTONOBJECT* thisObject;
    } promote = {};

    // be WARNED
    // try to find an OBJECT by the value of a (generic) property, in this case
    // it's  HWND , we default to finding it by it scanning the SOBDATA.
    // If we assume, as in this function, that it was triggered by widget type XYZ
    // then we would need a widget specific search function.
    // So scan the SOBDATA and then "cast" using the union to the appropriate widgettype.

    promote.thisSob = sob_find_hwnd(hwnd);
    if (promote.thisSob)
    {
        switch (msg)
        {
            case WM_NCHITTEST:

                if (!trackingFlag)
                {
                    tme.dwFlags = TME_LEAVE; // TME_HOVER;
                    tme.hwndTrack = hwnd;
                    tme.dwHoverTime = 1000;
                    TrackMouseEvent(&tme);

                    trackingFlag = 1;
                    bgRGBenter = promote.thisObject->bgRGB;

                    RADIOBUTTON.SetRGB(promote.thisObject, RGB(0xc6, 0xe7, 0xff));
                }
                break;

            case WM_MOUSEHOVER:

                break;

            case WM_MOUSELEAVE:
                if (trackingFlag)
                {
                    trackingFlag = 0;
                    RADIOBUTTON.SetRGB(promote.thisObject, bgRGBenter);
                }
                break;

            default:
                break;
        }
    }
    return CallWindowProc(wpOrigRADIOBUTTONProc, hwnd, msg, wParam, lParam);
}

#endif

// ---------------------------------

#if RADIOBUTTON_HAS_OWNERDRAWN
    // ----------------------------------------------------------------
    //  example of a custom  ownerdrawn handler
    // ----------------------------------------------------------------

    OWNDERDRAWNHANDLER RADIOBUTTON_OD_HANDLER;

static void  RADIOBUTTON_OD_HANDLER(SOBDATA* sData, LPDRAWITEMSTRUCT lpDrawItemStruct)
{
    // when the WINDOW message handler is sent a  WM_DRAWITEM message, it will scan
    // the SOB DATA to find the SOB with the HWND referenced by the WM_DRAWITEM message's
    // (LPDRAWITEMSTRUCT)lParam structure.
    // If the  HWND  is found then that SOB's ownerDrawnHandler field is checked for an
    // entry (i.e.  NEQU NULL). If NEQU NULL then the value is treated as a functional pointer
    // a RADIOBUTTON_OD_HANDLER function!

    // the code, bDrawButtonRGB,  is common to BUTTONs and STATIC widgets and is fairly involved.
    // So it has been made a common function located in the  ownderdraw_support files.

    bDrawButtonRGB(sData, lpDrawItemStruct);
}

#endif

// ---------------------------------

#if RADIOBUTTON_HAS_RGB

    RADIOBUTTONFNC_SETVALUE RADIOBUTTON_SetRGB;
static  myUInt RADIOBUTTON_SetRGB(RADIOBUTTONOBJECT* thisObject, myUInt rgbValue)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU RADIOBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("RADIOBUTTON.SetRGB given a non RADIOBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    return sob_SetRGB(thisObject->psSobData, (COLORREF)rgbValue);
}
#endif

// ---------------------------------

#if RADIOBUTTON_HAS_STATE
    // some widget types have a  STATE
    // e.g. menu item ticked, radio button, check button

    RADIOBUTTONFNC_GETVALUE RADIOBUTTON_GetState;
static  myUInt RADIOBUTTON_GetState(RADIOBUTTONOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    if (thisObject->type NEQU RADIOBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("RADIOBUTTON.GetState given a non RADIOBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return
    (  (myInt)SendMessage(thisObject->hWnd, BM_GETCHECK, 0, 0)
    EQU BST_CHECKED
    );
}

// ---------------------------------

RADIOBUTTONFNC_SETVALUE  RADIOBUTTON_SetState;
static  myUInt RADIOBUTTON_SetState(RADIOBUTTONOBJECT* thisObject, myUInt check)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    if (thisObject->type NEQU RADIOBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("RADIOBUTTON.SetState given a non RADIOBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    SOBDATA* pData = thisObject->ppSobData;

    SOBDATA* cData = sob_get_first_child(pData);
    while (cData)
    {
        if (cData->type EQU  RADIOBUTTONId)
        {
            SendMessage
            (cData->hWnd
            , BM_SETCHECK
            , (WPARAM)BST_UNCHECKED
            , 0
            );
        }
        cData = sob_get_next_child(cData);
    }

    if (check) check = BST_CHECKED;
    else  check = BST_UNCHECKED;

    SendMessage
    (thisObject->hWnd
    , BM_SETCHECK
    , (WPARAM)check
    , 0
    );
    return (check EQU BST_CHECKED);
}

// ---------------------------------

RADIOBUTTONFNC_SHAKE RADIOBUTTON_ToggleState;
static  myUInt RADIOBUTTON_ToggleState(RADIOBUTTONOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU RADIOBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("RADIOBUTTON.ToggleState given a non RADIOBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return  RADIOBUTTON.SetState(thisObject, (RADIOBUTTON.GetState(thisObject)  EQU 0));
}

#endif

// ---------------------------------

#if  RADIOBUTTON_HAS_EVENTHANDLER

    // example of a EVENTHANDLER: in this case when the widget is clicked on with the mouse
    // Careful this  function is only valid for widgets that receive
    //   WM_COMMAND messages   carrying a  BN_CLICKED notification

    static void RADIOBUTTON_object_clicked(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam, SOBDATA * sData)
{
    RADIOBUTTONOBJECT* thisObject = (RADIOBUTTONOBJECT*)lParam;
    WORD NotificationCode = HIWORD(wParam);
    WORD identifier = LOWORD(wParam);

    switch (NotificationCode)
    {
        case BN_CLICKED :
            swprintf_s
            (txtBuffer, szTxtBuffer, L" RADIOBUTTON clicked 0x%04x  0x%04x  0x%04x\n"
            , thisObject->sIndex
            , NotificationCode
            , identifier);    addText(txtBuffer);

            SOB.Report((SOBDATA*)thisObject);

            //          RADIOBUTTON.ToggleState(thisObject);

            break;

        default:
            #if DebuggingAid
                swprintf_s
                (txtBuffer, szTxtBuffer, L" RADIOBUTTON unhandled notification 0x%04x  0x%04x  0x%04x\n"
                , thisObject->sIndex
                , NotificationCode
                , identifier);    addText(txtBuffer);
            #endif

            break;
    }
}

RADIOBUTTONFNC_SETEVENTHANDLER RADIOBUTTON_SetEventHandler;
static myUInt RADIOBUTTON_SetEventHandler(RADIOBUTTONOBJECT* thisObject, EVENTHANDLER value)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU RADIOBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("RADIOBUTTON.SetEventHandler given a non RADIOBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    return SOB.SetEventHandler(SOBOBJ thisObject, value);
}

#endif

// ---------------------------------

#if  RADIOBUTTON_HAS_EMPTY
    // some widget types can be emptied e.g. combo boxes, RichTextEdit ..

    RADIOBUTTONFNC_SHAKE RADIOBUTTON_Empty;
static  myUInt RADIOBUTTON_Empty(RADIOBUTTONOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    if (thisObject->type NEQU RADIOBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("RADIOBUTTON.Empty given a non RADIOBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    SendMessage(thisObject->hWnd, CB_RESETCONTENT, 0, 0);

    return  SOB.Empty(SOBOBJ thisObject);
}

#endif

// ---------------------------------

#if  RADIOBUTTON_HAS_GREY
    // some widget types can be greyed e.g. menu items, some button types (rare but possible)

    RADIOBUTTONFNC_SETVALUE RADIOBUTTON_GetGrey;
static  myUInt RADIOBUTTON_GetGrey(RADIOBUTTONOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU RADIOBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("RADIOBUTTON.GetGrey given a non RADIOBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    return  SOB_OK;
}

RADIOBUTTONFNC_SETVALUE RADIOBUTTON_SetGrey;
static  myUInt RADIOBUTTON_SetGrey(RADIOBUTTONOBJECT* thisObject, myUInt value)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    if (thisObject->type NEQU RADIOBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("RADIOBUTTON.SetGrey given a non RADIOBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return  SOB_OK;
}

#endif

// ---------------------------------

#if  RADIOBUTTON_HAS_SELECTION
    // some widget types have selectable items
    // e.g. COMBO boxes, edit fields

    RADIOBUTTONFNC_GETVALUE RADIOBUTTON_GetSelectionIndex;
static  myUInt RADIOBUTTON_GetSelectionIndex(RADIOBUTTONOBJECT* thisObject)
{

    if (thisObject->type NEQU RADIOBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("RADIOBUTTON.GetSelectionIndex given a non RADIOBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if RADIOBUTTON_IS_2D
        return (myInt)SendMessage(thisObject->hWnd, CB_GETCURSEL, 0, 0);
    #endif

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

RADIOBUTTONFNC_SETVALUE RADIOBUTTON_SetSelectionIndex;
static  myUInt RADIOBUTTON_SetSelectionIndex(RADIOBUTTONOBJECT* thisObject, myUInt value)
{
    if (thisObject->type NEQU RADIOBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("RADIOBUTTON.SetSelectionIndex given a non RADIOBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if RADIOBUTTON_IS_2D
        // Sets the ZERO based index to be  the currently selected item of the combo
        return (int)SendMessage(thisObject->hWnd, CB_SETCURSEL, value, 0);
    #endif

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

RADIOBUTTONFNC_GETVALUE RADIOBUTTON_GetItemCount;
static  myUInt RADIOBUTTON_GetItemCount(RADIOBUTTONOBJECT* thisObject)
{

    if (thisObject->type NEQU RADIOBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("RADIOBUTTON.GetItemCount given a non RADIOBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if RADIOBUTTON_IS_2D

        return (myUInt)SendMessage(thisObject->hWnd, CB_GETCOUNT, 0, 0);
    #endif
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

RADIOBUTTONFNC_NEWITEMTEXT RADIOBUTTON_AddItem;
static myUInt RADIOBUTTON_AddItem(RADIOBUTTONOBJECT* thisObject, TCHAR* pText)
{
    if (thisObject->type NEQU RADIOBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("RADIOBUTTON.AddItem given a non RADIOBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if RADIOBUTTON_IS_2D
        int index;

        index = (int)SendMessage(thisObject->hWnd, CB_ADDSTRING, 0, (LPARAM)pText);
        SendMessage(thisObject->hWnd, CB_SETITEMDATA, (WPARAM)index, (LPARAM)index);
        return (myUInt)index;
    #endif

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

RADIOBUTTONFNC_GETITEMTEXT RADIOBUTTON_GetItemText;
static TCHAR* RADIOBUTTON_GetItemText(RADIOBUTTONOBJECT* thisObject, myUInt index)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULL;

    if (thisObject->type NEQU RADIOBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("RADIOBUTTON.GetItemText given a non RADIOBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return NULL;
    }

    #define  TitleMax 255
    static TCHAR title[TitleMax + 1] = { 0 };

    myUInt len = (myUInt) SendMessage(thisObject->hWnd, CB_GETLBTEXTLEN, index, 0); // get character count

    if (len < TitleMax)   SendMessage(thisObject->hWnd, CB_GETLBTEXT, index, (LPARAM)title) ;

    return & title[0];
}

RADIOBUTTONFNC_SETITEMTEXT RADIOBUTTON_SetItemText;
static myUInt RADIOBUTTON_SetItemText(RADIOBUTTONOBJECT* thisObject, myUInt index, TCHAR* title)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU RADIOBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("RADIOBUTTON.SetItemText given a non RADIOBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return (myUInt)  SendMessage(thisObject->hWnd, CB_INSERTSTRING, index, (LPARAM)title);

}

RADIOBUTTONFNC_SETVALUE RADIOBUTTON_DeleteIndex;
static  myUInt RADIOBUTTON_DeleteIndex(RADIOBUTTONOBJECT* thisObject, myUInt value)
{
    if (thisObject->type NEQU RADIOBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("RADIOBUTTON.DeleteIndex given a non RADIOBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if RADIOBUTTON_IS_2D
        // Sets the ZERO based index to be  the currently selected item of the combo
        return (int)SendMessage(thisObject->hWnd, CB_DELETESTRING, value, 0);
    #endif
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

RADIOBUTTONFNC_GETITEMDATA RADIOBUTTON_GetItemData;
static myUInt RADIOBUTTON_GetItemData(RADIOBUTTONOBJECT* thisObject, myUInt itemId)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULL;

    if (thisObject->type NEQU RADIOBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("RADIOBUTTON.GetItemData given a non RADIOBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return   SendMessage(thisObject->hWnd, CB_GETITEMDATA, itemId, 0);
}

RADIOBUTTONFNC_SETITEMDATA RADIOBUTTON_SetItemData;
static myUInt RADIOBUTTON_SetItemData(RADIOBUTTONOBJECT* thisObject, myUInt itemId, myUInt uData)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU RADIOBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("RADIOBUTTON.SetItemData given a non RADIOBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    return  SendMessage(thisObject->hWnd, CB_SETITEMDATA, itemId, uData);;
}

#endif

RADIOBUTTONFNC_GETVALUE  RADIOBUTTON_GetUserData;
static myUInt RADIOBUTTON_GetUserData(RADIOBUTTONOBJECT* thisObject )
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULLV;

    if (thisObject->type NEQU RADIOBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("RADIOBUTTON.GetUserData given a non RADIOBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return NULLV;
    }

    return fnGetUserDataGeneric (SOBOBJ thisObject);
}

RADIOBUTTONFNC_SETVALUE RADIOBUTTON_SetUserData;
static myUInt RADIOBUTTON_SetUserData(RADIOBUTTONOBJECT* thisObject, myUInt value )
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU RADIOBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("RADIOBUTTON.SetUserData given a non RADIOBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return NULLV;
    }      return  fnSetUserDataGeneric(SOBOBJ thisObject, value);

}

// ---------------------------------
#if RADIOBUTTON_HAS_TITLE

    RADIOBUTTONFNC_GETTEXT  RADIOBUTTON_GetTitle;
static TCHAR* RADIOBUTTON_GetTitle(RADIOBUTTONOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULL;
    return   SOB.GetTitle(SOBOBJ thisObject);
}

// ---------------------------------

RADIOBUTTONFNC_SETTEXT  RADIOBUTTON_SetTitle;
static myUInt RADIOBUTTON_SetTitle(RADIOBUTTONOBJECT* thisObject, TCHAR* txt)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return SOB.SetTitle(SOBOBJ thisObject, txt);
}
#endif

// ---------------------------------

SOBFNC_GETTEXT RADIOBUTTON_SOB_GetType;
static TCHAR* RADIOBUTTON_SOB_GetType(SOBDATA* thisSob)
{
    static TCHAR objText[] = TEXT("RADIOBUTTON");
    return  objText;
}

RADIOBUTTONFNC_GETTEXT RADIOBUTTON_GetType;
static  TCHAR* RADIOBUTTON_GetType(RADIOBUTTONOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULL;
    return   RADIOBUTTON_SOB_GetType(SOBOBJ thisObject);
}

// ---------------------------------

RADIOBUTTONFNC_SETVALUE RADIOBUTTON_SetShow;
static  myUInt RADIOBUTTON_SetShow(RADIOBUTTONOBJECT* thisObject, myUInt value)
{
    // this will need customising if the widget is complex
    // i.e. is really a member of a set of  widgets that can not all appear at the same time
    // e.g. a radio button     or an  overlay set

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return SOB.SetShow(SOBOBJ thisObject, value);
}

// ---------------------------------

// ---------------------------------

#if RADIOBUTTON_HAS_STRETCH

    RADIOBUTTONFNC_SETVALUE RADIOBUTTON_SetStretch;
static  myUInt RADIOBUTTON_SetStretch(RADIOBUTTONOBJECT* thisObject, myUInt value)
{

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    SOB.SetStretch(SOBOBJ thisObject, value);

    return SOB.SetShow(SOBOBJ thisObject, value);
}

#endif

// ---------------------------------
#if RADIOBUTTON_HAS_LAST

    RADIOBUTTONFNC_LASTOBJECT RADIOBUTTON_LastWidget;
static  RADIOBUTTONOBJECT*  RADIOBUTTON_LastWidget( )
{
    return RADIOBUTTONLastCreated;
}
#endif

// ----------------------------------------------------------------
// the "destructor" function
// ----------------------------------------------------------------
SOBFNC_SHAKE RADIOBUTTON_SOB_Delete;
static myUInt RADIOBUTTON_SOB_Delete(SOBDATA* thisSob)
{
    // we need this function so that when a CONTAINER is deleted
    // it can trigger a delete of any widget related things of it's child
    // SOB OBJECTs here:-

    if (fnInvalidSobGeneric(thisSob)) return SOB_NOK;

    SOB.Delete(thisSob); // trigger the generic Delete

    return SOB_OK;
}

RADIOBUTTONFNC_SHAKE RADIOBUTTON_Delete;
static  myUInt RADIOBUTTON_Delete(RADIOBUTTONOBJECT* thisObject)
{
    // this will need customising if the widget is complex
    // i.e. is really a set of widgets
    // e.g. an  overlay set

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return   RADIOBUTTON_SOB_Delete(SOBOBJ thisObject  );
}

// ----------------------------------------------------------------
//  inheritance from the underlying SOB
// ----------------------------------------------------------------

// if an inherited function is to be customised/overwritten
// then do it HERE:

RADIOBUTTONFNC_GETTEXT  fnGetTypeTextCustom;
static TCHAR* fnGetTypeTextCustom(RADIOBUTTONOBJECT* sData)
{
    return (TCHAR*)_TEXT("RADIOBUTTON");
}

// ----------------------------------------------------------------
// the "constructor" function
// ----------------------------------------------------------------

RADIOBUTTONFNC_GETOBJECT RADIOBUTTON_Create;
static RADIOBUTTONOBJECT* RADIOBUTTON_Create(RADIOBUTTONCREATEPARAMETERS)
{
    union
    {
        SOBDATA* thisSob;
        RADIOBUTTONOBJECT* thisObject;
    } promote = {0};

    // ---------------------------------
    // in some cases a given widget can only be assigned to certain types of container
    // this is probably the best case to catch such exceptions and
    // permit / block them as appropriate

    // ---------------------------------
    // use the FONT assigned to the PARENT as guidelines for text size

    SOBDATA* pData = sob_get_base(gpSobIndex);
    int nbrLines = 1;  // some CONSTRUCTOR functions want 2 input parameters,
    // typicaly the 2nd parameter is the height of the widget
    // give as the nbr of text lines

    #if RADIOBUTTON_IS_2D
        nbrLines= nbrLines* lines;
    #endif

    int height = 0;
    int width = 0;

    int_sob_text_size(pData, txt, &width, &height);

    // But the HEIGHT only covers text, we need to increase it to allow multiple text
    // lines   AND for any SOB surround
    int objHeight = height * nbrLines + 8;
    int objWidth = width + 20;

    // ---------------------------------
    // A  Screen OBject ( SOB )  is really a structure
    //    the GENERIC structure
    //    and a ptr to the VTABLE
    // ---------------------------------
    // An OBJECT instance is really a structure
    //    the GENERIC structure
    //    and a  ptr to the OBJECT's private functions
    // ---------------------------------
    // So a   SOB   and an    OBJECT     have identical structures
    // WHY:
    // This way we can create a SOB as a sort of generic OBJECT.
    // Some functions, predominantly concerned with
    //    screen size management
    //    screen position management
    //   are OBJECT independent.
    //
    // Then we can have an OBJECT specific "view" were each OBJECT type
    // can have its own strongly typed structure.
    // ---------------------------------

    if (!RADIOBUTTONId)
    {
        // ---------------------------------
        #if DeveloperMode

            union
            {
                myUInt* pEntry;
                void * pVoid;
            } reRef = {0};

            reRef.pVoid = & RADIOBUTTON;
            myUInt* pEntry = reRef.pEntry;

            int entryCount = sizeof(RADIOBUTTONMETHODTABLE) / sizeof(void*);
            int i;
            for (i = 0; i < entryCount; i++)
            {
                if ((!*pEntry)   LOR(*pEntry BAND 0x07))
                { 
                    swprintf_s(txtBuffer, szTxtBuffer, _TEXT("RADIOBUTTON methods table, entry: %02i,  not fully/correctly populated. 0x%llx\n"), i, *pEntry);
                    ReportError(txtBuffer);
                }
                pEntry++;
            }

        #endif

        // ---------------------------------

        RADIOBUTTONId = int_next_maintype();

        // to allow a widget to change the default handling of a SOB
        //  1) create a COPY of the default SOB METHODS TABLE in the widget's code scope
        //  2) overwrite the functional pointer, in that COPY, to the address of an
        //     appropriate custom function.
        //     We do that when the first instance of this widget class is instantiated.
        //  3) and then the pointer, in the SOB data, to the default  SOB METHODS TABLE
        //     with a pointer to our COPY
        //     We do that, after step 2, when the first instance of this widget class is instantiated.

        // ---------------------------------
        //    SPACE for the COPY of the SOB METHODS TABLE  was made at the TOP of this source file
        //    SOBMETHODSTABLE  RADIOBUTTONSOBMETHODSTABLE;
        // ---------------------------------
        // populate the COPY with the default SOB METHID TABLE

        fnInheritSOBmethods( &  RADIOBUTTONSOBMETHODSTABLE);

        // ---------------------------------
        // now populate those entries, in the COPY of the  SOB METHODS TABLE , that are
        // to be widget specific

        RADIOBUTTONSOBMETHODSTABLE.GetType = & RADIOBUTTON_SOB_GetType;

        RADIOBUTTONSOBMETHODSTABLE.Delete = & RADIOBUTTON_SOB_Delete;
    }

    // ---------------------------------

    promote.thisSob = sob_new_new(RADIOBUTTONId, SOB_CONTAINER_NO, objWidth, objHeight);
    if (promote.thisSob EQU NULL)
    {
        int_return_maintype();  //  give the custom RADIOBUTTONId back
        return NULL;
    }

    // ---------------------------------
    // replace the default SOB METHOD TABLE with our widget's custom table

    //  promote.thisSob->sVtbl = &RADIOBUTTONSOBMETHODSTABLE;

    // promote.thisSob->fncCustomDelete;    
    promote.thisSob->fncCustomGetTypeText = RADIOBUTTON_SOB_GetType ;
    // promote.thisSob->fncCustomGetSubTypeText = RADIOBUTTON_SOB_GetType;
    // promote.thisSob->fncCustomShow;

    promote.thisSob->txtRGB = -1; // use system default
    promote.thisSob->bgRGB  = -1; // use system default

    // ---------------------------------
    // create an instance of the  RADIOBUTTON widget on the display

    PCWSTR objClassName = _TEXT(  "BUTTON");
    DWORD objStyle = WS_VISIBLE | WS_CHILD |   BS_AUTORADIOBUTTON | BS_OWNERDRAW ; // | BS_OWNERDRAW;

    (void)sob_CreateWindowExNew(promote.thisSob, 0, objClassName, txt, objStyle);

    #if RADIOBUTTON_HAS_SUBCLASS
        // ---------------------------------
        // if you need to subclass the widget (i.e. intercept its internal message handling)
        // then insert the interception function here.

        wpOrigRADIOBUTTONProc = (WNDPROC)SetWindowLongPtr(promote.thisObject->hWnd, GWLP_WNDPROC, (LONG_PTR)RADIOBUTTON_SUBCLASS_proc);
    #endif

    #if RADIOBUTTON_HAS_OWNERDRAWN
        // ---------------------------------
        // if this widget is ownderdraw then link in the handler here

        promote.thisSob->ownerDrawnHandler = RADIOBUTTON_OD_HANDLER;
    #endif

    #if RADIOBUTTON_HAS_EVENTHANDLER
        // ---------------------------------
        // All OBJECTS are created with a prime/main  EVENTHANDLER
        // For this particular OBJECT the prime/main  EVENTHANDLER
        // is a left mouse click

        // Normally the  "user"  sets a, probably different, EVENTHANDLER for
        // each instantiated widget.

        // If you want you can set a default EVENTHANDLER which the
        // "user" can overwrite for a specific OBJECT
        promote.thisSob->eventHandler = (EVENTHANDLER)RADIOBUTTON_object_clicked;
    #endif
    RADIOBUTTONLastCreated = promote.thisObject;
    return   promote.thisObject;
}

// ----------------------------------------------------------------
// the external view
// ----------------------------------------------------------------

// BE WARNED: must be in the same sequence as the struct defn in the  header file
// if you create custom functions / methods for this widget then they
// MUST be in the struct defn and initialised into this struct instance.

RADIOBUTTONMETHODTABLE  RADIOBUTTON =
{
    RADIOBUTTON_Create
    , RADIOBUTTON_Delete

    #if RADIOBUTTON_HAS_RGB
        , RADIOBUTTON_SetRGB
    #endif

    #if RADIOBUTTON_HAS_EMPTY
        , RADIOBUTTON_Empty
    #endif

    #if RADIOBUTTON_HAS_STATE
        , RADIOBUTTON_GetState
        , RADIOBUTTON_SetState
        , RADIOBUTTON_ToggleState

    #endif

    #if RADIOBUTTON_HAS_EVENTHANDLER
        , RADIOBUTTON_SetEventHandler
    #endif

    #if  RADIOBUTTON_HAS_GREY
        , RADIOBUTTON_GetGrey
        , RADIOBUTTON_SetGrey
    #endif

    #if  RADIOBUTTON_HAS_SELECTION
        , RADIOBUTTON_GetSelectionIndex
        , RADIOBUTTON_SetSelectionIndex

        , RADIOBUTTON_AddItem

        , RADIOBUTTON_GetItemCount

        , RADIOBUTTON_GetItemText
        , RADIOBUTTON_SetItemText

        , RADIOBUTTON_GetItemData
        , RADIOBUTTON_SetItemData

        , RADIOBUTTON_DeleteIndex

    #endif

    #if RADIOBUTTON_HAS_TITLE
        , RADIOBUTTON_GetTitle
        , RADIOBUTTON_SetTitle
    #endif

    #if RADIOBUTTON_HAS_STRETCH
        , RADIOBUTTON_SetStretch
    #endif

    #if RADIOBUTTON_HAS_LAST
        , RADIOBUTTON_LastWidget
    #endif

    , RADIOBUTTON_GetUserData
    , RADIOBUTTON_SetUserData

};

#endif
