#pragma once
#if 1

#define PUSHBUTTON_IS_2D 0
#define PUSHBUTTON_HAS_RGB 1
#define PUSHBUTTON_HAS_EMPTY 0
#define PUSHBUTTON_HAS_STATE 0
#define PUSHBUTTON_HAS_EVENTHANDLER 1
#define PUSHBUTTON_HAS_OWNERDRAWN 1
#define PUSHBUTTON_HAS_GREY 0
#define PUSHBUTTON_HAS_SELECTION 0
#define PUSHBUTTON_HAS_TEXT 0 
#define PUSHBUTTON_HAS_SUBCLASS 0
#define PUSHBUTTON_HAS_TITLE 1
#define PUSHBUTTON_HAS_STRETCH 1
#define PUSHBUTTON_HAS_LAST 1


#define PUSHBUTTONCREATEPARAMETERS TCHAR* txt 

// ----------------------------------------------------------------
// forward definition using a typedef
// the actual structure 

// typedef struct PUSHBUTTONOBJECT  PUSHBUTTONOBJECT;
// ----------------------------------------------------------------
// do NOT alter the following
// It is overlaid on a SOBDATA structure so they MUST be the same

typedef struct PUSHBUTTONOBJECT
{
    GENERICSOB 
} PUSHBUTTONOBJECT;

// ----------------------------------------------------------------
// forward definition using a typedef for
// a widget object  (in this case PUSHBUTTON) specific functional prototypes

typedef myUInt PUSHBUTTONFNC_SHAKE(PUSHBUTTONOBJECT*);
typedef PUSHBUTTONOBJECT*  PUSHBUTTONFNC_LASTOBJECT();

typedef TCHAR* PUSHBUTTONFNC_GETTEXT(PUSHBUTTONOBJECT*);
typedef myUInt PUSHBUTTONFNC_SETTEXT(PUSHBUTTONOBJECT*, TCHAR*);

typedef myUInt PUSHBUTTONFNC_NEWITEMTEXT(PUSHBUTTONOBJECT* thisObject, TCHAR* pText);
typedef TCHAR* PUSHBUTTONFNC_GETITEMTEXT(PUSHBUTTONOBJECT*, myUInt );
typedef myUInt PUSHBUTTONFNC_SETITEMTEXT(PUSHBUTTONOBJECT*, myUInt , TCHAR*);

typedef myUInt PUSHBUTTONFNC_GETVALUE(PUSHBUTTONOBJECT*);
typedef myUInt PUSHBUTTONFNC_SETVALUE(PUSHBUTTONOBJECT*, myUInt);

typedef myUInt PUSHBUTTONFNC_GETITEMDATA(PUSHBUTTONOBJECT*, myUInt);
typedef myUInt PUSHBUTTONFNC_SETITEMDATA(PUSHBUTTONOBJECT*, myUInt, myUInt);

typedef myUInt PUSHBUTTONFNC_SETEVENTHANDLER(PUSHBUTTONOBJECT*, EVENTHANDLER);

typedef PUSHBUTTONOBJECT * PUSHBUTTONFNC_GETOBJECT(PUSHBUTTONCREATEPARAMETERS);   // some CREATORs only need the new objects "title"
//typedef PUSHBUTTONOBJECT* PUSHBUTTONFNC_GETOBJECT(TCHAR* , int nbr); // some need a integer usually to help define the objects height
 
// ----------------------------------------------------------------

typedef struct PUSHBUTTONMETHODTABLE_ 
{
    PUSHBUTTONFNC_GETOBJECT* Create;
    PUSHBUTTONFNC_SHAKE* Delete;


#if PUSHBUTTON_HAS_RGB
    PUSHBUTTONFNC_SETVALUE* SetRGB;
#endif


#if PUSHBUTTON_HAS_EMPTY
    PUSHBUTTONFNC_SHAKE* Empty;
#endif


#if PUSHBUTTON_HAS_STATE
    PUSHBUTTONFNC_GETVALUE* GetState;
    PUSHBUTTONFNC_SETVALUE* SetState;
    PUSHBUTTONFNC_SHAKE* ToggleState;
#endif


#if PUSHBUTTON_HAS_EVENTHANDLER
        PUSHBUTTONFNC_SETEVENTHANDLER* SetEventHandler;
#endif


#if  PUSHBUTTON_HAS_GREY
        PUSHBUTTONFNC_GETVALUE* GetGrey;
        PUSHBUTTONFNC_SETVALUE* SetGrey;
#endif


#if  PUSHBUTTON_HAS_SELECTION
        PUSHBUTTONFNC_GETVALUE* GetSelectionIndex;
        PUSHBUTTONFNC_SETVALUE* SetSelectionIndex;
        PUSHBUTTONFNC_NEWITEMTEXT* AddItem;
        PUSHBUTTONFNC_GETVALUE* GetItemCount;
        PUSHBUTTONFNC_GETITEMTEXT* GetItemText;
        PUSHBUTTONFNC_SETITEMTEXT* SetItemCText;
        PUSHBUTTONFNC_GETITEMDATA* GetItemData;
        PUSHBUTTONFNC_SETITEMDATA* SetItemData;

        PUSHBUTTONFNC_SETVALUE* DeleteIndex;
#endif

#if PUSHBUTTON_HAS_TITLE
        PUSHBUTTONFNC_GETTEXT* GetTitle;
        PUSHBUTTONFNC_SETTEXT* SetTitle;
#endif

#if PUSHBUTTON_HAS_STRETCH
        PUSHBUTTONFNC_SETVALUE* SetStretch;
#endif

#if PUSHBUTTON_HAS_LAST
        PUSHBUTTONFNC_LASTOBJECT * LastWidget;
#endif
        
        PUSHBUTTONFNC_GETVALUE* GetUserData;
        PUSHBUTTONFNC_SETVALUE* SetUserData;

} PUSHBUTTONMETHODTABLE;

// ----------------------------------------------------------------
// functional prototype for the  "external" methods of this OBJECT


// ---------------------------------
// this lets us write code of the form
//     PUSHBUTTONOBJECT myWidget = PUSHBUTTON.Create( "hello" ) ;   // create a new widget 
//     TCHAR * pwidType = PUSHBUTTON.GetType (myWid) ;          // get the "type"   of the widget
//     

extern PUSHBUTTONMETHODTABLE  PUSHBUTTON;

#endif
