#if 1

    #include "project.h"

    // ----------------------------------------------------------------
    // every function in this source file can be marked as   static
    // except for the "constructor" function
    // ----------------------------------------------------------------

    static MAINTYPE PUSHBUTTONId = SOB_TYPE_NO;

// to allow a widget to change the default handling of a SOB
//  1) create a COPY of the default SOB METHODS TABLE in the widget's code scope
//  2) overwrite the functional pointer, in that COPY, to the address of an
//     appropriate custom function.
//     We do that when the first instance of this widget class is instantiated.
//  3) and then the pointer, in the SOB data, to the default  SOB METHODS TABLE
//     with a pointer to our COPY
//     We do that, after step 2, when the first instance of this widget class is instantiated.

//  here we make SPACE for the COPY of the SOB METHODS TABLE

SOBMETHODSTABLE  PUSHBUTTONSOBMETHODSTABLE;

WNDPROC    wpOrigPUSHBUTTONProc ;

PUSHBUTTONOBJECT* PUSHBUTTONLastCreated;

// ---------------------------------

#if PUSHBUTTON_HAS_SUBCLASS

    // ----------------------------------------------------------------
    //  example of a custom  interception function     for a  subclassed   widget
    // ----------------------------------------------------------------

    static LRESULT CALLBACK PUSHBUTTON_SUBCLASS_proc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    // (demo) function causes the widget to change colour when the mouse hovers over the widget.
    // does not work for all widget types

    TRACKMOUSEEVENT tme = { sizeof(tme) };
    static myInt trackingFlag = 0;
    static COLORREF bgRGBenter = 0;

    union
    {
        SOBDATA* thisSob;
        PUSHBUTTONOBJECT* thisObject;
    } promote = {};

    // be WARNED
    // try to find an OBJECT by the value of a (generic) property, in this case
    // it's  HWND , we default to finding it by it scanning the SOBDATA.
    // If we assume, as in this function, that it was triggered by widget type XYZ
    // then we would need a widget specific search function.
    // So scan the SOBDATA and then "cast" using the union to the appropriate widgettype.

    promote.thisSob = sob_find_hwnd(hwnd);
    if (promote.thisSob)
    {
        switch (msg)
        {
            case WM_NCHITTEST:

                if (!trackingFlag)
                {
                    tme.dwFlags = TME_LEAVE; // TME_HOVER;
                    tme.hwndTrack = hwnd;
                    tme.dwHoverTime = 1000;
                    TrackMouseEvent(&tme);

                    trackingFlag = 1;
                    bgRGBenter = promote.thisObject->bgRGB;

                    PUSHBUTTON.SetRGB(promote.thisObject, RGB(0xc6, 0xe7, 0xff));
                }
                break;

            case WM_MOUSEHOVER:

                break;

            case WM_MOUSELEAVE:
                if (trackingFlag)
                {
                    trackingFlag = 0;
                    PUSHBUTTON.SetRGB(promote.thisObject, bgRGBenter);
                }
                break;

            default:
                break;
        }
    }
    return CallWindowProc(wpOrigPUSHBUTTONProc, hwnd, msg, wParam, lParam);
}

#endif

// ---------------------------------

#if PUSHBUTTON_HAS_OWNERDRAWN
    // ----------------------------------------------------------------
    //  example of a custom  ownerdrawn handler
    // ----------------------------------------------------------------

    OWNDERDRAWNHANDLER PUSHBUTTON_OD_HANDLER;

static void  PUSHBUTTON_OD_HANDLER(SOBDATA* sData, LPDRAWITEMSTRUCT lpDrawItemStruct)
{
    // when the WINDOW message handler is sent a  WM_DRAWITEM message, it will scan
    // the SOB DATA to find the SOB with the HWND referenced by the WM_DRAWITEM message's
    // (LPDRAWITEMSTRUCT)lParam structure.
    // If the  HWND  is found then that SOB's ownerDrawnHandler field is checked for an
    // entry (i.e.  NEQU NULL). If NEQU NULL then the value is treated as a functional pointer
    // a PUSHBUTTON_OD_HANDLER function!

    // the code, bDrawButtonRGB,  is common to BUTTONs and STATIC widgets and is fairly involved.
    // So it has been made a common function located in the  ownderdraw_support files.

    bDrawButtonRGB(sData, lpDrawItemStruct);
}

#endif

// ---------------------------------

#if PUSHBUTTON_HAS_RGB

    PUSHBUTTONFNC_SETVALUE PUSHBUTTON_SetRGB;
static  myUInt PUSHBUTTON_SetRGB(PUSHBUTTONOBJECT* thisObject, myUInt rgbValue)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU PUSHBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("PUSHBUTTON.SetRGB given a non PUSHBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    return sob_SetRGB(thisObject->psSobData, (COLORREF)rgbValue);
}
#endif

// ---------------------------------

#if PUSHBUTTON_HAS_STATE
    // some widget types have a  STATE
    // e.g. menu item ticked, radio button, check button

    PUSHBUTTONFNC_GETVALUE PUSHBUTTON_GetState;
static  myUInt PUSHBUTTON_GetState(PUSHBUTTONOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    if (thisObject->type NEQU PUSHBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("PUSHBUTTON.GetState given a non PUSHBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return
    (  (myInt)SendMessage(thisObject->hWnd, BM_GETCHECK, 0, 0)
    EQU BST_CHECKED
    );
}

// ---------------------------------

PUSHBUTTONFNC_SETVALUE  PUSHBUTTON_SetState;
static  myUInt PUSHBUTTON_SetState(PUSHBUTTONOBJECT* thisObject, myUInt check)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    if (thisObject->type NEQU PUSHBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("PUSHBUTTON.SetState given a non PUSHBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    SOBDATA* pData = thisObject->ppSobData;

    SOBDATA* cData = sob_get_first_child(pData);
    while (cData)
    {
        if (cData->type EQU  PUSHBUTTONId)
        {
            SendMessage
            (cData->hWnd
            , BM_SETCHECK
            , (WPARAM)BST_UNCHECKED
            , 0
            );
        }
        cData = sob_get_next_child(cData);
    }

    if (check) check = BST_CHECKED;
    else  check = BST_UNCHECKED;

    SendMessage
    (thisObject->hWnd
    , BM_SETCHECK
    , (WPARAM)check
    , 0
    );
    return (check EQU BST_CHECKED);
}

// ---------------------------------

PUSHBUTTONFNC_SHAKE PUSHBUTTON_ToggleState;
static  myUInt PUSHBUTTON_ToggleState(PUSHBUTTONOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU PUSHBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("PUSHBUTTON.ToggleState given a non PUSHBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return  PUSHBUTTON.SetState(thisObject, (PUSHBUTTON.GetState(thisObject)  EQU 0));
}

#endif

// ---------------------------------

#if  PUSHBUTTON_HAS_EVENTHANDLER

    // example of a EVENTHANDLER: in this case when the widget is clicked on with the mouse
    // Careful this  function is only valid for widgets that receive
    //   WM_COMMAND messages   carrying a  BN_CLICKED notification

    static void PUSHBUTTON_object_clicked(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam, SOBDATA * sData)
{
    PUSHBUTTONOBJECT* thisObject = (PUSHBUTTONOBJECT*)lParam;
    WORD NotificationCode = HIWORD(wParam);
    WORD identifier = LOWORD(wParam);

    switch (NotificationCode)
    {
        case BN_CLICKED :
            swprintf_s
            (txtBuffer, szTxtBuffer, L" PUSHBUTTON clicked 0x%04x  0x%04x  0x%04x\n"
            , thisObject->sIndex
            , NotificationCode
            , identifier);    addText(txtBuffer);

            SOB.Report((SOBDATA*)thisObject);

            //          PUSHBUTTON.ToggleState(thisObject);

            break;

        default:
            #if DebuggingAid
                swprintf_s
                (txtBuffer, szTxtBuffer, L" PUSHBUTTON unhandled notification 0x%04x  0x%04x  0x%04x\n"
                , thisObject->sIndex
                , NotificationCode
                , identifier);    addText(txtBuffer);
            #endif

            break;
    }
}

PUSHBUTTONFNC_SETEVENTHANDLER PUSHBUTTON_SetEventHandler;
static myUInt PUSHBUTTON_SetEventHandler(PUSHBUTTONOBJECT* thisObject, EVENTHANDLER value)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU PUSHBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("PUSHBUTTON.SetEventHandler given a non PUSHBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    return SOB.SetEventHandler(SOBOBJ thisObject, value);
}

#endif

// ---------------------------------

#if  PUSHBUTTON_HAS_EMPTY
    // some widget types can be emptied e.g. combo boxes, RichTextEdit ..

    PUSHBUTTONFNC_SHAKE PUSHBUTTON_Empty;
static  myUInt PUSHBUTTON_Empty(PUSHBUTTONOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    if (thisObject->type NEQU PUSHBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("PUSHBUTTON.Empty given a non PUSHBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    SendMessage(thisObject->hWnd, CB_RESETCONTENT, 0, 0);

    return  SOB.Empty(SOBOBJ thisObject);
}

#endif

// ---------------------------------

#if  PUSHBUTTON_HAS_GREY
    // some widget types can be greyed e.g. menu items, some button types (rare but possible)

    PUSHBUTTONFNC_SETVALUE PUSHBUTTON_GetGrey;
static  myUInt PUSHBUTTON_GetGrey(PUSHBUTTONOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU PUSHBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("PUSHBUTTON.GetGrey given a non PUSHBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    return  SOB_OK;
}

PUSHBUTTONFNC_SETVALUE PUSHBUTTON_SetGrey;
static  myUInt PUSHBUTTON_SetGrey(PUSHBUTTONOBJECT* thisObject, myUInt value)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    if (thisObject->type NEQU PUSHBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("PUSHBUTTON.SetGrey given a non PUSHBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return  SOB_OK;
}

#endif

// ---------------------------------

#if  PUSHBUTTON_HAS_SELECTION
    // some widget types have selectable items
    // e.g. COMBO boxes, edit fields

    PUSHBUTTONFNC_GETVALUE PUSHBUTTON_GetSelectionIndex;
static  myUInt PUSHBUTTON_GetSelectionIndex(PUSHBUTTONOBJECT* thisObject)
{

    if (thisObject->type NEQU PUSHBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("PUSHBUTTON.GetSelectionIndex given a non PUSHBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if PUSHBUTTON_IS_2D
        return (myInt)SendMessage(thisObject->hWnd, CB_GETCURSEL, 0, 0);
    #endif

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

PUSHBUTTONFNC_SETVALUE PUSHBUTTON_SetSelectionIndex;
static  myUInt PUSHBUTTON_SetSelectionIndex(PUSHBUTTONOBJECT* thisObject, myUInt value)
{
    if (thisObject->type NEQU PUSHBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("PUSHBUTTON.SetSelectionIndex given a non PUSHBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if PUSHBUTTON_IS_2D
        // Sets the ZERO based index to be  the currently selected item of the combo
        return (int)SendMessage(thisObject->hWnd, CB_SETCURSEL, value, 0);
    #endif

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

PUSHBUTTONFNC_GETVALUE PUSHBUTTON_GetItemCount;
static  myUInt PUSHBUTTON_GetItemCount(PUSHBUTTONOBJECT* thisObject)
{

    if (thisObject->type NEQU PUSHBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("PUSHBUTTON.GetItemCount given a non PUSHBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if PUSHBUTTON_IS_2D

        return (myUInt)SendMessage(thisObject->hWnd, CB_GETCOUNT, 0, 0);
    #endif
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

PUSHBUTTONFNC_NEWITEMTEXT PUSHBUTTON_AddItem;
static myUInt PUSHBUTTON_AddItem(PUSHBUTTONOBJECT* thisObject, TCHAR* pText)
{
    if (thisObject->type NEQU PUSHBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("PUSHBUTTON.AddItem given a non PUSHBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if PUSHBUTTON_IS_2D
        int index;

        index = (int)SendMessage(thisObject->hWnd, CB_ADDSTRING, 0, (LPARAM)pText);
        SendMessage(thisObject->hWnd, CB_SETITEMDATA, (WPARAM)index, (LPARAM)index);
        return (myUInt)index;
    #endif

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

PUSHBUTTONFNC_GETITEMTEXT PUSHBUTTON_GetItemText;
static TCHAR* PUSHBUTTON_GetItemText(PUSHBUTTONOBJECT* thisObject, myUInt index)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULL;

    if (thisObject->type NEQU PUSHBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("PUSHBUTTON.GetItemText given a non PUSHBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return NULL;
    }

    #define  TitleMax 255
    static TCHAR title[TitleMax + 1] = { 0 };

    myUInt len = (myUInt) SendMessage(thisObject->hWnd, CB_GETLBTEXTLEN, index, 0); // get character count

    if (len < TitleMax)   SendMessage(thisObject->hWnd, CB_GETLBTEXT, index, (LPARAM)title) ;

    return & title[0];
}

PUSHBUTTONFNC_SETITEMTEXT PUSHBUTTON_SetItemText;
static myUInt PUSHBUTTON_SetItemText(PUSHBUTTONOBJECT* thisObject, myUInt index, TCHAR* title)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU PUSHBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("PUSHBUTTON.SetItemText given a non PUSHBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return (myUInt)  SendMessage(thisObject->hWnd, CB_INSERTSTRING, index, (LPARAM)title);

}

PUSHBUTTONFNC_SETVALUE PUSHBUTTON_DeleteIndex;
static  myUInt PUSHBUTTON_DeleteIndex(PUSHBUTTONOBJECT* thisObject, myUInt value)
{
    if (thisObject->type NEQU PUSHBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("PUSHBUTTON.DeleteIndex given a non PUSHBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if PUSHBUTTON_IS_2D
        // Sets the ZERO based index to be  the currently selected item of the combo
        return (int)SendMessage(thisObject->hWnd, CB_DELETESTRING, value, 0);
    #endif
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

PUSHBUTTONFNC_GETITEMDATA PUSHBUTTON_GetItemData;
static myUInt PUSHBUTTON_GetItemData(PUSHBUTTONOBJECT* thisObject, myUInt itemId)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULL;

    if (thisObject->type NEQU PUSHBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("PUSHBUTTON.GetItemData given a non PUSHBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return   SendMessage(thisObject->hWnd, CB_GETITEMDATA, itemId, 0);
}

PUSHBUTTONFNC_SETITEMDATA PUSHBUTTON_SetItemData;
static myUInt PUSHBUTTON_SetItemData(PUSHBUTTONOBJECT* thisObject, myUInt itemId, myUInt uData)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU PUSHBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("PUSHBUTTON.SetItemData given a non PUSHBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    return  SendMessage(thisObject->hWnd, CB_SETITEMDATA, itemId, uData);;
}

#endif

PUSHBUTTONFNC_GETVALUE  PUSHBUTTON_GetUserData;
static myUInt PUSHBUTTON_GetUserData(PUSHBUTTONOBJECT* thisObject )
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULLV;

    if (thisObject->type NEQU PUSHBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("PUSHBUTTON.GetUserData given a non PUSHBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return NULLV;
    }

    return fnGetUserDataGeneric (SOBOBJ thisObject);
}

PUSHBUTTONFNC_SETVALUE PUSHBUTTON_SetUserData;
static myUInt PUSHBUTTON_SetUserData(PUSHBUTTONOBJECT* thisObject, myUInt value )
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU PUSHBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("PUSHBUTTON.SetUserData given a non PUSHBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return NULLV;
    }      return  fnSetUserDataGeneric(SOBOBJ thisObject, value);

}

// ---------------------------------
#if PUSHBUTTON_HAS_TITLE

    PUSHBUTTONFNC_GETTEXT  PUSHBUTTON_GetTitle;
static TCHAR* PUSHBUTTON_GetTitle(PUSHBUTTONOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULL;
    return   SOB.GetTitle(SOBOBJ thisObject);
}

// ---------------------------------

PUSHBUTTONFNC_SETTEXT  PUSHBUTTON_SetTitle;
static myUInt PUSHBUTTON_SetTitle(PUSHBUTTONOBJECT* thisObject, TCHAR* txt)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return SOB.SetTitle(SOBOBJ thisObject, txt);
}
#endif

// ---------------------------------

SOBFNC_GETTEXT PUSHBUTTON_SOB_GetType;
static TCHAR* PUSHBUTTON_SOB_GetType(SOBDATA* thisSob)
{
    static TCHAR objText[] = TEXT("PUSHBUTTON");
    return  objText;
}

PUSHBUTTONFNC_GETTEXT PUSHBUTTON_GetType;
static  TCHAR* PUSHBUTTON_GetType(PUSHBUTTONOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULL;
    return   PUSHBUTTON_SOB_GetType(SOBOBJ thisObject);
}

// ---------------------------------

PUSHBUTTONFNC_SETVALUE PUSHBUTTON_SetShow;
static  myUInt PUSHBUTTON_SetShow(PUSHBUTTONOBJECT* thisObject, myUInt value)
{
    // this will need customising if the widget is complex
    // i.e. is really a member of a set of  widgets that can not all appear at the same time
    // e.g. a radio button     or an  overlay set

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return SOB.SetShow(SOBOBJ thisObject, value);
}

// ---------------------------------

// ---------------------------------

#if PUSHBUTTON_HAS_STRETCH

    PUSHBUTTONFNC_SETVALUE PUSHBUTTON_SetStretch;
static  myUInt PUSHBUTTON_SetStretch(PUSHBUTTONOBJECT* thisObject, myUInt value)
{

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    SOB.SetStretch(SOBOBJ thisObject, value);

    return SOB.SetShow(SOBOBJ thisObject, value);
}

#endif

// ---------------------------------
#if PUSHBUTTON_HAS_LAST

    PUSHBUTTONFNC_LASTOBJECT PUSHBUTTON_LastWidget;
static  PUSHBUTTONOBJECT*  PUSHBUTTON_LastWidget( )
{
    return PUSHBUTTONLastCreated;
}
#endif

// ----------------------------------------------------------------
// the "destructor" function
// ----------------------------------------------------------------
SOBFNC_SHAKE PUSHBUTTON_SOB_Delete;
static myUInt PUSHBUTTON_SOB_Delete(SOBDATA* thisSob)
{
    // we need this function so that when a CONTAINER is deleted
    // it can trigger a delete of any widget related things of it's child
    // SOB OBJECTs here:-

    if (fnInvalidSobGeneric(thisSob)) return SOB_NOK;

    SOB.Delete(thisSob); // trigger the generic Delete

    return SOB_OK;
}

PUSHBUTTONFNC_SHAKE PUSHBUTTON_Delete;
static  myUInt PUSHBUTTON_Delete(PUSHBUTTONOBJECT* thisObject)
{
    // this will need customising if the widget is complex
    // i.e. is really a set of widgets
    // e.g. an  overlay set

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return   PUSHBUTTON_SOB_Delete(SOBOBJ thisObject  );
}

// ----------------------------------------------------------------
//  inheritance from the underlying SOB
// ----------------------------------------------------------------

// if an inherited function is to be customised/overwritten
// then do it HERE:

PUSHBUTTONFNC_GETTEXT  fnGetTypeTextCustom;
static TCHAR* fnGetTypeTextCustom(PUSHBUTTONOBJECT* sData)
{
    return (TCHAR*)_TEXT("PUSHBUTTON");
}

// ----------------------------------------------------------------
// the "constructor" function
// ----------------------------------------------------------------

PUSHBUTTONFNC_GETOBJECT PUSHBUTTON_Create;
static PUSHBUTTONOBJECT* PUSHBUTTON_Create(PUSHBUTTONCREATEPARAMETERS)
{
    union
    {
        SOBDATA* thisSob;
        PUSHBUTTONOBJECT* thisObject;
    } promote = {0};

    // ---------------------------------
    // in some cases a given widget can only be assigned to certain types of container
    // this is probably the best case to catch such exceptions and
    // permit / block them as appropriate

    // ---------------------------------
    // use the FONT assigned to the PARENT as guidelines for text size

    SOBDATA* pData = sob_get_base(gpSobIndex);
    int nbrLines = 1;  // some CONSTRUCTOR functions want 2 input parameters,
    // typicaly the 2nd parameter is the height of the widget
    // give as the nbr of text lines

    #if PUSHBUTTON_IS_2D
        nbrLines= nbrLines* lines;
    #endif

    int height = 0;
    int width = 0;

    int_sob_text_size(pData, txt, &width, &height);

    // But the HEIGHT only covers text, we need to increase it to allow multiple text
    // lines   AND for any SOB surround
    int objHeight = height * nbrLines + 8;
    int objWidth = width + 20;

    // ---------------------------------
    // A  Screen OBject ( SOB )  is really a structure
    //    the GENERIC structure
    //    and a ptr to the VTABLE
    // ---------------------------------
    // An OBJECT instance is really a structure
    //    the GENERIC structure
    //    and a  ptr to the OBJECT's private functions
    // ---------------------------------
    // So a   SOB   and an    OBJECT     have identical structures
    // WHY:
    // This way we can create a SOB as a sort of generic OBJECT.
    // Some functions, predominantly concerned with
    //    screen size management
    //    screen position management
    //   are OBJECT independent.
    //
    // Then we can have an OBJECT specific "view" were each OBJECT type
    // can have its own strongly typed structure.
    // ---------------------------------

    if (!PUSHBUTTONId)
    {
        // ---------------------------------
        #if DeveloperMode

            union
            {
                myUInt* pEntry;
                void * pVoid;
            } reRef = {0};

            reRef.pVoid = & PUSHBUTTON;
            myUInt* pEntry = reRef.pEntry;

            int entryCount = sizeof(PUSHBUTTONMETHODTABLE) / sizeof(void*);
            int i;
            for (i = 0; i < entryCount; i++)
            {
                if ((!*pEntry)   LOR(*pEntry BAND 0x07))
                { 
                    swprintf_s(txtBuffer, szTxtBuffer, _TEXT("PUSHBUTTON methods table, entry: %02i,  not fully/correctly populated. 0x%llx\n"), i, *pEntry);
                    ReportError(txtBuffer);
                }
                pEntry++;
            }

        #endif

        // ---------------------------------

        PUSHBUTTONId = int_next_maintype();

        // to allow a widget to change the default handling of a SOB
        //  1) create a COPY of the default SOB METHODS TABLE in the widget's code scope
        //  2) overwrite the functional pointer, in that COPY, to the address of an
        //     appropriate custom function.
        //     We do that when the first instance of this widget class is instantiated.
        //  3) and then the pointer, in the SOB data, to the default  SOB METHODS TABLE
        //     with a pointer to our COPY
        //     We do that, after step 2, when the first instance of this widget class is instantiated.

        // ---------------------------------
        //    SPACE for the COPY of the SOB METHODS TABLE  was made at the TOP of this source file
        //    SOBMETHODSTABLE  PUSHBUTTONSOBMETHODSTABLE;
        // ---------------------------------
        // populate the COPY with the default SOB METHID TABLE

        fnInheritSOBmethods( &  PUSHBUTTONSOBMETHODSTABLE);

        // ---------------------------------
        // now populate those entries, in the COPY of the  SOB METHODS TABLE , that are
        // to be widget specific

        PUSHBUTTONSOBMETHODSTABLE.GetType = & PUSHBUTTON_SOB_GetType;

        PUSHBUTTONSOBMETHODSTABLE.Delete = & PUSHBUTTON_SOB_Delete;
    }

    // ---------------------------------

    promote.thisSob = sob_new_new(PUSHBUTTONId, SOB_CONTAINER_NO, objWidth, objHeight);
    if (promote.thisSob EQU NULL)
    {
        int_return_maintype();  //  give the custom PUSHBUTTONId back
        return NULL;
    }

    // ---------------------------------
    // replace the default SOB METHOD TABLE with our widget's custom table

    //  promote.thisSob->sVtbl = &PUSHBUTTONSOBMETHODSTABLE;

    // promote.thisSob->fncCustomDelete;    
    promote.thisSob->fncCustomGetTypeText = PUSHBUTTON_SOB_GetType ;
    // promote.thisSob->fncCustomGetSubTypeText = PUSHBUTTON_SOB_GetType;
    // promote.thisSob->fncCustomShow;

    promote.thisSob->txtRGB = -1; // use system default
    promote.thisSob->bgRGB  = -1; // use system default

    // ---------------------------------
    // create an instance of the  PUSHBUTTON widget on the display

    PCWSTR objClassName = _TEXT(  "BUTTON");
    DWORD objStyle = WS_VISIBLE | WS_CHILD |   BS_PUSHBUTTON | BS_OWNERDRAW ; // | BS_OWNERDRAW;

    (void)sob_CreateWindowExNew(promote.thisSob, 0, objClassName, txt, objStyle);

    #if PUSHBUTTON_HAS_SUBCLASS
        // ---------------------------------
        // if you need to subclass the widget (i.e. intercept its internal message handling)
        // then insert the interception function here.

        wpOrigPUSHBUTTONProc = (WNDPROC)SetWindowLongPtr(promote.thisObject->hWnd, GWLP_WNDPROC, (LONG_PTR)PUSHBUTTON_SUBCLASS_proc);
    #endif

    #if PUSHBUTTON_HAS_OWNERDRAWN
        // ---------------------------------
        // if this widget is ownderdraw then link in the handler here

        promote.thisSob->ownerDrawnHandler = PUSHBUTTON_OD_HANDLER;
    #endif

    #if PUSHBUTTON_HAS_EVENTHANDLER
        // ---------------------------------
        // All OBJECTS are created with a prime/main  EVENTHANDLER
        // For this particular OBJECT the prime/main  EVENTHANDLER
        // is a left mouse click

        // Normally the  "user"  sets a, probably different, EVENTHANDLER for
        // each instantiated widget.

        // If you want you can set a default EVENTHANDLER which the
        // "user" can overwrite for a specific OBJECT
        promote.thisSob->eventHandler = (EVENTHANDLER)PUSHBUTTON_object_clicked;
    #endif
    PUSHBUTTONLastCreated = promote.thisObject;
    return   promote.thisObject;
}

// ----------------------------------------------------------------
// the external view
// ----------------------------------------------------------------

// BE WARNED: must be in the same sequence as the struct defn in the  header file
// if you create custom functions / methods for this widget then they
// MUST be in the struct defn and initialised into this struct instance.

PUSHBUTTONMETHODTABLE  PUSHBUTTON =
{
    PUSHBUTTON_Create
    , PUSHBUTTON_Delete

    #if PUSHBUTTON_HAS_RGB
        , PUSHBUTTON_SetRGB
    #endif

    #if PUSHBUTTON_HAS_EMPTY
        , PUSHBUTTON_Empty
    #endif

    #if PUSHBUTTON_HAS_STATE
        , PUSHBUTTON_GetState
        , PUSHBUTTON_SetState
        , PUSHBUTTON_ToggleState

    #endif

    #if PUSHBUTTON_HAS_EVENTHANDLER
        , PUSHBUTTON_SetEventHandler
    #endif

    #if  PUSHBUTTON_HAS_GREY
        , PUSHBUTTON_GetGrey
        , PUSHBUTTON_SetGrey
    #endif

    #if  PUSHBUTTON_HAS_SELECTION
        , PUSHBUTTON_GetSelectionIndex
        , PUSHBUTTON_SetSelectionIndex

        , PUSHBUTTON_AddItem

        , PUSHBUTTON_GetItemCount

        , PUSHBUTTON_GetItemText
        , PUSHBUTTON_SetItemText

        , PUSHBUTTON_GetItemData
        , PUSHBUTTON_SetItemData

        , PUSHBUTTON_DeleteIndex

    #endif

    #if PUSHBUTTON_HAS_TITLE
        , PUSHBUTTON_GetTitle
        , PUSHBUTTON_SetTitle
    #endif

    #if PUSHBUTTON_HAS_STRETCH
        , PUSHBUTTON_SetStretch
    #endif

    #if PUSHBUTTON_HAS_LAST
        , PUSHBUTTON_LastWidget
    #endif

    , PUSHBUTTON_GetUserData
    , PUSHBUTTON_SetUserData

};

#endif
