#pragma once
#if 1

#define LABEL_IS_2D 0
#define LABEL_HAS_RGB 1
#define LABEL_HAS_EMPTY 0
#define LABEL_HAS_STATE 0
#define LABEL_HAS_EVENTHANDLER 1
#define LABEL_HAS_OWNERDRAWN 1
#define LABEL_HAS_GREY 0
#define LABEL_HAS_SELECTION 0
#define LABEL_HAS_TEXT 0 
#define LABEL_HAS_SUBCLASS 0
#define LABEL_HAS_TITLE 1
#define LABEL_HAS_STRETCH 1
#define LABEL_HAS_LAST 1


#define LABELCREATEPARAMETERS TCHAR* txt 

// ----------------------------------------------------------------
// forward definition using a typedef
// the actual structure 

// typedef struct LABELOBJECT  LABELOBJECT;
// ----------------------------------------------------------------
// do NOT alter the following
// It is overlaid on a SOBDATA structure so they MUST be the same
 

typedef struct LABELOBJECT
{
    GENERICSOB
} LABELOBJECT;
 
// ----------------------------------------------------------------
// forward definition using a typedef for
// a widget object  (in this case LABEL) specific functional prototypes

typedef myUInt LABELFNC_SHAKE(LABELOBJECT*);
typedef LABELOBJECT*  LABELFNC_LASTOBJECT();

typedef TCHAR* LABELFNC_GETTEXT(LABELOBJECT*);
typedef myUInt LABELFNC_SETTEXT(LABELOBJECT*, TCHAR*);

typedef myUInt LABELFNC_NEWITEMTEXT(LABELOBJECT* thisObject, TCHAR* pText);
typedef TCHAR* LABELFNC_GETITEMTEXT(LABELOBJECT*, myUInt );
typedef myUInt LABELFNC_SETITEMTEXT(LABELOBJECT*, myUInt , TCHAR*);

typedef myUInt LABELFNC_GETVALUE(LABELOBJECT*);
typedef myUInt LABELFNC_SETVALUE(LABELOBJECT*, myUInt);

typedef myUInt LABELFNC_GETITEMDATA(LABELOBJECT*, myUInt);
typedef myUInt LABELFNC_SETITEMDATA(LABELOBJECT*, myUInt, myUInt);

typedef myUInt LABELFNC_SETEVENTHANDLER(LABELOBJECT*, EVENTHANDLER);

typedef LABELOBJECT * LABELFNC_GETOBJECT(LABELCREATEPARAMETERS);   // some CREATORs only need the new objects "title"
//typedef LABELOBJECT* LABELFNC_GETOBJECT(TCHAR* , int nbr); // some need a integer usually to help define the objects height
 
// ----------------------------------------------------------------

typedef struct LABELMETHODTABLE_ 
{
    LABELFNC_GETOBJECT* Create;
    LABELFNC_SHAKE* Delete;


#if LABEL_HAS_RGB
    LABELFNC_SETVALUE* SetRGB;
#endif


#if LABEL_HAS_EMPTY
    LABELFNC_SHAKE* Empty;
#endif


#if LABEL_HAS_STATE
    LABELFNC_GETVALUE* GetState;
    LABELFNC_SETVALUE* SetState;
    LABELFNC_SHAKE* ToggleState;
#endif


#if LABEL_HAS_EVENTHANDLER
        LABELFNC_SETEVENTHANDLER* SetEventHandler;
#endif


#if  LABEL_HAS_GREY
        LABELFNC_GETVALUE* GetGrey;
        LABELFNC_SETVALUE* SetGrey;
#endif


#if  LABEL_HAS_SELECTION
        LABELFNC_GETVALUE* GetSelectionIndex;
        LABELFNC_SETVALUE* SetSelectionIndex;
        LABELFNC_NEWITEMTEXT* AddItem;
        LABELFNC_GETVALUE* GetItemCount;
        LABELFNC_GETITEMTEXT* GetItemText;
        LABELFNC_SETITEMTEXT* SetItemCText;
        LABELFNC_GETITEMDATA* GetItemData;
        LABELFNC_SETITEMDATA* SetItemData;

        LABELFNC_SETVALUE* DeleteIndex;
#endif

#if LABEL_HAS_TITLE
        LABELFNC_GETTEXT* GetTitle;
        LABELFNC_SETTEXT* SetTitle;
#endif

#if LABEL_HAS_STRETCH
        LABELFNC_SETVALUE* SetStretch;
#endif

#if LABEL_HAS_LAST
        LABELFNC_LASTOBJECT * LastWidget;
#endif
        
        LABELFNC_GETVALUE* GetUserData;
        LABELFNC_SETVALUE* SetUserData;

} LABELMETHODTABLE;

// ----------------------------------------------------------------
// functional prototype for the  "external" methods of this OBJECT


// ---------------------------------
// this lets us write code of the form
//     LABELOBJECT myWidget = LABEL.Create( "hello" ) ;   // create a new widget 
//     TCHAR * pwidType = LABEL.GetType (myWid) ;          // get the "type"   of the widget
//     

extern LABELMETHODTABLE  LABEL;

#endif
