#if 1

    #include "project.h"

    // ----------------------------------------------------------------
    // every function in this source file can be marked as   static
    // except for the "constructor" function
    // ----------------------------------------------------------------

    static MAINTYPE LABELId = SOB_TYPE_NO;

// to allow a widget to change the default handling of a SOB
//  1) create a COPY of the default SOB METHODS TABLE in the widget's code scope
//  2) overwrite the functional pointer, in that COPY, to the address of an
//     appropriate custom function.
//     We do that when the first instance of this widget class is instantiated.
//  3) and then the pointer, in the SOB data, to the default  SOB METHODS TABLE
//     with a pointer to our COPY
//     We do that, after step 2, when the first instance of this widget class is instantiated.

//  here we make SPACE for the COPY of the SOB METHODS TABLE

SOBMETHODSTABLE  LABELSOBMETHODSTABLE;

WNDPROC    wpOrigLABELProc ;

LABELOBJECT* LABELLastCreated;

// ---------------------------------

#if LABEL_HAS_SUBCLASS

    // ----------------------------------------------------------------
    //  example of a custom  interception function     for a  subclassed   widget
    // ----------------------------------------------------------------

    static LRESULT CALLBACK LABEL_SUBCLASS_proc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    // (demo) function causes the widget to change colour when the mouse hovers over the widget.
    // does not work for all widget types

    TRACKMOUSEEVENT tme = { sizeof(tme) };
    static myInt trackingFlag = 0;
    static COLORREF bgRGBenter = 0;

    union
    {
        SOBDATA* thisSob;
        LABELOBJECT* thisObject;
    } promote = {};

    // be WARNED
    // try to find an OBJECT by the value of a (generic) property, in this case
    // it's  HWND , we default to finding it by it scanning the SOBDATA.
    // If we assume, as in this function, that it was triggered by widget type XYZ
    // then we would need a widget specific search function.
    // So scan the SOBDATA and then "cast" using the union to the appropriate widgettype.

    promote.thisSob = sob_find_hwnd(hwnd);
    if (promote.thisSob)
    {
        switch (msg)
        {
            case WM_NCHITTEST:

                if (!trackingFlag)
                {
                    tme.dwFlags = TME_LEAVE; // TME_HOVER;
                    tme.hwndTrack = hwnd;
                    tme.dwHoverTime = 1000;
                    TrackMouseEvent(&tme);

                    trackingFlag = 1;
                    bgRGBenter = promote.thisObject->bgRGB;

                    LABEL.SetRGB(promote.thisObject, RGB(0xc6, 0xe7, 0xff));
                }
                break;

            case WM_MOUSEHOVER:

                break;

            case WM_MOUSELEAVE:
                if (trackingFlag)
                {
                    trackingFlag = 0;
                    LABEL.SetRGB(promote.thisObject, bgRGBenter);
                }
                break;

            default:
                break;
        }
    }
    return CallWindowProc(wpOrigLABELProc, hwnd, msg, wParam, lParam);
}

#endif

// ---------------------------------

#if LABEL_HAS_OWNERDRAWN
    // ----------------------------------------------------------------
    //  example of a custom  ownerdrawn handler
    // ----------------------------------------------------------------

    OWNDERDRAWNHANDLER LABEL_OD_HANDLER;

static void  LABEL_OD_HANDLER(SOBDATA* sData, LPDRAWITEMSTRUCT lpDrawItemStruct)
{
    // when the WINDOW message handler is sent a  WM_DRAWITEM message, it will scan
    // the SOB DATA to find the SOB with the HWND referenced by the WM_DRAWITEM message's
    // (LPDRAWITEMSTRUCT)lParam structure.
    // If the  HWND  is found then that SOB's ownerDrawnHandler field is checked for an
    // entry (i.e.  NEQU NULL). If NEQU NULL then the value is treated as a functional pointer
    // a LABEL_OD_HANDLER function!

    // the code, bDrawButtonRGB,  is common to BUTTONs and STATIC widgets and is fairly involved.
    // So it has been made a common function located in the  ownderdraw_support files.

    bDrawButtonRGB(sData, lpDrawItemStruct);
}

#endif

// ---------------------------------

#if LABEL_HAS_RGB

    LABELFNC_SETVALUE LABEL_SetRGB;
static  myUInt LABEL_SetRGB(LABELOBJECT* thisObject, myUInt rgbValue)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU LABELId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("LABEL.SetRGB given a non LABEL object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    return sob_SetRGB(thisObject->psSobData, (COLORREF)rgbValue);
}
#endif

// ---------------------------------

#if LABEL_HAS_STATE
    // some widget types have a  STATE
    // e.g. menu item ticked, radio button, check button

    LABELFNC_GETVALUE LABEL_GetState;
static  myUInt LABEL_GetState(LABELOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    if (thisObject->type NEQU LABELId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("LABEL.GetState given a non LABEL object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return
    (  (myInt)SendMessage(thisObject->hWnd, BM_GETCHECK, 0, 0)
    EQU BST_CHECKED
    );
}

// ---------------------------------

LABELFNC_SETVALUE  LABEL_SetState;
static  myUInt LABEL_SetState(LABELOBJECT* thisObject, myUInt check)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    if (thisObject->type NEQU LABELId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("LABEL.SetState given a non LABEL object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    SOBDATA* pData = thisObject->ppSobData;

    SOBDATA* cData = sob_get_first_child(pData);
    while (cData)
    {
        if (cData->type EQU  LABELId)
        {
            SendMessage
            (cData->hWnd
            , BM_SETCHECK
            , (WPARAM)BST_UNCHECKED
            , 0
            );
        }
        cData = sob_get_next_child(cData);
    }

    if (check) check = BST_CHECKED;
    else  check = BST_UNCHECKED;

    SendMessage
    (thisObject->hWnd
    , BM_SETCHECK
    , (WPARAM)check
    , 0
    );
    return (check EQU BST_CHECKED);
}

// ---------------------------------

LABELFNC_SHAKE LABEL_ToggleState;
static  myUInt LABEL_ToggleState(LABELOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU LABELId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("LABEL.ToggleState given a non LABEL object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return  LABEL.SetState(thisObject, (LABEL.GetState(thisObject)  EQU 0));
}

#endif

// ---------------------------------

#if  LABEL_HAS_EVENTHANDLER

    // example of a EVENTHANDLER: in this case when the widget is clicked on with the mouse
    // Careful this  function is only valid for widgets that receive
    //   WM_COMMAND messages   carrying a  BN_CLICKED notification

    static void LABEL_object_clicked(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam, SOBDATA * sData)
{
    LABELOBJECT* thisObject = (LABELOBJECT*)lParam;
    WORD NotificationCode = HIWORD(wParam);
    WORD identifier = LOWORD(wParam);

    switch (NotificationCode)
    {
        case BN_CLICKED :
            swprintf_s
            (txtBuffer, szTxtBuffer, L" LABEL clicked 0x%04x  0x%04x  0x%04x\n"
            , thisObject->sIndex
            , NotificationCode
            , identifier);    addText(txtBuffer);

            SOB.Report((SOBDATA*)thisObject);

            //          LABEL.ToggleState(thisObject);

            break;

        default:
            #if DebuggingAid
                swprintf_s
                (txtBuffer, szTxtBuffer, L" LABEL unhandled notification 0x%04x  0x%04x  0x%04x\n"
                , thisObject->sIndex
                , NotificationCode
                , identifier);    addText(txtBuffer);
            #endif

            break;
    }
}

LABELFNC_SETEVENTHANDLER LABEL_SetEventHandler;
static myUInt LABEL_SetEventHandler(LABELOBJECT* thisObject, EVENTHANDLER value)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU LABELId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("LABEL.SetEventHandler given a non LABEL object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    return SOB.SetEventHandler(SOBOBJ thisObject, value);
}

#endif

// ---------------------------------

#if  LABEL_HAS_EMPTY
    // some widget types can be emptied e.g. combo boxes, RichTextEdit ..

    LABELFNC_SHAKE LABEL_Empty;
static  myUInt LABEL_Empty(LABELOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    if (thisObject->type NEQU LABELId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("LABEL.Empty given a non LABEL object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    SendMessage(thisObject->hWnd, CB_RESETCONTENT, 0, 0);

    return  SOB.Empty(SOBOBJ thisObject);
}

#endif

// ---------------------------------

#if  LABEL_HAS_GREY
    // some widget types can be greyed e.g. menu items, some button types (rare but possible)

    LABELFNC_SETVALUE LABEL_GetGrey;
static  myUInt LABEL_GetGrey(LABELOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU LABELId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("LABEL.GetGrey given a non LABEL object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    return  SOB_OK;
}

LABELFNC_SETVALUE LABEL_SetGrey;
static  myUInt LABEL_SetGrey(LABELOBJECT* thisObject, myUInt value)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    if (thisObject->type NEQU LABELId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("LABEL.SetGrey given a non LABEL object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return  SOB_OK;
}

#endif

// ---------------------------------

#if  LABEL_HAS_SELECTION
    // some widget types have selectable items
    // e.g. COMBO boxes, edit fields

    LABELFNC_GETVALUE LABEL_GetSelectionIndex;
static  myUInt LABEL_GetSelectionIndex(LABELOBJECT* thisObject)
{

    if (thisObject->type NEQU LABELId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("LABEL.GetSelectionIndex given a non LABEL object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if LABEL_IS_2D
        return (myInt)SendMessage(thisObject->hWnd, CB_GETCURSEL, 0, 0);
    #endif

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

LABELFNC_SETVALUE LABEL_SetSelectionIndex;
static  myUInt LABEL_SetSelectionIndex(LABELOBJECT* thisObject, myUInt value)
{
    if (thisObject->type NEQU LABELId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("LABEL.SetSelectionIndex given a non LABEL object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if LABEL_IS_2D
        // Sets the ZERO based index to be  the currently selected item of the combo
        return (int)SendMessage(thisObject->hWnd, CB_SETCURSEL, value, 0);
    #endif

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

LABELFNC_GETVALUE LABEL_GetItemCount;
static  myUInt LABEL_GetItemCount(LABELOBJECT* thisObject)
{

    if (thisObject->type NEQU LABELId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("LABEL.GetItemCount given a non LABEL object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if LABEL_IS_2D

        return (myUInt)SendMessage(thisObject->hWnd, CB_GETCOUNT, 0, 0);
    #endif
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

LABELFNC_NEWITEMTEXT LABEL_AddItem;
static myUInt LABEL_AddItem(LABELOBJECT* thisObject, TCHAR* pText)
{
    if (thisObject->type NEQU LABELId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("LABEL.AddItem given a non LABEL object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if LABEL_IS_2D
        int index;

        index = (int)SendMessage(thisObject->hWnd, CB_ADDSTRING, 0, (LPARAM)pText);
        SendMessage(thisObject->hWnd, CB_SETITEMDATA, (WPARAM)index, (LPARAM)index);
        return (myUInt)index;
    #endif

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

LABELFNC_GETITEMTEXT LABEL_GetItemText;
static TCHAR* LABEL_GetItemText(LABELOBJECT* thisObject, myUInt index)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULL;

    if (thisObject->type NEQU LABELId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("LABEL.GetItemText given a non LABEL object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return NULL;
    }

    #define  TitleMax 255
    static TCHAR title[TitleMax + 1] = { 0 };

    myUInt len = (myUInt) SendMessage(thisObject->hWnd, CB_GETLBTEXTLEN, index, 0); // get character count

    if (len < TitleMax)   SendMessage(thisObject->hWnd, CB_GETLBTEXT, index, (LPARAM)title) ;

    return & title[0];
}

LABELFNC_SETITEMTEXT LABEL_SetItemText;
static myUInt LABEL_SetItemText(LABELOBJECT* thisObject, myUInt index, TCHAR* title)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU LABELId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("LABEL.SetItemText given a non LABEL object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return (myUInt)  SendMessage(thisObject->hWnd, CB_INSERTSTRING, index, (LPARAM)title);

}

LABELFNC_SETVALUE LABEL_DeleteIndex;
static  myUInt LABEL_DeleteIndex(LABELOBJECT* thisObject, myUInt value)
{
    if (thisObject->type NEQU LABELId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("LABEL.DeleteIndex given a non LABEL object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if LABEL_IS_2D
        // Sets the ZERO based index to be  the currently selected item of the combo
        return (int)SendMessage(thisObject->hWnd, CB_DELETESTRING, value, 0);
    #endif
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

LABELFNC_GETITEMDATA LABEL_GetItemData;
static myUInt LABEL_GetItemData(LABELOBJECT* thisObject, myUInt itemId)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULL;

    if (thisObject->type NEQU LABELId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("LABEL.GetItemData given a non LABEL object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return   SendMessage(thisObject->hWnd, CB_GETITEMDATA, itemId, 0);
}

LABELFNC_SETITEMDATA LABEL_SetItemData;
static myUInt LABEL_SetItemData(LABELOBJECT* thisObject, myUInt itemId, myUInt uData)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU LABELId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("LABEL.SetItemData given a non LABEL object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    return  SendMessage(thisObject->hWnd, CB_SETITEMDATA, itemId, uData);;
}

#endif

LABELFNC_GETVALUE  LABEL_GetUserData;
static myUInt LABEL_GetUserData(LABELOBJECT* thisObject )
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULLV;

    if (thisObject->type NEQU LABELId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("LABEL.GetUserData given a non LABEL object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return NULLV;
    }

    return fnGetUserDataGeneric (SOBOBJ thisObject);
}

LABELFNC_SETVALUE LABEL_SetUserData;
static myUInt LABEL_SetUserData(LABELOBJECT* thisObject, myUInt value )
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU LABELId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("LABEL.SetUserData given a non LABEL object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return NULLV;
    }
    return  fnSetUserDataGeneric(SOBOBJ thisObject, value);

}

// ---------------------------------
#if LABEL_HAS_TITLE

    LABELFNC_GETTEXT  LABEL_GetTitle;
static TCHAR* LABEL_GetTitle(LABELOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULL;
    return   SOB.GetTitle(SOBOBJ thisObject);
}

// ---------------------------------

LABELFNC_SETTEXT  LABEL_SetTitle;
static myUInt LABEL_SetTitle(LABELOBJECT* thisObject, TCHAR* txt)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return SOB.SetTitle(SOBOBJ thisObject, txt);
}
#endif

// ---------------------------------

SOBFNC_GETTEXT LABEL_SOB_GetType;
static TCHAR* LABEL_SOB_GetType(SOBDATA* thisSob)
{
    static TCHAR objText[] = TEXT("LABEL");
    return  objText;
}

LABELFNC_GETTEXT LABEL_GetType;
static  TCHAR* LABEL_GetType(LABELOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULL;
    return   LABEL_SOB_GetType(SOBOBJ thisObject);
}

// ---------------------------------

LABELFNC_SETVALUE LABEL_SetShow;
static  myUInt LABEL_SetShow(LABELOBJECT* thisObject, myUInt value)
{
    // this will need customising if the widget is complex
    // i.e. is really a member of a set of  widgets that can not all appear at the same time
    // e.g. a radio button     or an  overlay set

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return SOB.SetShow(SOBOBJ thisObject, value);
}

// ---------------------------------

// ---------------------------------

#if LABEL_HAS_STRETCH

    LABELFNC_SETVALUE LABEL_SetStretch;
static  myUInt LABEL_SetStretch(LABELOBJECT* thisObject, myUInt value)
{

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    SOB.SetStretch(SOBOBJ thisObject, value);

    return SOB.SetShow(SOBOBJ thisObject, value);
}

#endif

// ---------------------------------
#if LABEL_HAS_LAST

    LABELFNC_LASTOBJECT LABEL_LastWidget;
static  LABELOBJECT*  LABEL_LastWidget( )
{
    return LABELLastCreated;
}
#endif

// ----------------------------------------------------------------
// the "destructor" function
// ----------------------------------------------------------------
SOBFNC_SHAKE LABEL_SOB_Delete;
static myUInt LABEL_SOB_Delete(SOBDATA* thisSob)
{
    // we need this function so that when a CONTAINER is deleted
    // it can trigger a delete of any widget related things of it's child
    // SOB OBJECTs here:-

    if (fnInvalidSobGeneric(thisSob)) return SOB_NOK;

    SOB.Delete(thisSob); // trigger the generic Delete

    return SOB_OK;
}

LABELFNC_SHAKE LABEL_Delete;
static  myUInt LABEL_Delete(LABELOBJECT* thisObject)
{
    // this will need customising if the widget is complex
    // i.e. is really a set of widgets
    // e.g. an  overlay set

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return   LABEL_SOB_Delete(SOBOBJ thisObject  );
}

// ----------------------------------------------------------------
//  inheritance from the underlying SOB
// ----------------------------------------------------------------

// if an inherited function is to be customised/overwritten
// then do it HERE:

LABELFNC_GETTEXT  fnGetTypeTextCustom;
static TCHAR* fnGetTypeTextCustom(LABELOBJECT* sData)
{
    return (TCHAR*)_TEXT("LABEL");
}

// ----------------------------------------------------------------
// the "constructor" function
// ----------------------------------------------------------------

LABELFNC_GETOBJECT LABEL_Create;
static LABELOBJECT* LABEL_Create(LABELCREATEPARAMETERS)
{
    union
    {
        SOBDATA* thisSob;
        LABELOBJECT* thisObject;
    } promote = {0};

    // ---------------------------------
    // in some cases a given widget can only be assigned to certain types of container
    // this is probably the best case to catch such exceptions and
    // permit / block them as appropriate

    // ---------------------------------
    // use the FONT assigned to the PARENT as guidelines for text size

    SOBDATA* pData = sob_get_base(gpSobIndex);
    int nbrLines = 1;  // some CONSTRUCTOR functions want 2 input parameters,
    // typicaly the 2nd parameter is the height of the widget
    // give as the nbr of text lines

    #if LABEL_IS_2D
        nbrLines= nbrLines* lines;
    #endif

    int height = 0;
    int width = 0;

    int_sob_text_size(pData, txt, &width, &height);

    // But the HEIGHT only covers text, we need to increase it to allow multiple text
    // lines   AND for any SOB surround
    int objHeight = height * nbrLines + 8;
    int objWidth = width + 20;

    // ---------------------------------
    // A  Screen OBject ( SOB )  is really a structure
    //    the GENERIC structure
    //    and a ptr to the VTABLE
    // ---------------------------------
    // An OBJECT instance is really a structure
    //    the GENERIC structure
    //    and a  ptr to the OBJECT's private functions
    // ---------------------------------
    // So a   SOB   and an    OBJECT     have identical structures
    // WHY:
    // This way we can create a SOB as a sort of generic OBJECT.
    // Some functions, predominantly concerned with
    //    screen size management
    //    screen position management
    //   are OBJECT independent.
    //
    // Then we can have an OBJECT specific "view" were each OBJECT type
    // can have its own strongly typed structure.
    // ---------------------------------

    if (!LABELId)
    {
        // ---------------------------------
        #if DeveloperMode

            union
            {
                myUInt* pEntry;
                void * pVoid;
            } reRef = {0};

            reRef.pVoid = & LABEL;
            myUInt* pEntry = reRef.pEntry;

            int entryCount = sizeof(LABELMETHODTABLE) / sizeof(void*);
            int i;
            for (i = 0; i < entryCount; i++)
            {
                if ((!*pEntry)   LOR(*pEntry BAND 0x07))
                { 
                    swprintf_s(txtBuffer, szTxtBuffer, _TEXT("LABEL methods table, entry: %02i,  not fully/correctly populated. 0x%llx\n"), i, *pEntry);
                    ReportError(txtBuffer);
                }
                pEntry++;
            }

        #endif

        // ---------------------------------

        LABELId = int_next_maintype();

        // to allow a widget to change the default handling of a SOB
        //  1) create a COPY of the default SOB METHODS TABLE in the widget's code scope
        //  2) overwrite the functional pointer, in that COPY, to the address of an
        //     appropriate custom function.
        //     We do that when the first instance of this widget class is instantiated.
        //  3) and then the pointer, in the SOB data, to the default  SOB METHODS TABLE
        //     with a pointer to our COPY
        //     We do that, after step 2, when the first instance of this widget class is instantiated.

        // ---------------------------------
        //    SPACE for the COPY of the SOB METHODS TABLE  was made at the TOP of this source file
        //    SOBMETHODSTABLE  LABELSOBMETHODSTABLE;
        // ---------------------------------
        // populate the COPY with the default SOB METHID TABLE

        fnInheritSOBmethods( &  LABELSOBMETHODSTABLE);

        // ---------------------------------
        // now populate those entries, in the COPY of the  SOB METHODS TABLE , that are
        // to be widget specific

        LABELSOBMETHODSTABLE.GetType = & LABEL_SOB_GetType;

        LABELSOBMETHODSTABLE.Delete = & LABEL_SOB_Delete;
    }

    // ---------------------------------

    promote.thisSob = sob_new_new(LABELId, SOB_CONTAINER_NO, objWidth, objHeight);
    if (promote.thisSob EQU NULL)
    {
        int_return_maintype();  //  give the custom LABELId back
        return NULL;
    }

    // ---------------------------------
    // replace the default SOB METHOD TABLE with our widget's custom table

    //  promote.thisSob->sVtbl = &LABELSOBMETHODSTABLE;

    // promote.thisSob->fncCustomDelete;    
    promote.thisSob->fncCustomGetTypeText = LABEL_SOB_GetType ;
    // promote.thisSob->fncCustomGetSubTypeText = LABEL_SOB_GetType;
    // promote.thisSob->fncCustomShow;

    promote.thisSob->txtRGB = -1; // use system default
    promote.thisSob->bgRGB  = -1; // use system default

    // ---------------------------------
    // create an instance of the  LABEL widget on the display

    PCWSTR objClassName = _TEXT(  "STATIC");
    DWORD objStyle = WS_VISIBLE | WS_CHILD |   SS_CENTER | SS_NOTIFY | SS_CENTERIMAGE | SS_OWNERDRAW ; // | BS_OWNERDRAW;

    (void)sob_CreateWindowExNew(promote.thisSob, 0, objClassName, txt, objStyle);

    #if LABEL_HAS_SUBCLASS
        // ---------------------------------
        // if you need to subclass the widget (i.e. intercept its internal message handling)
        // then insert the interception function here.

        wpOrigLABELProc = (WNDPROC)SetWindowLongPtr(promote.thisObject->hWnd, GWLP_WNDPROC, (LONG_PTR)LABEL_SUBCLASS_proc);
    #endif

    #if LABEL_HAS_OWNERDRAWN
        // ---------------------------------
        // if this widget is ownderdraw then link in the handler here

        promote.thisSob->ownerDrawnHandler = LABEL_OD_HANDLER;
    #endif

    #if LABEL_HAS_EVENTHANDLER
        // ---------------------------------
        // All OBJECTS are created with a prime/main  EVENTHANDLER
        // For this particular OBJECT the prime/main  EVENTHANDLER
        // is a left mouse click

        // Normally the  "user"  sets a, probably different, EVENTHANDLER for
        // each instantiated widget.

        // If you want you can set a default EVENTHANDLER which the
        // "user" can overwrite for a specific OBJECT
        promote.thisSob->eventHandler = (EVENTHANDLER)LABEL_object_clicked;
    #endif
    LABELLastCreated = promote.thisObject;
    return   promote.thisObject;
}

// ----------------------------------------------------------------
// the external view
// ----------------------------------------------------------------

// BE WARNED: must be in the same sequence as the struct defn in the  header file
// if you create custom functions / methods for this widget then they
// MUST be in the struct defn and initialised into this struct instance.

LABELMETHODTABLE  LABEL =
{
    LABEL_Create
    , LABEL_Delete

    #if LABEL_HAS_RGB
        , LABEL_SetRGB
    #endif

    #if LABEL_HAS_EMPTY
        , LABEL_Empty
    #endif

    #if LABEL_HAS_STATE
        , LABEL_GetState
        , LABEL_SetState
        , LABEL_ToggleState

    #endif

    #if LABEL_HAS_EVENTHANDLER
        , LABEL_SetEventHandler
    #endif

    #if  LABEL_HAS_GREY
        , LABEL_GetGrey
        , LABEL_SetGrey
    #endif

    #if  LABEL_HAS_SELECTION
        , LABEL_GetSelectionIndex
        , LABEL_SetSelectionIndex

        , LABEL_AddItem

        , LABEL_GetItemCount

        , LABEL_GetItemText
        , LABEL_SetItemText

        , LABEL_GetItemData
        , LABEL_SetItemData

        , LABEL_DeleteIndex

    #endif

    #if LABEL_HAS_TITLE
        , LABEL_GetTitle
        , LABEL_SetTitle
    #endif

    #if LABEL_HAS_STRETCH
        , LABEL_SetStretch
    #endif

    #if LABEL_HAS_LAST
        , LABEL_LastWidget
    #endif

    , LABEL_GetUserData
    , LABEL_SetUserData

};

#endif
