#pragma once
#if 1

#define IMAGE_IS_2D 1
#define IMAGE_HAS_RGB 0
#define IMAGE_HAS_EMPTY 1
#define IMAGE_HAS_STATE 0
#define IMAGE_HAS_EVENTHANDLER 1
#define IMAGE_HAS_OWNERDRAWN 1
#define IMAGE_HAS_GREY 0
#define IMAGE_HAS_SELECTION 0
#define IMAGE_HAS_TEXT 0 
#define IMAGE_HAS_SUBCLASS 0
#define IMAGE_HAS_TITLE 0
#define IMAGE_HAS_STRETCH 1
#define IMAGE_HAS_LAST 1

#define IMAGECREATEPARAMETERS TCHAR* txt, int lines  

// ----------------------------------------------------------------
// forward definition using a typedef
// the actual structure 

// typedef struct IMAGEOBJECT  IMAGEOBJECT;
// ----------------------------------------------------------------
// do NOT alter the following
// It is overlaid on a SOBDATA structure so they MUST be the same

typedef struct IMAGEOBJECT
{
    GENERICSOB
} IMAGEOBJECT;

// ----------------------------------------------------------------
// forward definition using a typedef for
// a widget object  (in this case IMAGE) specific functional prototypes

typedef myUInt IMAGEFNC_SHAKE(IMAGEOBJECT*);

typedef TCHAR* IMAGEFNC_GETTEXT(IMAGEOBJECT*);
typedef myUInt IMAGEFNC_SETTEXT(IMAGEOBJECT*, TCHAR*);


typedef IMAGEOBJECT* IMAGEFNC_LASTOBJECT();

typedef myUInt IMAGEFNC_NEWITEMTEXT(IMAGEOBJECT* thisObject, TCHAR* pText);
typedef TCHAR* IMAGEFNC_GETITEMTEXT(IMAGEOBJECT*, myUInt );
typedef myUInt IMAGEFNC_SETITEMTEXT(IMAGEOBJECT*, myUInt , TCHAR*);

typedef myUInt IMAGEFNC_GETVALUE(IMAGEOBJECT*);
typedef myUInt IMAGEFNC_SETVALUE(IMAGEOBJECT*, myUInt);
typedef myUInt IMAGEFNC_SETEVENTHANDLER(IMAGEOBJECT*, EVENTHANDLER);

typedef IMAGEOBJECT * IMAGEFNC_GETOBJECT(IMAGECREATEPARAMETERS);   // some CREATORs only need the new objects "title"
//typedef IMAGEOBJECT* IMAGEFNC_GETOBJECT(TCHAR* , int nbr); // some need a integer usually to help define the objects height
 
// ----------------------------------------------------------------

typedef struct IMAGEMETHODTABLE_ 
{
    IMAGEFNC_GETOBJECT* Create;
    IMAGEFNC_SHAKE* Delete;


#if IMAGE_HAS_RGB
    IMAGEFNC_SETVALUE* SetRGB;
#endif


#if IMAGE_HAS_EMPTY
    IMAGEFNC_SHAKE* Empty;
#endif


#if IMAGE_HAS_STATE
    IMAGEFNC_GETVALUE* GetState;
    IMAGEFNC_SETVALUE* SetState;
    IMAGEFNC_SHAKE* ToggleState;
#endif


#if IMAGE_HAS_EVENTHANDLER
        IMAGEFNC_SETEVENTHANDLER* SetEventHandler;
#endif


#if  IMAGE_HAS_GREY
        IMAGEFNC_GETVALUE* GetGrey;
        IMAGEFNC_SETVALUE* SetGrey;
#endif


#if  IMAGE_HAS_SELECTION
        IMAGEFNC_GETVALUE* GetSelectionIndex;
        IMAGEFNC_SETVALUE* SetSelectionIndex;
        IMAGEFNC_NEWITEMTEXT* AddItem;
        IMAGEFNC_GETVALUE* GetItemCount;
        IMAGEFNC_GETITEMTEXT* GetItemText;
        IMAGEFNC_SETITEMTEXT* SetItemCText;
        IMAGEFNC_SETVALUE* DeleteIndex;
#endif

#if IMAGE_HAS_TITLE
        IMAGEFNC_GETTEXT* GetTitle;
        IMAGEFNC_SETTEXT* SetTitle;
#endif

#if IMAGE_HAS_STRETCH
        IMAGEFNC_SETVALUE* SetStretch;
#endif


#if IMAGE_HAS_LAST
        IMAGEFNC_LASTOBJECT* LastWidget;
#endif


        IMAGEFNC_SETTEXT* Open;

} IMAGEMETHODTABLE;

// ----------------------------------------------------------------
// functional prototype for the  "external" methods of this OBJECT


// ---------------------------------
// this lets us write code of the form
//     IMAGEOBJECT myWidget = IMAGE.Create( "hello" ) ;   // create a new widget 
//     TCHAR * pwidType = IMAGE.GetType (myWid) ;          // get the "type"   of the widget
//     

extern IMAGEMETHODTABLE  IMAGE;

#endif
