#pragma once
#if 1

#define EDIT_IS_2D 0
#define EDIT_HAS_RGB 0
#define EDIT_HAS_EMPTY 1
#define EDIT_HAS_STATE 0
#define EDIT_HAS_EVENTHANDLER 1
#define EDIT_HAS_OWNERDRAWN 0
#define EDIT_HAS_GREY 0
#define EDIT_HAS_SELECTION 0
#define EDIT_HAS_TEXT 1 
#define EDIT_HAS_SUBCLASS 0
#define EDIT_HAS_TITLE 1
#define EDIT_HAS_STRETCH 1
#define EDIT_HAS_LAST 1


#define EDITCREATEPARAMETERS TCHAR* txt 

// ----------------------------------------------------------------
// forward definition using a typedef
// the actual structure 

// typedef struct EDITOBJECT  EDITOBJECT;
// ----------------------------------------------------------------
// do NOT alter the following
// It is overlaid on a SOBDATA structure so they MUST be the same

typedef struct EDITOBJECT
{
    GENERICSOB
} EDITOBJECT;

// ----------------------------------------------------------------
// forward definition using a typedef for
// a widget object  (in this case EDIT) specific functional prototypes

typedef myUInt EDITFNC_SHAKE(EDITOBJECT*);
typedef EDITOBJECT*  EDITFNC_LASTOBJECT();

typedef TCHAR* EDITFNC_GETTEXT(EDITOBJECT*);
typedef myUInt EDITFNC_SETTEXT(EDITOBJECT*, TCHAR*);


typedef myUInt EDITFNC_GETTEXTBUFFER(EDITOBJECT*, TCHAR*, myUInt length);

typedef myUInt EDITFNC_NEWITEMTEXT(EDITOBJECT* thisObject, TCHAR* pText);
typedef TCHAR* EDITFNC_GETITEMTEXT(EDITOBJECT*, myUInt );
typedef myUInt EDITFNC_SETITEMTEXT(EDITOBJECT*, myUInt , TCHAR*);

typedef myUInt EDITFNC_GETVALUE(EDITOBJECT*);
typedef myUInt EDITFNC_SETVALUE(EDITOBJECT*, myUInt);

typedef myUInt EDITFNC_GETITEMDATA(EDITOBJECT*, myUInt);
typedef myUInt EDITFNC_SETITEMDATA(EDITOBJECT*, myUInt, myUInt);

typedef myUInt EDITFNC_SETEVENTHANDLER(EDITOBJECT*, EVENTHANDLER);

typedef EDITOBJECT * EDITFNC_GETOBJECT(EDITCREATEPARAMETERS);   // some CREATORs only need the new objects "title"
//typedef EDITOBJECT* EDITFNC_GETOBJECT(TCHAR* , int nbr); // some need a integer usually to help define the objects height
 
// ----------------------------------------------------------------

typedef struct EDITMETHODTABLE_ 
{
    EDITFNC_GETOBJECT* Create;
    EDITFNC_SHAKE* Delete;


#if EDIT_HAS_RGB
    EDITFNC_SETVALUE* SetRGB;
#endif


#if EDIT_HAS_EMPTY
    EDITFNC_SHAKE* Empty;
#endif


#if EDIT_HAS_STATE
    EDITFNC_GETVALUE* GetState;
    EDITFNC_SETVALUE* SetState;
    EDITFNC_SHAKE* ToggleState;
#endif


#if EDIT_HAS_EVENTHANDLER
        EDITFNC_SETEVENTHANDLER* SetEventHandler;
#endif


#if  EDIT_HAS_GREY
        EDITFNC_GETVALUE* GetGrey;
        EDITFNC_SETVALUE* SetGrey;
#endif


#if  EDIT_HAS_SELECTION
        EDITFNC_GETVALUE* GetSelectionIndex;
        EDITFNC_SETVALUE* SetSelectionIndex;
        EDITFNC_NEWITEMTEXT* AddItem;
        EDITFNC_GETVALUE* GetItemCount;
        EDITFNC_GETITEMTEXT* GetItemText;
        EDITFNC_SETITEMTEXT* SetItemCText;
        EDITFNC_GETITEMDATA* GetItemData;
        EDITFNC_SETITEMDATA* SetItemData;

        EDITFNC_SETVALUE* DeleteIndex;
#endif

#if EDIT_HAS_TITLE
        EDITFNC_GETTEXTBUFFER* GetTitle;
        EDITFNC_GETVALUE*EDIT_GetTitleLength;
        EDITFNC_SETTEXT* SetTitle;
#endif

#if EDIT_HAS_STRETCH
        EDITFNC_SETVALUE* SetStretch;
#endif

#if EDIT_HAS_LAST
        EDITFNC_LASTOBJECT * LastWidget;
#endif
        
        EDITFNC_GETVALUE* GetUserData;
        EDITFNC_SETVALUE* SetUserData;

} EDITMETHODTABLE;

// ----------------------------------------------------------------
// functional prototype for the  "external" methods of this OBJECT


// ---------------------------------
// this lets us write code of the form
//     EDITOBJECT myWidget = EDIT.Create( "hello" ) ;   // create a new widget 
//     TCHAR * pwidType = EDIT.GetType (myWid) ;          // get the "type"   of the widget
//     

extern EDITMETHODTABLE  EDIT;

#endif
