#pragma once
#if 1

#define COMBO_IS_2D 1
#define COMBO_HAS_RGB 0
#define COMBO_HAS_EMPTY 1
#define COMBO_HAS_STATE 0
#define COMBO_HAS_EVENTHANDLER 1
#define COMBO_HAS_OWNERDRAWN 0
#define COMBO_HAS_GREY 0
#define COMBO_HAS_SELECTION 1
#define COMBO_HAS_TEXT 1 
#define COMBO_HAS_SUBCLASS 0
#define COMBO_HAS_TITLE 0
#define COMBO_HAS_STRETCH 1
#define COMBO_HAS_LAST 1


#define COMBOCREATEPARAMETERS TCHAR* txt, int lines  

// ----------------------------------------------------------------
// forward definition using a typedef
// the actual structure 

// typedef struct COMBOOBJECT  COMBOOBJECT;
// ----------------------------------------------------------------
// do NOT alter the following
// It is overlaid on a SOBDATA structure so they MUST be the same

typedef struct COMBOOBJECT
{
    GENERICSOB
} COMBOOBJECT;

// ----------------------------------------------------------------
// forward definition using a typedef for
// a widget object  (in this case COMBO) specific functional prototypes

typedef myUInt COMBOFNC_SHAKE(COMBOOBJECT*);
typedef COMBOOBJECT*  COMBOFNC_LASTOBJECT();

typedef TCHAR* COMBOFNC_GETTEXT(COMBOOBJECT*);
typedef myUInt COMBOFNC_SETTEXT(COMBOOBJECT*, TCHAR*);

typedef myUInt COMBOFNC_NEWITEMTEXT(COMBOOBJECT* thisObject, TCHAR* pText);
typedef TCHAR* COMBOFNC_GETITEMTEXT(COMBOOBJECT*, myUInt );
typedef myUInt COMBOFNC_SETITEMTEXT(COMBOOBJECT*, myUInt , TCHAR*);

typedef myUInt COMBOFNC_GETVALUE(COMBOOBJECT*);
typedef myUInt COMBOFNC_SETVALUE(COMBOOBJECT*, myUInt);

typedef myUInt COMBOFNC_GETITEMDATA(COMBOOBJECT*, myUInt);
typedef myUInt COMBOFNC_SETITEMDATA(COMBOOBJECT*, myUInt, myUInt);

typedef myUInt COMBOFNC_SETEVENTHANDLER(COMBOOBJECT*, EVENTHANDLER);

typedef COMBOOBJECT * COMBOFNC_GETOBJECT(COMBOCREATEPARAMETERS);   // some CREATORs only need the new objects "title"
//typedef COMBOOBJECT* COMBOFNC_GETOBJECT(TCHAR* , int nbr); // some need a integer usually to help define the objects height
 
// ----------------------------------------------------------------

typedef struct COMBOMETHODTABLE_ 
{
    COMBOFNC_GETOBJECT* CreateSimple;
    COMBOFNC_GETOBJECT* CreateEdit;
    COMBOFNC_GETOBJECT* CreateList;




    COMBOFNC_SHAKE* Delete;


#if COMBO_HAS_RGB
    COMBOFNC_SETVALUE* SetRGB;
#endif


#if COMBO_HAS_EMPTY
    COMBOFNC_SHAKE* Empty;
#endif


#if COMBO_HAS_STATE
    COMBOFNC_GETVALUE* GetState;
    COMBOFNC_SETVALUE* SetState;
    COMBOFNC_SHAKE* ToggleState;
#endif


#if COMBO_HAS_EVENTHANDLER
        COMBOFNC_SETEVENTHANDLER* SetEventHandler;
#endif


#if  COMBO_HAS_GREY
        COMBOFNC_GETVALUE* GetGrey;
        COMBOFNC_SETVALUE* SetGrey;
#endif


#if  COMBO_HAS_SELECTION
        COMBOFNC_GETVALUE* GetSelectionIndex;
        COMBOFNC_SETVALUE* SetSelectionIndex;
        COMBOFNC_NEWITEMTEXT* AddItem;
        COMBOFNC_GETVALUE* GetItemCount;
        COMBOFNC_GETITEMTEXT* GetItemText;
        COMBOFNC_SETITEMTEXT* SetItemCText;
        COMBOFNC_GETITEMDATA* GetItemData;
        COMBOFNC_SETITEMDATA* SetItemData;

        COMBOFNC_SETVALUE* DeleteIndex;
#endif

#if COMBO_HAS_TITLE
        COMBOFNC_GETTEXT* GetTitle;
        COMBOFNC_SETTEXT* SetTitle;
#endif

#if COMBO_HAS_STRETCH
        COMBOFNC_SETVALUE* SetStretch;
#endif

#if COMBO_HAS_LAST
        COMBOFNC_LASTOBJECT * LastWidget;
#endif
        
        COMBOFNC_GETVALUE* GetUserData;
        COMBOFNC_SETVALUE* SetUserData;

} COMBOMETHODTABLE;

// ----------------------------------------------------------------
// functional prototype for the  "external" methods of this OBJECT


// ---------------------------------
// this lets us write code of the form
//     COMBOOBJECT myWidget = COMBO.Create( "hello" ) ;   // create a new widget 
//     TCHAR * pwidType = COMBO.GetType (myWid) ;          // get the "type"   of the widget
//     

extern COMBOMETHODTABLE  COMBO;

#endif
