#if 1

    #include "project.h"

    // ----------------------------------------------------------------
    // every function in this source file can be marked as   static
    // except for the "constructor" function
    // ----------------------------------------------------------------

    MAINTYPE COMBOId = SOB_TYPE_NO;

// to allow a widget to change the default handling of a SOB
//  1) create a COPY of the default SOB METHODS TABLE in the widget's code scope
//  2) overwrite the functional pointer, in that COPY, to the address of an
//     appropriate custom function.
//     We do that when the first instance of this widget class is instantiated.
//  3) and then the pointer, in the SOB data, to the default  SOB METHODS TABLE
//     with a pointer to our COPY
//     We do that, after step 2, when the first instance of this widget class is instantiated.

//  here we make SPACE for the COPY of the SOB METHODS TABLE

SOBMETHODSTABLE  COMBOSOBMETHODSTABLE;

WNDPROC    wpOrigCOMBOProc ;

COMBOOBJECT* COMBOLastCreated;

// ---------------------------------

#if COMBO_HAS_SUBCLASS

    // ----------------------------------------------------------------
    //  example of a custom  interception function     for a  subclassed   widget
    // ----------------------------------------------------------------

    static LRESULT CALLBACK COMBO_SUBCLASS_proc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    // (demo) function causes the widget to change colour when the mouse hovers over the widget.
    // does not work for all widget types

    TRACKMOUSEEVENT tme = { sizeof(tme) };
    static myInt trackingFlag = 0;
    static COLORREF bgRGBenter = 0;

    union
    {
        SOBDATA* thisSob;
        COMBOOBJECT* thisObject;
    } promote = {};

    // be WARNED
    // try to find an OBJECT by the value of a (generic) property, in this case
    // it's  HWND , we default to finding it by it scanning the SOBDATA.
    // If we assume, as in this function, that it was triggered by widget type XYZ
    // then we would need a widget specific search function.
    // So scan the SOBDATA and then "cast" using the union to the appropriate widgettype.

    promote.thisSob = sob_find_hwnd(hwnd);
    if (promote.thisSob)
    {
        switch (msg)
        {
            case WM_NCHITTEST:

                if (!trackingFlag)
                {
                    tme.dwFlags = TME_LEAVE; // TME_HOVER;
                    tme.hwndTrack = hwnd;
                    tme.dwHoverTime = 1000;
                    TrackMouseEvent(&tme);

                    trackingFlag = 1;
                    bgRGBenter = promote.thisObject->bgRGB;

                    COMBO.SetRGB(promote.thisObject, RGB(0xc6, 0xe7, 0xff));
                }
                break;

            case WM_MOUSEHOVER:

                break;

            case WM_MOUSELEAVE:
                if (trackingFlag)
                {
                    trackingFlag = 0;
                    COMBO.SetRGB(promote.thisObject, bgRGBenter);
                }
                break;

            default:
                break;
        }
    }
    return CallWindowProc(wpOrigCOMBOProc, hwnd, msg, wParam, lParam);
}

#endif

// ---------------------------------

#if COMBO_HAS_OWNERDRAWN
    // ----------------------------------------------------------------
    //  example of a custom  ownerdrawn handler
    // ----------------------------------------------------------------

    OWNDERDRAWNHANDLER COMBO_OD_HANDLER;

static void  COMBO_OD_HANDLER(SOBDATA* sData, LPDRAWITEMSTRUCT lpDrawItemStruct)
{
    // when the WINDOW message handler is sent a  WM_DRAWITEM message, it will scan
    // the SOB DATA to find the SOB with the HWND referenced by the WM_DRAWITEM message's
    // (LPDRAWITEMSTRUCT)lParam structure.
    // If the  HWND  is found then that SOB's ownerDrawnHandler field is checked for an
    // entry (i.e.  NEQU NULL). If NEQU NULL then the value is treated as a functional pointer
    // a COMBO_OD_HANDLER function!

    // the code, bDrawButtonRGB,  is common to BUTTONs and STATIC widgets and is fairly involved.
    // So it has been made a common function located in the  ownderdraw_support files.

    bDrawButtonRGB(sData, lpDrawItemStruct);
}

#endif

// ---------------------------------

#if COMBO_HAS_RGB

    COMBOFNC_SETVALUE COMBO_SetRGB;
static  myUInt COMBO_SetRGB(COMBOOBJECT* thisObject, myUInt rgbValue)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU COMBOId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COMBO.SetRGB given a non COMBO object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    return sob_SetRGB(thisObject->psSobData, (COLORREF)rgbValue);
}
#endif

// ---------------------------------

#if COMBO_HAS_STATE
    // some widget types have a  STATE
    // e.g. menu item ticked, radio button, check button

    COMBOFNC_GETVALUE COMBO_GetState;
static  myUInt COMBO_GetState(COMBOOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    if (thisObject->type NEQU COMBOId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COMBO.GetState given a non COMBO object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return
    (  (myInt)SendMessage(thisObject->hWnd, BM_GETCHECK, 0, 0)
    EQU BST_CHECKED
    );
}

// ---------------------------------

COMBOFNC_SETVALUE  COMBO_SetState;
static  myUInt COMBO_SetState(COMBOOBJECT* thisObject, myUInt check)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    if (thisObject->type NEQU COMBOId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COMBO.SetState given a non COMBO object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    SOBDATA* pData = thisObject->ppSobData;

    SOBDATA* cData = sob_get_first_child(pData);
    while (cData)
    {
        if (cData->type EQU  COMBOId)
        {
            SendMessage
            (cData->hWnd
            , BM_SETCHECK
            , (WPARAM)BST_UNCHECKED
            , 0
            );
        }
        cData = sob_get_next_child(cData);
    }

    if (check) check = BST_CHECKED;
    else  check = BST_UNCHECKED;

    SendMessage
    (thisObject->hWnd
    , BM_SETCHECK
    , (WPARAM)check
    , 0
    );
    return (check EQU BST_CHECKED);
}

// ---------------------------------

COMBOFNC_SHAKE COMBO_ToggleState;
static  myUInt COMBO_ToggleState(COMBOOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU COMBOId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COMBO.ToggleState given a non COMBO object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return  COMBO.SetState(thisObject, (COMBO.GetState(thisObject)  EQU 0));
}

#endif

// ---------------------------------

#if  COMBO_HAS_EVENTHANDLER

    // example of a EVENTHANDLER: in this case when the widget is clicked on with the mouse
    // Careful this  function is only valid for widgets that receive
    //   WM_COMMAND messages   carrying a  BN_CLICKED notification

    static void COMBO_object_clicked(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam, SOBDATA * sData)
{
    COMBOOBJECT* thisObject = (COMBOOBJECT*)lParam;
    WORD NotificationCode = HIWORD(wParam);
    WORD identifier = LOWORD(wParam);

    switch (NotificationCode)
    {
        case WS_HSCROLL | WS_VSCROLL | CBN_SELCHANGE :
            swprintf_s
            (txtBuffer, szTxtBuffer, L" COMBO clicked 0x%04x  0x%04x  0x%04x\n"
            , thisObject->sIndex
            , NotificationCode
            , identifier);    addText(txtBuffer);

            SOB.Report((SOBDATA*)thisObject);

            //          COMBO.ToggleState(thisObject);

            break;

        default:
            #if DebuggingAid
                swprintf_s
                (txtBuffer, szTxtBuffer, L" COMBO unhandled notification 0x%04x  0x%04x  0x%04x\n"
                , thisObject->sIndex
                , NotificationCode
                , identifier);    addText(txtBuffer);
            #endif

            break;
    }
}

COMBOFNC_SETEVENTHANDLER COMBO_SetEventHandler;
static myUInt COMBO_SetEventHandler(COMBOOBJECT* thisObject, EVENTHANDLER value)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU COMBOId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COMBO.SetEventHandler given a non COMBO object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    return SOB.SetEventHandler(SOBOBJ thisObject, value);
}

#endif

// ---------------------------------

#if  COMBO_HAS_EMPTY
    // some widget types can be emptied e.g. combo boxes, RichTextEdit ..

    COMBOFNC_SHAKE COMBO_Empty;
static  myUInt COMBO_Empty(COMBOOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    if (thisObject->type NEQU COMBOId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COMBO.Empty given a non COMBO object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    SendMessage(thisObject->hWnd, CB_RESETCONTENT, 0, 0);

    return  SOB.Empty(SOBOBJ thisObject);
}

#endif

// ---------------------------------

#if  COMBO_HAS_GREY
    // some widget types can be greyed e.g. menu items, some button types (rare but possible)

    COMBOFNC_SETVALUE COMBO_GetGrey;
static  myUInt COMBO_GetGrey(COMBOOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU COMBOId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COMBO.GetGrey given a non COMBO object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    return  SOB_OK;
}

COMBOFNC_SETVALUE COMBO_SetGrey;
static  myUInt COMBO_SetGrey(COMBOOBJECT* thisObject, myUInt value)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    if (thisObject->type NEQU COMBOId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COMBO.SetGrey given a non COMBO object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return  SOB_OK;
}

#endif

// ---------------------------------

#if  COMBO_HAS_SELECTION
    // some widget types have selectable items
    // e.g. COMBO boxes, edit fields

    COMBOFNC_GETVALUE COMBO_GetSelectionIndex;
static  myUInt COMBO_GetSelectionIndex(COMBOOBJECT* thisObject)
{

    if (thisObject->type NEQU COMBOId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COMBO.GetSelectionIndex given a non COMBO object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if COMBO_IS_2D
        return (myInt)SendMessage(thisObject->hWnd, CB_GETCURSEL, 0, 0);
    #endif

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

COMBOFNC_SETVALUE COMBO_SetSelectionIndex;
static  myUInt COMBO_SetSelectionIndex(COMBOOBJECT* thisObject, myUInt value)
{
    if (thisObject->type NEQU COMBOId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COMBO.SetSelectionIndex given a non COMBO object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if COMBO_IS_2D
        // Sets the ZERO based index to be  the currently selected item of the combo
        return (int)SendMessage(thisObject->hWnd, CB_SETCURSEL, value, 0);
    #endif

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

COMBOFNC_GETVALUE COMBO_GetItemCount;
static  myUInt COMBO_GetItemCount(COMBOOBJECT* thisObject)
{

    if (thisObject->type NEQU COMBOId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COMBO.GetItemCount given a non COMBO object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if COMBO_IS_2D

        return (myUInt)SendMessage(thisObject->hWnd, CB_GETCOUNT, 0, 0);
    #endif
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

COMBOFNC_NEWITEMTEXT COMBO_AddItem;
static myUInt COMBO_AddItem(COMBOOBJECT* thisObject, TCHAR* pText)
{
    if (thisObject->type NEQU COMBOId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COMBO.AddItem given a non COMBO object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if COMBO_IS_2D
        int index;

        index = (int)SendMessage(thisObject->hWnd, CB_ADDSTRING, 0, (LPARAM)pText);
        SendMessage(thisObject->hWnd, CB_SETITEMDATA, (WPARAM)index, (LPARAM)index);
        return (myUInt)index;
    #endif

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

COMBOFNC_GETITEMTEXT COMBO_GetItemText;
static TCHAR* COMBO_GetItemText(COMBOOBJECT* thisObject, myUInt index)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULL;

    if (thisObject->type NEQU COMBOId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COMBO.GetItemText given a non COMBO object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return NULL;
    }

    #define  TitleMax 255
    static TCHAR title[TitleMax + 1] = { 0 };

    myUInt len = (myUInt) SendMessage(thisObject->hWnd, CB_GETLBTEXTLEN, index, 0); // get character count

    if (len < TitleMax)   SendMessage(thisObject->hWnd, CB_GETLBTEXT, index, (LPARAM)title) ;

    return & title[0];
}

COMBOFNC_SETITEMTEXT COMBO_SetItemText;
static myUInt COMBO_SetItemText(COMBOOBJECT* thisObject, myUInt index, TCHAR* title)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU COMBOId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COMBO.SetItemText given a non COMBO object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return (myUInt)  SendMessage(thisObject->hWnd, CB_INSERTSTRING, index, (LPARAM)title);

}

COMBOFNC_SETVALUE COMBO_DeleteIndex;
static  myUInt COMBO_DeleteIndex(COMBOOBJECT* thisObject, myUInt value)
{
    if (thisObject->type NEQU COMBOId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COMBO.DeleteIndex given a non COMBO object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if COMBO_IS_2D
        // Sets the ZERO based index to be  the currently selected item of the combo
        return (int)SendMessage(thisObject->hWnd, CB_DELETESTRING, value, 0);
    #endif
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

COMBOFNC_GETITEMDATA COMBO_GetItemData;
static myUInt COMBO_GetItemData(COMBOOBJECT* thisObject, myUInt itemId)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULLV;

    if (thisObject->type NEQU COMBOId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COMBO.GetItemData given a non COMBO object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return   SendMessage(thisObject->hWnd, CB_GETITEMDATA, itemId, 0);
}

COMBOFNC_SETITEMDATA COMBO_SetItemData;
static myUInt COMBO_SetItemData(COMBOOBJECT* thisObject, myUInt itemId, myUInt uData)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU COMBOId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COMBO.SetItemData given a non COMBO object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    return  SendMessage(thisObject->hWnd, CB_SETITEMDATA, itemId, uData);;
}

#endif

COMBOFNC_GETVALUE  COMBO_GetUserData;
static myUInt COMBO_GetUserData(COMBOOBJECT* thisObject )
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULLV;

    if (thisObject->type NEQU COMBOId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COMBO.GetUserData given a non COMBO object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return NULLV;
    }

    return fnGetUserDataGeneric (SOBOBJ thisObject);
}

COMBOFNC_SETVALUE COMBO_SetUserData;
static myUInt COMBO_SetUserData(COMBOOBJECT* thisObject, myUInt value )
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU COMBOId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COMBO.SetUserData given a non COMBO object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return NULLV;
    }      return  fnSetUserDataGeneric(SOBOBJ thisObject, value);

}

// ---------------------------------
#if COMBO_HAS_TITLE

    COMBOFNC_GETTEXT  COMBO_GetTitle;
static TCHAR* COMBO_GetTitle(COMBOOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULL;
    return   SOB.GetTitle(SOBOBJ thisObject);
}

// ---------------------------------

COMBOFNC_SETTEXT  COMBO_SetTitle;
static myUInt COMBO_SetTitle(COMBOOBJECT* thisObject, TCHAR* txt)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return SOB.SetTitle(SOBOBJ thisObject, txt);
}
#endif

// ---------------------------------

SOBFNC_GETTEXT COMBO_SOB_GetType;
static TCHAR* COMBO_SOB_GetType(SOBDATA* thisSob)
{
    static TCHAR objText[] = TEXT("COMBO");
    return  objText;
}

COMBOFNC_GETTEXT COMBO_GetType;
static  TCHAR* COMBO_GetType(COMBOOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULL;
    return   COMBO_SOB_GetType(SOBOBJ thisObject);
}

// ---------------------------------

COMBOFNC_SETVALUE COMBO_SetShow;
static  myUInt COMBO_SetShow(COMBOOBJECT* thisObject, myUInt value)
{
    // this will need customising if the widget is complex
    // i.e. is really a member of a set of  widgets that can not all appear at the same time
    // e.g. a radio button     or an  overlay set

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return SOB.SetShow(SOBOBJ thisObject, value);
}

// ---------------------------------

// ---------------------------------

#if COMBO_HAS_STRETCH

    COMBOFNC_SETVALUE COMBO_SetStretch;
static  myUInt COMBO_SetStretch(COMBOOBJECT* thisObject, myUInt value)
{

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    SOB.SetStretch(SOBOBJ thisObject, value);

    return SOB.SetShow(SOBOBJ thisObject, value);
}

#endif

// ---------------------------------
#if COMBO_HAS_LAST

    COMBOFNC_LASTOBJECT COMBO_LastWidget;
static  COMBOOBJECT*  COMBO_LastWidget( )
{
    return COMBOLastCreated;
}
#endif

// ----------------------------------------------------------------
// the "destructor" function
// ----------------------------------------------------------------
SOBFNC_SHAKE COMBO_SOB_Delete;
static myUInt COMBO_SOB_Delete(SOBDATA* thisSob)
{
    // we need this function so that when a CONTAINER is deleted
    // it can trigger a delete of any widget related things of it's child
    // SOB OBJECTs here:-

    if (fnInvalidSobGeneric(thisSob)) return SOB_NOK;

    SOB.Delete(thisSob); // trigger the generic Delete

    return SOB_OK;
}

COMBOFNC_SHAKE COMBO_Delete;
static  myUInt COMBO_Delete(COMBOOBJECT* thisObject)
{
    // this will need customising if the widget is complex
    // i.e. is really a set of widgets
    // e.g. an  overlay set

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return   COMBO_SOB_Delete(SOBOBJ thisObject  );
}

// ----------------------------------------------------------------
//  inheritance from the underlying SOB
// ----------------------------------------------------------------

// if an inherited function is to be customised/overwritten
// then do it HERE:

COMBOFNC_GETTEXT  fnGetTypeTextCustom;
static TCHAR* fnGetTypeTextCustom(COMBOOBJECT* sData)
{
    return (TCHAR*)_TEXT("COMBO");
}

// ----------------------------------------------------------------
// the "constructor" function
// ----------------------------------------------------------------

COMBOOBJECT* COMBO_Create(TCHAR* txt, int lines, DWORD comboStyle);
static COMBOOBJECT* COMBO_Create(TCHAR* txt, int lines , DWORD comboStyle )
{
    union
    {
        SOBDATA* thisSob;
        COMBOOBJECT* thisObject;
    } promote = {0};

    // ---------------------------------
    // in some cases a given widget can only be assigned to certain types of container
    // this is probably the best case to catch such exceptions and
    // permit / block them as appropriate

    // ---------------------------------
    // use the FONT assigned to the PARENT as guidelines for text size

    SOBDATA* pData = sob_get_base(gpSobIndex);
    int nbrLines = 1;  // some CONSTRUCTOR functions want 2 input parameters,
    // typicaly the 2nd parameter is the height of the widget
    // give as the nbr of text lines

    #if COMBO_IS_2D
        if (comboStyle EQU CBS_SIMPLE)
        nbrLines= nbrLines* lines;
    #endif

    int height = 0;
    int width = 0;

    int_sob_text_size(pData, txt, &width, &height);

    // But the HEIGHT only covers text, we need to increase it to allow multiple text
    // lines   AND for any SOB surround
    int objHeight = height * nbrLines + 8;
    int objWidth = width + 20;

    // ---------------------------------
    // A  Screen OBject ( SOB )  is really a structure
    //    the GENERIC structure
    //    and a ptr to the VTABLE
    // ---------------------------------
    // An OBJECT instance is really a structure
    //    the GENERIC structure
    //    and a  ptr to the OBJECT's private functions
    // ---------------------------------
    // So a   SOB   and an    OBJECT     have identical structures
    // WHY:
    // This way we can create a SOB as a sort of generic OBJECT.
    // Some functions, predominantly concerned with
    //    screen size management
    //    screen position management
    //   are OBJECT independent.
    //
    // Then we can have an OBJECT specific "view" were each OBJECT type
    // can have its own strongly typed structure.
    // ---------------------------------

    if (!COMBOId)
    {
        // ---------------------------------
        #if DeveloperMode

            union
            {
                myUInt* pEntry;
                void * pVoid;
            } reRef = {0};

            reRef.pVoid = & COMBO;
            myUInt* pEntry = reRef.pEntry;

            int entryCount = sizeof(COMBOMETHODTABLE) / sizeof(void*);
            int i;
            for (i = 0; i < entryCount; i++)
            {
                if ((!*pEntry)   LOR(*pEntry BAND 0x07))
                { 
                    swprintf_s(txtBuffer, szTxtBuffer, _TEXT("COMBO methods table, entry: %02i,  not fully/correctly populated. 0x%llx\n"), i, *pEntry);
                    ReportError(txtBuffer);
                }
                pEntry++;
            }

        #endif

        // ---------------------------------

        COMBOId = int_next_maintype();

        // to allow a widget to change the default handling of a SOB
        //  1) create a COPY of the default SOB METHODS TABLE in the widget's code scope
        //  2) overwrite the functional pointer, in that COPY, to the address of an
        //     appropriate custom function.
        //     We do that when the first instance of this widget class is instantiated.
        //  3) and then the pointer, in the SOB data, to the default  SOB METHODS TABLE
        //     with a pointer to our COPY
        //     We do that, after step 2, when the first instance of this widget class is instantiated.

        // ---------------------------------
        //    SPACE for the COPY of the SOB METHODS TABLE  was made at the TOP of this source file
        //    SOBMETHODSTABLE  COMBOSOBMETHODSTABLE;
        // ---------------------------------
        // populate the COPY with the default SOB METHID TABLE

        fnInheritSOBmethods( &  COMBOSOBMETHODSTABLE);

        // ---------------------------------
        // now populate those entries, in the COPY of the  SOB METHODS TABLE , that are
        // to be widget specific

        COMBOSOBMETHODSTABLE.GetType = & COMBO_SOB_GetType;

        COMBOSOBMETHODSTABLE.Delete = & COMBO_SOB_Delete;
    }

    // ---------------------------------

    promote.thisSob = sob_new_new(COMBOId, SOB_CONTAINER_NO, objWidth, objHeight);
    if (promote.thisSob EQU NULL)
    {
        int_return_maintype();  //  give the custom COMBOId back
        return NULL;
    }

    // ---------------------------------
    // replace the default SOB METHOD TABLE with our widget's custom table

    //  promote.thisSob->sVtbl = &COMBOSOBMETHODSTABLE;

    promote.thisSob->comboHeight =    height* lines + 8;
    promote.thisSob->fncCustomGetTypeText = COMBO_SOB_GetType ;
    // promote.thisSob->fncCustomGetSubTypeText = COMBO_SOB_GetType;
    // promote.thisSob->fncCustomShow;

    promote.thisSob->txtRGB = -1; // use system default
    promote.thisSob->bgRGB  = -1; // use system default

    // ---------------------------------
    // create an instance of the  COMBO widget on the display

    PCWSTR objClassName = _TEXT(  "COMBOBOX");
    DWORD objStyle = WS_VISIBLE | WS_CHILD | WS_HSCROLL | WS_VSCROLL |  comboStyle; // ;

    //  (void)sob_CreateWindowExNew(promote.thisSob, 0, objClassName, txt, objStyle);
    pData = sob_get_base(promote.thisSob->pIndex);

    promote.thisSob->hWnd = CreateWindowExW
    (0
    , objClassName
    , txt
    , objStyle  BOR  WS_CLIPCHILDREN
    , promote.thisSob->displayX
    , promote.thisSob->displayY
    , promote.thisSob->displayWidth
    , promote.thisSob->comboHeight
    , pData->hWnd
    , pData->hMenu
    , appHInst
    , NULL
    );

    #if COMBO_HAS_SUBCLASS
        // ---------------------------------
        // if you need to subclass the widget (i.e. intercept its internal message handling)
        // then insert the interception function here.

        wpOrigCOMBOProc = (WNDPROC)SetWindowLongPtr(promote.thisObject->hWnd, GWLP_WNDPROC, (LONG_PTR)COMBO_SUBCLASS_proc);
    #endif

    #if COMBO_HAS_OWNERDRAWN
        // ---------------------------------
        // if this widget is ownderdraw then link in the handler here

        promote.thisSob->ownerDrawnHandler = COMBO_OD_HANDLER;
    #endif

    #if COMBO_HAS_EVENTHANDLER
        // ---------------------------------
        // All OBJECTS are created with a prime/main  EVENTHANDLER
        // For this particular OBJECT the prime/main  EVENTHANDLER
        // is a left mouse click

        // Normally the  "user"  sets a, probably different, EVENTHANDLER for
        // each instantiated widget.

        // If you want you can set a default EVENTHANDLER which the
        // "user" can overwrite for a specific OBJECT
        promote.thisSob->eventHandler = (EVENTHANDLER)COMBO_object_clicked;
    #endif
    COMBOLastCreated = promote.thisObject;
    return   promote.thisObject;
}

COMBOFNC_GETOBJECT COMBO_CreateSimple;
static COMBOOBJECT* COMBO_CreateSimple(COMBOCREATEPARAMETERS)
{
    return   COMBO_Create(txt, lines, CBS_SIMPLE);
}
COMBOFNC_GETOBJECT COMBO_CreateEdit;
static COMBOOBJECT* COMBO_CreateEdit(COMBOCREATEPARAMETERS)
{
    return   COMBO_Create(txt, lines, CBS_DROPDOWNLIST);
}

COMBOFNC_GETOBJECT COMBO_CreateList;
static COMBOOBJECT* COMBO_CreateList(COMBOCREATEPARAMETERS)
{
    return   COMBO_Create(txt, lines, CBS_DROPDOWN);
}
// ----------------------------------------------------------------
// the external view
// ----------------------------------------------------------------

// BE WARNED: must be in the same sequence as the struct defn in the  header file
// if you create custom functions / methods for this widget then they
// MUST be in the struct defn and initialised into this struct instance.

COMBOMETHODTABLE  COMBO =
{
    COMBO_CreateSimple
    , COMBO_CreateEdit
    , COMBO_CreateList

    , COMBO_Delete

    #if COMBO_HAS_RGB
        , COMBO_SetRGB
    #endif

    #if COMBO_HAS_EMPTY
        , COMBO_Empty
    #endif

    #if COMBO_HAS_STATE
        , COMBO_GetState
        , COMBO_SetState
        , COMBO_ToggleState

    #endif

    #if COMBO_HAS_EVENTHANDLER
        , COMBO_SetEventHandler
    #endif

    #if  COMBO_HAS_GREY
        , COMBO_GetGrey
        , COMBO_SetGrey
    #endif

    #if  COMBO_HAS_SELECTION
        , COMBO_GetSelectionIndex
        , COMBO_SetSelectionIndex

        , COMBO_AddItem

        , COMBO_GetItemCount

        , COMBO_GetItemText
        , COMBO_SetItemText

        , COMBO_GetItemData
        , COMBO_SetItemData

        , COMBO_DeleteIndex

    #endif

    #if COMBO_HAS_TITLE
        , COMBO_GetTitle
        , COMBO_SetTitle
    #endif

    #if COMBO_HAS_STRETCH
        , COMBO_SetStretch
    #endif

    #if COMBO_HAS_LAST
        , COMBO_LastWidget
    #endif

    , COMBO_GetUserData
    , COMBO_SetUserData

};

#endif
