#pragma once
#if 1

#define CHECKBUTTON_IS_2D 0
#define CHECKBUTTON_HAS_RGB 1
#define CHECKBUTTON_HAS_EMPTY 0
#define CHECKBUTTON_HAS_STATE 1
#define CHECKBUTTON_HAS_EVENTHANDLER 1
#define CHECKBUTTON_HAS_OWNERDRAWN 0
#define CHECKBUTTON_HAS_GREY 0
#define CHECKBUTTON_HAS_SELECTION 0
#define CHECKBUTTON_HAS_TEXT 0 
#define CHECKBUTTON_HAS_SUBCLASS 0
#define CHECKBUTTON_HAS_TITLE 1
#define CHECKBUTTON_HAS_STRETCH 1
#define CHECKBUTTON_HAS_LAST 1


#define CHECKBUTTONCREATEPARAMETERS TCHAR* txt 

// ----------------------------------------------------------------
// forward definition using a typedef
// the actual structure 

// typedef struct CHECKBUTTONOBJECT  CHECKBUTTONOBJECT;
// ----------------------------------------------------------------
// do NOT alter the following
// It is overlaid on a SOBDATA structure so they MUST be the same

typedef struct CHECKBUTTONOBJECT
{
    GENERICSOB
} CHECKBUTTONOBJECT;

// ----------------------------------------------------------------
// forward definition using a typedef for
// a widget object  (in this case CHECKBUTTON) specific functional prototypes

typedef myUInt CHECKBUTTONFNC_SHAKE(CHECKBUTTONOBJECT*);
typedef CHECKBUTTONOBJECT*  CHECKBUTTONFNC_LASTOBJECT();

typedef TCHAR* CHECKBUTTONFNC_GETTEXT(CHECKBUTTONOBJECT*);
typedef myUInt CHECKBUTTONFNC_SETTEXT(CHECKBUTTONOBJECT*, TCHAR*);

typedef myUInt CHECKBUTTONFNC_NEWITEMTEXT(CHECKBUTTONOBJECT* thisObject, TCHAR* pText);
typedef TCHAR* CHECKBUTTONFNC_GETITEMTEXT(CHECKBUTTONOBJECT*, myUInt );
typedef myUInt CHECKBUTTONFNC_SETITEMTEXT(CHECKBUTTONOBJECT*, myUInt , TCHAR*);

typedef myUInt CHECKBUTTONFNC_GETVALUE(CHECKBUTTONOBJECT*);
typedef myUInt CHECKBUTTONFNC_SETVALUE(CHECKBUTTONOBJECT*, myUInt);

typedef myUInt CHECKBUTTONFNC_GETITEMDATA(CHECKBUTTONOBJECT*, myUInt);
typedef myUInt CHECKBUTTONFNC_SETITEMDATA(CHECKBUTTONOBJECT*, myUInt, myUInt);

typedef myUInt CHECKBUTTONFNC_SETEVENTHANDLER(CHECKBUTTONOBJECT*, EVENTHANDLER);

typedef CHECKBUTTONOBJECT * CHECKBUTTONFNC_GETOBJECT(CHECKBUTTONCREATEPARAMETERS);   // some CREATORs only need the new objects "title"
//typedef CHECKBUTTONOBJECT* CHECKBUTTONFNC_GETOBJECT(TCHAR* , int nbr); // some need a integer usually to help define the objects height
 
// ----------------------------------------------------------------

typedef struct CHECKBUTTONMETHODTABLE_ 
{
    CHECKBUTTONFNC_GETOBJECT* Create;
    CHECKBUTTONFNC_SHAKE* Delete;


#if CHECKBUTTON_HAS_RGB
    CHECKBUTTONFNC_SETVALUE* SetRGB;
#endif


#if CHECKBUTTON_HAS_EMPTY
    CHECKBUTTONFNC_SHAKE* Empty;
#endif


#if CHECKBUTTON_HAS_STATE
    CHECKBUTTONFNC_GETVALUE* GetState;
    CHECKBUTTONFNC_SETVALUE* SetState;
    CHECKBUTTONFNC_SHAKE* ToggleState;
#endif


#if CHECKBUTTON_HAS_EVENTHANDLER
        CHECKBUTTONFNC_SETEVENTHANDLER* SetEventHandler;
#endif


#if  CHECKBUTTON_HAS_GREY
        CHECKBUTTONFNC_GETVALUE* GetGrey;
        CHECKBUTTONFNC_SETVALUE* SetGrey;
#endif


#if  CHECKBUTTON_HAS_SELECTION
        CHECKBUTTONFNC_GETVALUE* GetSelectionIndex;
        CHECKBUTTONFNC_SETVALUE* SetSelectionIndex;
        CHECKBUTTONFNC_NEWITEMTEXT* AddItem;
        CHECKBUTTONFNC_GETVALUE* GetItemCount;
        CHECKBUTTONFNC_GETITEMTEXT* GetItemText;
        CHECKBUTTONFNC_SETITEMTEXT* SetItemCText;
        CHECKBUTTONFNC_GETITEMDATA* GetItemData;
        CHECKBUTTONFNC_SETITEMDATA* SetItemData;

        CHECKBUTTONFNC_SETVALUE* DeleteIndex;
#endif

#if CHECKBUTTON_HAS_TITLE
        CHECKBUTTONFNC_GETTEXT* GetTitle;
        CHECKBUTTONFNC_SETTEXT* SetTitle;
#endif

#if CHECKBUTTON_HAS_STRETCH
        CHECKBUTTONFNC_SETVALUE* SetStretch;
#endif

#if CHECKBUTTON_HAS_LAST
        CHECKBUTTONFNC_LASTOBJECT * LastWidget;
#endif
        
        CHECKBUTTONFNC_GETVALUE* GetUserData;
        CHECKBUTTONFNC_SETVALUE* SetUserData;

} CHECKBUTTONMETHODTABLE;

// ----------------------------------------------------------------
// functional prototype for the  "external" methods of this OBJECT


// ---------------------------------
// this lets us write code of the form
//     CHECKBUTTONOBJECT myWidget = CHECKBUTTON.Create( "hello" ) ;   // create a new widget 
//     TCHAR * pwidType = CHECKBUTTON.GetType (myWid) ;          // get the "type"   of the widget
//     

extern CHECKBUTTONMETHODTABLE  CHECKBUTTON;

#endif
