#if 1

    #include "project.h"

    // ----------------------------------------------------------------
    // every function in this source file can be marked as   static
    // except for the "constructor" function
    // ----------------------------------------------------------------

    static MAINTYPE CHECKBUTTONId = SOB_TYPE_NO;

// to allow a widget to change the default handling of a SOB
//  1) create a COPY of the default SOB METHODS TABLE in the widget's code scope
//  2) overwrite the functional pointer, in that COPY, to the address of an
//     appropriate custom function.
//     We do that when the first instance of this widget class is instantiated.
//  3) and then the pointer, in the SOB data, to the default  SOB METHODS TABLE
//     with a pointer to our COPY
//     We do that, after step 2, when the first instance of this widget class is instantiated.

//  here we make SPACE for the COPY of the SOB METHODS TABLE

SOBMETHODSTABLE  CHECKBUTTONSOBMETHODSTABLE;

WNDPROC    wpOrigCHECKBUTTONProc ;

CHECKBUTTONOBJECT* CHECKBUTTONLastCreated;

// ---------------------------------

#if CHECKBUTTON_HAS_SUBCLASS

    // ----------------------------------------------------------------
    //  example of a custom  interception function     for a  subclassed   widget
    // ----------------------------------------------------------------

    static LRESULT CALLBACK CHECKBUTTON_SUBCLASS_proc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    // (demo) function causes the widget to change colour when the mouse hovers over the widget.
    // does not work for all widget types

    TRACKMOUSEEVENT tme = { sizeof(tme) };
    static myInt trackingFlag = 0;
    static COLORREF bgRGBenter = 0;

    union
    {
        SOBDATA* thisSob;
        CHECKBUTTONOBJECT* thisObject;
    } promote = {};

    // be WARNED
    // try to find an OBJECT by the value of a (generic) property, in this case
    // it's  HWND , we default to finding it by it scanning the SOBDATA.
    // If we assume, as in this function, that it was triggered by widget type XYZ
    // then we would need a widget specific search function.
    // So scan the SOBDATA and then "cast" using the union to the appropriate widgettype.

    promote.thisSob = sob_find_hwnd(hwnd);
    if (promote.thisSob)
    {
        switch (msg)
        {
            case WM_NCHITTEST:

                if (!trackingFlag)
                {
                    tme.dwFlags = TME_LEAVE; // TME_HOVER;
                    tme.hwndTrack = hwnd;
                    tme.dwHoverTime = 1000;
                    TrackMouseEvent(&tme);

                    trackingFlag = 1;
                    bgRGBenter = promote.thisObject->bgRGB;

                    CHECKBUTTON.SetRGB(promote.thisObject, RGB(0xc6, 0xe7, 0xff));
                }
                break;

            case WM_MOUSEHOVER:

                break;

            case WM_MOUSELEAVE:
                if (trackingFlag)
                {
                    trackingFlag = 0;
                    CHECKBUTTON.SetRGB(promote.thisObject, bgRGBenter);
                }
                break;

            default:
                break;
        }
    }
    return CallWindowProc(wpOrigCHECKBUTTONProc, hwnd, msg, wParam, lParam);
}

#endif

// ---------------------------------

#if CHECKBUTTON_HAS_OWNERDRAWN
    // ----------------------------------------------------------------
    //  example of a custom  ownerdrawn handler
    // ----------------------------------------------------------------

    OWNDERDRAWNHANDLER CHECKBUTTON_OD_HANDLER;

static void  CHECKBUTTON_OD_HANDLER(SOBDATA* sData, LPDRAWITEMSTRUCT lpDrawItemStruct)
{
    // when the WINDOW message handler is sent a  WM_DRAWITEM message, it will scan
    // the SOB DATA to find the SOB with the HWND referenced by the WM_DRAWITEM message's
    // (LPDRAWITEMSTRUCT)lParam structure.
    // If the  HWND  is found then that SOB's ownerDrawnHandler field is checked for an
    // entry (i.e.  NEQU NULL). If NEQU NULL then the value is treated as a functional pointer
    // a CHECKBUTTON_OD_HANDLER function!

    // the code, bDrawButtonRGB,  is common to BUTTONs and STATIC widgets and is fairly involved.
    // So it has been made a common function located in the  ownderdraw_support files.

    bDrawButtonRGB(sData, lpDrawItemStruct);
}

#endif

// ---------------------------------

#if CHECKBUTTON_HAS_RGB

    CHECKBUTTONFNC_SETVALUE CHECKBUTTON_SetRGB;
static  myUInt CHECKBUTTON_SetRGB(CHECKBUTTONOBJECT* thisObject, myUInt rgbValue)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU CHECKBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("CHECKBUTTON.SetRGB given a non CHECKBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    return sob_SetRGB(thisObject->psSobData, (COLORREF)rgbValue);
}
#endif

// ---------------------------------

#if CHECKBUTTON_HAS_STATE
    // some widget types have a  STATE
    // e.g. menu item ticked, radio button, check button

    CHECKBUTTONFNC_GETVALUE CHECKBUTTON_GetState;
static  myUInt CHECKBUTTON_GetState(CHECKBUTTONOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    if (thisObject->type NEQU CHECKBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("CHECKBUTTON.GetState given a non CHECKBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return
    (  (myInt)SendMessage(thisObject->hWnd, BM_GETCHECK, 0, 0)
    EQU BST_CHECKED
    );
}

// ---------------------------------

CHECKBUTTONFNC_SETVALUE  CHECKBUTTON_SetState;
static  myUInt CHECKBUTTON_SetState(CHECKBUTTONOBJECT* thisObject, myUInt check)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    if (thisObject->type NEQU CHECKBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("CHECKBUTTON.SetState given a non CHECKBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    SOBDATA* pData = thisObject->ppSobData;

    SOBDATA* cData = sob_get_first_child(pData);
    while (cData)
    {
        if (cData->type EQU  CHECKBUTTONId)
        {
            SendMessage
            (cData->hWnd
            , BM_SETCHECK
            , (WPARAM)BST_UNCHECKED
            , 0
            );
        }
        cData = sob_get_next_child(cData);
    }

    if (check) check = BST_CHECKED;
    else  check = BST_UNCHECKED;

    SendMessage
    (thisObject->hWnd
    , BM_SETCHECK
    , (WPARAM)check
    , 0
    );
    return (check EQU BST_CHECKED);
}

// ---------------------------------

CHECKBUTTONFNC_SHAKE CHECKBUTTON_ToggleState;
static  myUInt CHECKBUTTON_ToggleState(CHECKBUTTONOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU CHECKBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("CHECKBUTTON.ToggleState given a non CHECKBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return  CHECKBUTTON.SetState(thisObject, (CHECKBUTTON.GetState(thisObject)  EQU 0));
}

#endif

// ---------------------------------

#if  CHECKBUTTON_HAS_EVENTHANDLER

    // example of a EVENTHANDLER: in this case when the widget is clicked on with the mouse
    // Careful this  function is only valid for widgets that receive
    //   WM_COMMAND messages   carrying a  BN_CLICKED notification

    static void CHECKBUTTON_object_clicked(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam, SOBDATA * sData)
{
    CHECKBUTTONOBJECT* thisObject = (CHECKBUTTONOBJECT*)lParam;
    WORD NotificationCode = HIWORD(wParam);
    WORD identifier = LOWORD(wParam);

    switch (NotificationCode)
    {
        case BN_CLICKED :
            swprintf_s
            (txtBuffer, szTxtBuffer, L" CHECKBUTTON clicked 0x%04x  0x%04x  0x%04x\n"
            , thisObject->sIndex
            , NotificationCode
            , identifier);    addText(txtBuffer);

            SOB.Report((SOBDATA*)thisObject);

            //          CHECKBUTTON.ToggleState(thisObject);

            break;

        default:
            #if DebuggingAid
                swprintf_s
                (txtBuffer, szTxtBuffer, L" CHECKBUTTON unhandled notification 0x%04x  0x%04x  0x%04x\n"
                , thisObject->sIndex
                , NotificationCode
                , identifier);    addText(txtBuffer);
            #endif

            break;
    }
}

CHECKBUTTONFNC_SETEVENTHANDLER CHECKBUTTON_SetEventHandler;
static myUInt CHECKBUTTON_SetEventHandler(CHECKBUTTONOBJECT* thisObject, EVENTHANDLER value)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU CHECKBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("CHECKBUTTON.SetEventHandler given a non CHECKBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    return SOB.SetEventHandler(SOBOBJ thisObject, value);
}

#endif

// ---------------------------------

#if  CHECKBUTTON_HAS_EMPTY
    // some widget types can be emptied e.g. combo boxes, RichTextEdit ..

    CHECKBUTTONFNC_SHAKE CHECKBUTTON_Empty;
static  myUInt CHECKBUTTON_Empty(CHECKBUTTONOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    if (thisObject->type NEQU CHECKBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("CHECKBUTTON.Empty given a non CHECKBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    SendMessage(thisObject->hWnd, CB_RESETCONTENT, 0, 0);

    return  SOB.Empty(SOBOBJ thisObject);
}

#endif

// ---------------------------------

#if  CHECKBUTTON_HAS_GREY
    // some widget types can be greyed e.g. menu items, some button types (rare but possible)

    CHECKBUTTONFNC_SETVALUE CHECKBUTTON_GetGrey;
static  myUInt CHECKBUTTON_GetGrey(CHECKBUTTONOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU CHECKBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("CHECKBUTTON.GetGrey given a non CHECKBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    return  SOB_OK;
}

CHECKBUTTONFNC_SETVALUE CHECKBUTTON_SetGrey;
static  myUInt CHECKBUTTON_SetGrey(CHECKBUTTONOBJECT* thisObject, myUInt value)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    if (thisObject->type NEQU CHECKBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("CHECKBUTTON.SetGrey given a non CHECKBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return  SOB_OK;
}

#endif

// ---------------------------------

#if  CHECKBUTTON_HAS_SELECTION
    // some widget types have selectable items
    // e.g. COMBO boxes, edit fields

    CHECKBUTTONFNC_GETVALUE CHECKBUTTON_GetSelectionIndex;
static  myUInt CHECKBUTTON_GetSelectionIndex(CHECKBUTTONOBJECT* thisObject)
{

    if (thisObject->type NEQU CHECKBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("CHECKBUTTON.GetSelectionIndex given a non CHECKBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if CHECKBUTTON_IS_2D
        return (myInt)SendMessage(thisObject->hWnd, CB_GETCURSEL, 0, 0);
    #endif

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

CHECKBUTTONFNC_SETVALUE CHECKBUTTON_SetSelectionIndex;
static  myUInt CHECKBUTTON_SetSelectionIndex(CHECKBUTTONOBJECT* thisObject, myUInt value)
{
    if (thisObject->type NEQU CHECKBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("CHECKBUTTON.SetSelectionIndex given a non CHECKBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if CHECKBUTTON_IS_2D
        // Sets the ZERO based index to be  the currently selected item of the combo
        return (int)SendMessage(thisObject->hWnd, CB_SETCURSEL, value, 0);
    #endif

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

CHECKBUTTONFNC_GETVALUE CHECKBUTTON_GetItemCount;
static  myUInt CHECKBUTTON_GetItemCount(CHECKBUTTONOBJECT* thisObject)
{

    if (thisObject->type NEQU CHECKBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("CHECKBUTTON.GetItemCount given a non CHECKBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if CHECKBUTTON_IS_2D

        return (myUInt)SendMessage(thisObject->hWnd, CB_GETCOUNT, 0, 0);
    #endif
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

CHECKBUTTONFNC_NEWITEMTEXT CHECKBUTTON_AddItem;
static myUInt CHECKBUTTON_AddItem(CHECKBUTTONOBJECT* thisObject, TCHAR* pText)
{
    if (thisObject->type NEQU CHECKBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("CHECKBUTTON.AddItem given a non CHECKBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if CHECKBUTTON_IS_2D
        int index;

        index = (int)SendMessage(thisObject->hWnd, CB_ADDSTRING, 0, (LPARAM)pText);
        SendMessage(thisObject->hWnd, CB_SETITEMDATA, (WPARAM)index, (LPARAM)index);
        return (myUInt)index;
    #endif

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

CHECKBUTTONFNC_GETITEMTEXT CHECKBUTTON_GetItemText;
static TCHAR* CHECKBUTTON_GetItemText(CHECKBUTTONOBJECT* thisObject, myUInt index)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULL;

    if (thisObject->type NEQU CHECKBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("CHECKBUTTON.GetItemText given a non CHECKBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return NULL;
    }

    #define  TitleMax 255
    static TCHAR title[TitleMax + 1] = { 0 };

    myUInt len = (myUInt) SendMessage(thisObject->hWnd, CB_GETLBTEXTLEN, index, 0); // get character count

    if (len < TitleMax)   SendMessage(thisObject->hWnd, CB_GETLBTEXT, index, (LPARAM)title) ;

    return & title[0];
}

CHECKBUTTONFNC_SETITEMTEXT CHECKBUTTON_SetItemText;
static myUInt CHECKBUTTON_SetItemText(CHECKBUTTONOBJECT* thisObject, myUInt index, TCHAR* title)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU CHECKBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("CHECKBUTTON.SetItemText given a non CHECKBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return (myUInt)  SendMessage(thisObject->hWnd, CB_INSERTSTRING, index, (LPARAM)title);

}

CHECKBUTTONFNC_SETVALUE CHECKBUTTON_DeleteIndex;
static  myUInt CHECKBUTTON_DeleteIndex(CHECKBUTTONOBJECT* thisObject, myUInt value)
{
    if (thisObject->type NEQU CHECKBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("CHECKBUTTON.DeleteIndex given a non CHECKBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    #if CHECKBUTTON_IS_2D
        // Sets the ZERO based index to be  the currently selected item of the combo
        return (int)SendMessage(thisObject->hWnd, CB_DELETESTRING, value, 0);
    #endif
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return  SOB_OK;
}

CHECKBUTTONFNC_GETITEMDATA CHECKBUTTON_GetItemData;
static myUInt CHECKBUTTON_GetItemData(CHECKBUTTONOBJECT* thisObject, myUInt itemId)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULL;

    if (thisObject->type NEQU CHECKBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("CHECKBUTTON.GetItemData given a non CHECKBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }

    return   SendMessage(thisObject->hWnd, CB_GETITEMDATA, itemId, 0);
}

CHECKBUTTONFNC_SETITEMDATA CHECKBUTTON_SetItemData;
static myUInt CHECKBUTTON_SetItemData(CHECKBUTTONOBJECT* thisObject, myUInt itemId, myUInt uData)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU CHECKBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("CHECKBUTTON.SetItemData given a non CHECKBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return SOB_NOK;
    }
    return  SendMessage(thisObject->hWnd, CB_SETITEMDATA, itemId, uData);;
}

#endif

CHECKBUTTONFNC_GETVALUE  CHECKBUTTON_GetUserData;
static myUInt CHECKBUTTON_GetUserData(CHECKBUTTONOBJECT* thisObject )
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULLV;

    if (thisObject->type NEQU CHECKBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("CHECKBUTTON.GetUserData given a non CHECKBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return NULLV;
    }

    return fnGetUserDataGeneric (SOBOBJ thisObject);
}

CHECKBUTTONFNC_SETVALUE CHECKBUTTON_SetUserData;
static  myUInt CHECKBUTTON_SetUserData(CHECKBUTTONOBJECT* thisObject, myUInt value )
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;
    if (thisObject->type NEQU CHECKBUTTONId)
    {
        swprintf_s(txtBuffer, szTxtBuffer, _TEXT("CHECKBUTTON.SetUserData given a non CHECKBUTTON object\n"));  ReportError(txtBuffer);
        SOB.Report(SOBOBJ thisObject);
        return NULLV;
    }    
    return  fnSetUserDataGeneric(SOBOBJ thisObject, value);

}

// ---------------------------------
#if CHECKBUTTON_HAS_TITLE

    CHECKBUTTONFNC_GETTEXT  CHECKBUTTON_GetTitle;
static TCHAR* CHECKBUTTON_GetTitle(CHECKBUTTONOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULL;
    return   SOB.GetTitle(SOBOBJ thisObject);
}

// ---------------------------------

CHECKBUTTONFNC_SETTEXT  CHECKBUTTON_SetTitle;
static myUInt CHECKBUTTON_SetTitle(CHECKBUTTONOBJECT* thisObject, TCHAR* txt)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return SOB.SetTitle(SOBOBJ thisObject, txt);
}
#endif

// ---------------------------------

SOBFNC_GETTEXT CHECKBUTTON_SOB_GetType;
static TCHAR* CHECKBUTTON_SOB_GetType(SOBDATA* thisSob)
{
    static TCHAR objText[] = TEXT("CHECKBUTTON");
    return  objText;
}

CHECKBUTTONFNC_GETTEXT CHECKBUTTON_GetType;
static  TCHAR* CHECKBUTTON_GetType(CHECKBUTTONOBJECT* thisObject)
{
    if (fnInvalidSobGeneric(SOBOBJ thisObject))return NULL;
    return   CHECKBUTTON_SOB_GetType(SOBOBJ thisObject);
}

// ---------------------------------

CHECKBUTTONFNC_SETVALUE CHECKBUTTON_SetShow;
static  myUInt CHECKBUTTON_SetShow(CHECKBUTTONOBJECT* thisObject, myUInt value)
{
    // this will need customising if the widget is complex
    // i.e. is really a member of a set of  widgets that can not all appear at the same time
    // e.g. a radio button     or an  overlay set

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return SOB.SetShow(SOBOBJ thisObject, value);
}

// ---------------------------------

// ---------------------------------

#if CHECKBUTTON_HAS_STRETCH

    CHECKBUTTONFNC_SETVALUE CHECKBUTTON_SetStretch;
static  myUInt CHECKBUTTON_SetStretch(CHECKBUTTONOBJECT* thisObject, myUInt value)
{

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    SOB.SetStretch(SOBOBJ thisObject, value);

    return SOB.SetShow(SOBOBJ thisObject, value);
}

#endif

// ---------------------------------
#if CHECKBUTTON_HAS_LAST

    CHECKBUTTONFNC_LASTOBJECT CHECKBUTTON_LastWidget;
static  CHECKBUTTONOBJECT*  CHECKBUTTON_LastWidget( )
{
    return CHECKBUTTONLastCreated;
}
#endif

// ----------------------------------------------------------------
// the "destructor" function
// ----------------------------------------------------------------
SOBFNC_SHAKE CHECKBUTTON_SOB_Delete;
static myUInt CHECKBUTTON_SOB_Delete(SOBDATA* thisSob)
{
    // we need this function so that when a CONTAINER is deleted
    // it can trigger a delete of any widget related things of it's child
    // SOB OBJECTs here:-

    if (fnInvalidSobGeneric(thisSob)) return SOB_NOK;

    SOB.Delete(thisSob); // trigger the generic Delete

    return SOB_OK;
}

CHECKBUTTONFNC_SHAKE CHECKBUTTON_Delete;
static  myUInt CHECKBUTTON_Delete(CHECKBUTTONOBJECT* thisObject)
{
    // this will need customising if the widget is complex
    // i.e. is really a set of widgets
    // e.g. an  overlay set

    if (fnInvalidSobGeneric(SOBOBJ thisObject))return SOB_NOK;

    return   CHECKBUTTON_SOB_Delete(SOBOBJ thisObject  );
}

// ----------------------------------------------------------------
//  inheritance from the underlying SOB
// ----------------------------------------------------------------

// if an inherited function is to be customised/overwritten
// then do it HERE:

CHECKBUTTONFNC_GETTEXT  fnGetTypeTextCustom;
static TCHAR* fnGetTypeTextCustom(CHECKBUTTONOBJECT* sData)
{
    return (TCHAR*)_TEXT("CHECKBUTTON");
}

// ----------------------------------------------------------------
// the "constructor" function
// ----------------------------------------------------------------

CHECKBUTTONFNC_GETOBJECT CHECKBUTTON_Create;
static CHECKBUTTONOBJECT* CHECKBUTTON_Create(CHECKBUTTONCREATEPARAMETERS)
{
    union
    {
        SOBDATA* thisSob;
        CHECKBUTTONOBJECT* thisObject;
    } promote = {0};

    // ---------------------------------
    // in some cases a given widget can only be assigned to certain types of container
    // this is probably the best case to catch such exceptions and
    // permit / block them as appropriate

    // ---------------------------------
    // use the FONT assigned to the PARENT as guidelines for text size

    SOBDATA* pData = sob_get_base(gpSobIndex);
    int nbrLines = 1;  // some CONSTRUCTOR functions want 2 input parameters,
    // typicaly the 2nd parameter is the height of the widget
    // give as the nbr of text lines

    #if CHECKBUTTON_IS_2D
        nbrLines= nbrLines* lines;
    #endif

    int height = 0;
    int width = 0;

    int_sob_text_size(pData, txt, &width, &height);

    // But the HEIGHT only covers text, we need to increase it to allow multiple text
    // lines   AND for any SOB surround
    int objHeight = height * nbrLines + 8;
    int objWidth = width + 20;

    // ---------------------------------
    // A  Screen OBject ( SOB )  is really a structure
    //    the GENERIC structure
    //    and a ptr to the VTABLE
    // ---------------------------------
    // An OBJECT instance is really a structure
    //    the GENERIC structure
    //    and a  ptr to the OBJECT's private functions
    // ---------------------------------
    // So a   SOB   and an    OBJECT     have identical structures
    // WHY:
    // This way we can create a SOB as a sort of generic OBJECT.
    // Some functions, predominantly concerned with
    //    screen size management
    //    screen position management
    //   are OBJECT independent.
    //
    // Then we can have an OBJECT specific "view" were each OBJECT type
    // can have its own strongly typed structure.
    // ---------------------------------

    if (!CHECKBUTTONId)
    {
        // ---------------------------------
        #if DeveloperMode

            union
            {
                myUInt* pEntry;
                void * pVoid;
            } reRef = {0};

            reRef.pVoid = & CHECKBUTTON;
            myUInt* pEntry = reRef.pEntry;

            int entryCount = sizeof(CHECKBUTTONMETHODTABLE) / sizeof(void*);
            int i;
            for (i = 0; i < entryCount; i++)
            {
                if ((!*pEntry)   LOR(*pEntry BAND 0x07))
                { 
                    swprintf_s(txtBuffer, szTxtBuffer, _TEXT("CHECKBUTTON methods table, entry: %02i,  not fully/correctly populated. 0x%llx\n"), i, *pEntry);
                    ReportError(txtBuffer);
                }
                pEntry++;
            }

        #endif

        // ---------------------------------

        CHECKBUTTONId = int_next_maintype();

        // to allow a widget to change the default handling of a SOB
        //  1) create a COPY of the default SOB METHODS TABLE in the widget's code scope
        //  2) overwrite the functional pointer, in that COPY, to the address of an
        //     appropriate custom function.
        //     We do that when the first instance of this widget class is instantiated.
        //  3) and then the pointer, in the SOB data, to the default  SOB METHODS TABLE
        //     with a pointer to our COPY
        //     We do that, after step 2, when the first instance of this widget class is instantiated.

        // ---------------------------------
        //    SPACE for the COPY of the SOB METHODS TABLE  was made at the TOP of this source file
        //    SOBMETHODSTABLE  CHECKBUTTONSOBMETHODSTABLE;
        // ---------------------------------
        // populate the COPY with the default SOB METHID TABLE

        fnInheritSOBmethods( &  CHECKBUTTONSOBMETHODSTABLE);

        // ---------------------------------
        // now populate those entries, in the COPY of the  SOB METHODS TABLE , that are
        // to be widget specific

        CHECKBUTTONSOBMETHODSTABLE.GetType = & CHECKBUTTON_SOB_GetType;

        CHECKBUTTONSOBMETHODSTABLE.Delete = & CHECKBUTTON_SOB_Delete;
    }

    // ---------------------------------

    promote.thisSob = sob_new_new(CHECKBUTTONId, SOB_CONTAINER_NO, objWidth, objHeight);
    if (promote.thisSob EQU NULL)
    {
        int_return_maintype();  //  give the custom CHECKBUTTONId back
        return NULL;
    }

    // ---------------------------------
    // replace the default SOB METHOD TABLE with our widget's custom table

    //  promote.thisSob->sVtbl = &CHECKBUTTONSOBMETHODSTABLE;

    // promote.thisSob->fncCustomDelete;    
    promote.thisSob->fncCustomGetTypeText = CHECKBUTTON_SOB_GetType ;
    // promote.thisSob->fncCustomGetSubTypeText = CHECKBUTTON_SOB_GetType;
    // promote.thisSob->fncCustomShow;

    promote.thisSob->txtRGB = -1; // use system default
    promote.thisSob->bgRGB  = -1; // use system default

    // ---------------------------------
    // create an instance of the  CHECKBUTTON widget on the display

    PCWSTR objClassName = _TEXT(  "BUTTON");
    DWORD objStyle = WS_VISIBLE | WS_CHILD |   BS_CHECKBOX | BS_OWNERDRAW ; // | BS_OWNERDRAW;

    (void)sob_CreateWindowExNew(promote.thisSob, 0, objClassName, txt, objStyle);

    #if CHECKBUTTON_HAS_SUBCLASS
        // ---------------------------------
        // if you need to subclass the widget (i.e. intercept its internal message handling)
        // then insert the interception function here.

        wpOrigCHECKBUTTONProc = (WNDPROC)SetWindowLongPtr(promote.thisObject->hWnd, GWLP_WNDPROC, (LONG_PTR)CHECKBUTTON_SUBCLASS_proc);
    #endif

    #if CHECKBUTTON_HAS_OWNERDRAWN
        // ---------------------------------
        // if this widget is ownderdraw then link in the handler here

        promote.thisSob->ownerDrawnHandler = CHECKBUTTON_OD_HANDLER;
    #endif

    #if CHECKBUTTON_HAS_EVENTHANDLER
        // ---------------------------------
        // All OBJECTS are created with a prime/main  EVENTHANDLER
        // For this particular OBJECT the prime/main  EVENTHANDLER
        // is a left mouse click

        // Normally the  "user"  sets a, probably different, EVENTHANDLER for
        // each instantiated widget.

        // If you want you can set a default EVENTHANDLER which the
        // "user" can overwrite for a specific OBJECT
        promote.thisSob->eventHandler = (EVENTHANDLER)CHECKBUTTON_object_clicked;
    #endif
    CHECKBUTTONLastCreated = promote.thisObject;
    return   promote.thisObject;
}

// ----------------------------------------------------------------
// the external view
// ----------------------------------------------------------------

// BE WARNED: must be in the same sequence as the struct defn in the  header file
// if you create custom functions / methods for this widget then they
// MUST be in the struct defn and initialised into this struct instance.

CHECKBUTTONMETHODTABLE  CHECKBUTTON =
{
    CHECKBUTTON_Create
    , CHECKBUTTON_Delete

    #if CHECKBUTTON_HAS_RGB
        , CHECKBUTTON_SetRGB
    #endif

    #if CHECKBUTTON_HAS_EMPTY
        , CHECKBUTTON_Empty
    #endif

    #if CHECKBUTTON_HAS_STATE
        , CHECKBUTTON_GetState
        , CHECKBUTTON_SetState
        , CHECKBUTTON_ToggleState

    #endif

    #if CHECKBUTTON_HAS_EVENTHANDLER
        , CHECKBUTTON_SetEventHandler
    #endif

    #if  CHECKBUTTON_HAS_GREY
        , CHECKBUTTON_GetGrey
        , CHECKBUTTON_SetGrey
    #endif

    #if  CHECKBUTTON_HAS_SELECTION
        , CHECKBUTTON_GetSelectionIndex
        , CHECKBUTTON_SetSelectionIndex

        , CHECKBUTTON_AddItem

        , CHECKBUTTON_GetItemCount

        , CHECKBUTTON_GetItemText
        , CHECKBUTTON_SetItemText

        , CHECKBUTTON_GetItemData
        , CHECKBUTTON_SetItemData

        , CHECKBUTTON_DeleteIndex

    #endif

    #if CHECKBUTTON_HAS_TITLE
        , CHECKBUTTON_GetTitle
        , CHECKBUTTON_SetTitle
    #endif

    #if CHECKBUTTON_HAS_STRETCH
        , CHECKBUTTON_SetStretch
    #endif

    #if CHECKBUTTON_HAS_LAST
        , CHECKBUTTON_LastWidget
    #endif

    , CHECKBUTTON_GetUserData
    , CHECKBUTTON_SetUserData

};

#endif
