
#pragma once

 

typedef  unsigned short   SOBID ;
#define SOBID_ERROR (SOBID) -1

#define SOBOBJ (SOBDATA *) 


#define MAX_NBR_SOBS  1024


typedef enum {
	SOB_TYPE_NO = 0 
, SOB_TYPE_CONTAINER
 , SOB_TYPE_MENU_V
	, SOB_TYPE_INVALID
} MAINTYPE;
 


typedef enum {
	SOB_UPDATE_NEW = 0
	, SOB_UPDATE_CHANGE
	, SOB_UPDATE_DELETE
	, SOB_UPDATE_DISPLAY
} SOBUPDATE;

typedef void (*CONHANDLER)  (SOBUPDATE updataAction, SOBID sobId);

typedef enum {
	SOB_CONTAINER_NO = 0
	, SOB_CONTAINER_WINDOW
	, SOB_CONTAINER_MENU_BAR
	, SOB_CONTAINER_MENU_H
	, SOB_CONTAINER_ROW
	, SOB_CONTAINER_ROW_W
	, SOB_CONTAINER_COL
	, SOB_CONTAINER_COL_W


	, SOB_CONTAINER_COLS
	, SOB_CONTAINER_ROWS

	, SOB_CONTAINER_INVALID
} CONTYPE;

/*
 FUNCTIONAL PROTOTYPES

 typedef double MyFunction(int, double, float, double, int (*)[42]);
 MyFunction foo, bar, baz;

is equivalent to the following FUNCTIONAL PROTOTYPES

 double foo(int, double, float, double, int (*)[42]);
 double bar(int, double, float, double, int (*)[42]);
 double baz(int, double, float, double, int (*)[42]);

*/


typedef struct SOBDATA  SOBDATA;
typedef LRESULT(*EVENTHANDLER)  (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam, SOBDATA* sData);

// ----------------------------------------------------------------
typedef void  OWNDERDRAWNHANDLER (SOBDATA *, LPDRAWITEMSTRUCT );
 
typedef myUInt   CONTAINERINFORM (SOBDATA*);
typedef TCHAR *  CONTAINERGETTEXT(SOBDATA*);
typedef myUInt   CONTAINERSETVALUE(SOBDATA*, myUInt );
typedef SOBDATA* CONTAINERCREATE( );
typedef SOBDATA* CONTAINERCREATE2D(myUInt , myUInt);
typedef SOBDATA* CONTAINERCREATE2T(TCHAR*, TCHAR*);
typedef SOBDATA* CONTAINERCREATE1T(TCHAR* );
typedef SOBDATA* CONTAINERGETSOBDATA(SOBDATA*);
typedef myUInt   CONTAINERSETEVENTHANDLER(SOBDATA*, EVENTHANDLER );
// ---------------------------------
// this is the VTABLE structure for a SOB CONTAINER
// we only need a few functions / methods


#define GENERICCONTAINERVTPL \
CONTAINERINFORM* Update;\
CONTAINERINFORM* Delete;\
CONTAINERINFORM* Display;\
CONTAINERGETTEXT* TypeText;\
CONTAINERSETVALUE* Stretch;\
CONTAINERINFORM* ReSize;\
CONTAINERINFORM* UpDateChildren;\
CONTAINERINFORM* Open; \
CONTAINERCREATE* LastWidget ; \
CONTAINERGETSOBDATA* FirstChild ;\
CONTAINERINFORM* DeleteChildren; 


typedef struct MNGR_METHOD_TABLE_GENERIC_ {
	CONTAINERINFORM* AddChild;
		GENERICCONTAINERVTPL
} MNGR_METHOD_TABLE_GENERIC;


typedef struct PVTBL_ {
	CONTAINERINFORM* AddChild;
	GENERICCONTAINERVTPL
	CONTAINERCREATE* Create; 
	CONTAINERSETVALUE* Share;
} PVTBL;

typedef struct PVTBL2D_ {
	CONTAINERINFORM* AddChild;
	GENERICCONTAINERVTPL
		CONTAINERCREATE2D* Create;
} PVTBL2D;

typedef struct PVTBL0T_ {
	CONTAINERINFORM* AddChild;
	GENERICCONTAINERVTPL
		CONTAINERCREATE* Create;
} PVTBL0T;



typedef struct PVTBL1T_ {
	CONTAINERINFORM* AddChild;
	GENERICCONTAINERVTPL
		CONTAINERCREATE1T* Create;
} PVTBL1T;

typedef struct PVTBL2T_ {
	CONTAINERINFORM* AddChild;
	GENERICCONTAINERVTPL
    CONTAINERCREATE2T* Create;
} PVTBL2T;


typedef struct PVTBLMENUH_ {
	CONTAINERCREATE1T* AddChild;
	GENERICCONTAINERVTPL
		CONTAINERCREATE1T* Create;
	CONTAINERSETEVENTHANDLER* SetEventHandler;

	CONTAINERGETSOBDATA* GetChecked;

} PVTBLMENUH;

// ----------------------------------------------------------------

typedef myUInt SOBFNC_SHAKE(SOBDATA*);
typedef myUInt SOBFNC_GETVALUE(SOBDATA*);
typedef myUInt SOBFNC_SETVALUE(SOBDATA*, myUInt);

typedef myUInt  SOBFNC_SETRGB( SOBDATA*, COLORREF);
typedef COLORREF SOBFNC_GETRGB(SOBDATA*);

typedef SOBDATA* SOBFNC_GETSOB(SOBDATA*);

typedef SOBDATA* SOBFNC_GETCURRENT( );


typedef TCHAR* SOBFNC_GETTEXT(SOBDATA*);
typedef myUInt SOBFNC_SETTEXT(SOBDATA*, TCHAR*);

typedef myUInt SOBFNC_SETEVENTHANDLER(SOBDATA*, EVENTHANDLER);
typedef SOBDATA* SOBFNC_CREATE(MAINTYPE sobType, CONTYPE conType, int width, int height);
typedef myUInt SOBFNC_GETVALUEINDIRECT(SOBDATA*, myUInt*);
typedef SOBDATA* SOBFNC_GETSOBDATA(SOBDATA* );

typedef myUInt SOBFNC_GETCOLORREFINDIRECT(SOBDATA*, COLORREF*);
typedef myUInt SOBFNC_SETCOLORREF(SOBDATA*, COLORREF);
 

// ----------------------------------------------------------------
// this is a "macro" to define the functions / methods that 
// are generic to all custom OBJECT's VTABLE
// BUT can be overwritten by the custom OBJECT

// If you have a new generic function / method  then add it to
// this  #define

#define GENERICCVTPL \
SOBFNC_GETTEXT* GetSobType ;\
SOBFNC_GETTEXT* GetSobTitle;\
SOBFNC_SETTEXT* SetSobTitle;\
SOBFNC_SETTEXT* AddSobText;\
SOBFNC_SHAKE* Empty; \
SOBFNC_GETSOBDATA* GetSOBOBJ;  

// ---------------------------------
// do NOT alter the following

typedef struct CVTBL_  {
	GENERICCVTPL
} CVTBL;


// ----------------------------------------------------------------
//
//     SOBOBJ external view 
//
// ----------------------------------------------------------------
// this macro is used to POPULATE a 

SOBFNC_GETSOB  sob_get_next_child;
SOBFNC_GETSOB  sob_get_first_child;

SOBFNC_SETVALUE  sob_set_stretch;

SOBFNC_SETVALUE  fnSetStretchGeneric;
SOBFNC_SETVALUE  fnSetShareGeneric;
SOBFNC_GETVALUE  fnGetUserDataGeneric;
SOBFNC_SETVALUE fnSetUserDataGeneric;

SOBFNC_GETSOB fnGetNextChildGeneric;

SOBFNC_GETSOB fnGetFirstChildGeneric;
SOBFNC_SHAKE  fnDeleteGeneric;
SOBFNC_SHAKE  fnDeleteChildrenGeneric;
SOBFNC_GETTEXT  fnGetTypeTextGeneric;
SOBFNC_GETTEXT  fnGetSubTypeTextGeneric;
SOBFNC_CREATE  sob_new_new;
SOBFNC_CREATE  fnCreateSobGeneric;
SOBFNC_SHAKE fnDisplayGeneric;
SOBFNC_SETVALUE fnSetShowGeneric;
SOBFNC_SHAKE fnReportGeneric;
SOBFNC_SHAKE fnEmptyGeneric;
SOBFNC_SETTEXT fnSetTitleGeneric;
SOBFNC_GETTEXT  fnGetTypeGeneric;
SOBFNC_GETSOBDATA fnGetSobObj;

SOBFNC_GETCURRENT fnGetContainer;

SOBFNC_SHAKE  fnOpen;

SOBFNC_GETSOB fnGetParent;



//   fnCreateSobGeneric

#define SOBMETHODSGENERIC \
  fnDeleteGeneric\
, fnDeleteChildrenGeneric \
, fnReportGeneric\
, fnGetUserDataGeneric\
, fnSetUserDataGeneric\
, fnGetFirstChildGeneric\
, fnGetNextChildGeneric\
, fnSetShowGeneric\
, fnDisplayGeneric\
, fnGetTypeTextGeneric\
, fnGetSubTypeTextGeneric\
, fnSetStretchGeneric\
, fnSetShareGeneric\
, fnSetEventHandlerGeneric\
, fnGetTitleGeneric\
, fnSetTitleGeneric\
, fnGetParent\
, fnOpen\
, fnGetContainer\
, fnEmptyGeneric

// SOBFNC_CREATE* Create;


#define SOBMETHODSGENERICSTRUCT \
SOBFNC_SHAKE* Delete;\
SOBFNC_SHAKE* DeleteChildren;\
SOBFNC_SHAKE* Report;\
SOBFNC_GETVALUE* GetUserData;\
SOBFNC_SETVALUE* SetUserData;\
SOBFNC_GETSOB* GetFirstChild;\
SOBFNC_GETSOB* GetNextChild;\
SOBFNC_SETVALUE* SetShow;\
SOBFNC_SHAKE* DisplaySob;\
SOBFNC_GETTEXT* GetType;\
SOBFNC_GETTEXT* GetSubType;\
SOBFNC_SETVALUE* SetStretch;\
SOBFNC_SETVALUE* SetShare;\
SOBFNC_SETEVENTHANDLER* SetEventHandler;\
SOBFNC_GETTEXT* GetTitle;\
SOBFNC_SETTEXT* SetTitle;\
SOBFNC_GETSOB* GetParent;\
SOBFNC_SHAKE* Open;\
SOBFNC_GETCURRENT *GetContainer;\
SOBFNC_SHAKE* Empty; 

/*

SOBFNC_GETCOLORREFINDIRECT* GetTextRGB;\
SOBFNC_SETCOLORREF* SetTextRGB;\
SOBFNC_GETCOLORREFINDIRECT* GetFillRGB;\
SOBFNC_SETCOLORREF* SetFillRGBG;
*/


typedef struct SOBMETHODSTABLE_ {
	SOBMETHODSGENERICSTRUCT
		SOBFNC_CREATE* Create;
} SOBMETHODSTABLE;

extern SOBMETHODSTABLE SOB;

// ----------------------------------------------------------------

#include "canvas.h" 


// ----------------------------------------------------------------
// this is a "macro" to define the variables / properties of a SOB object
// EXCEPT for the custom OBJECT's VTABLE

#define GENERICSOB \
SOBFNC_SHAKE   * fncCustomDelete;      \
SOBFNC_GETTEXT * fncCustomGetTypeText; \
SOBFNC_GETTEXT * fncCustomGetSubTypeText ; \
SOBFNC_SETVALUE * fncCustomShow ; \
SOBDATA* psSobData; \
SOBDATA* ppSobData; \
SOBDATA* stretchSobData; \
myUInt userData; \
SOBID sIndex; \
SOBID pIndex; \
MAINTYPE   type; \
CONTYPE   subType; \
short int top,left,right,bottom;\
short int ColOrRow, dimension, share , comboHeight;\
UINT showState ; \
int   nbrChildren; \
int   siblingNbr; \
int   effectiveWidth; \
int   effectiveHeight; \
int   minWidth; \
int   minHeight; \
int   displayX; \
int   displayY; \
int   displayWidth; \
int   displayHeight; \
int   txtRGB; \
int   bgRGB;  \
HWND  hWnd; \
HMENU hMenu; \
HBRUSH bgBrush ; \
canvasHANDLE * pCanvasHandle ; \
union { \
	EVENTHANDLER eventHandler; \
	CONHANDLER conHandler; \
}; \
OWNDERDRAWNHANDLER * ownerDrawnHandler ; \
SOBDATA* NextSiblingLink ; \
SOBDATA* PreviousSiblingLink ; \
SOBDATA* headLink; \
SOBDATA* tailLink; \
MNGR_METHOD_TABLE_GENERIC* pVtbl ; \
SOBMETHODSTABLE * sVtbl ;  

// ---------------------------------
// do NOT alter the following
// It is overlaid on a SOBDATA structure so they MUST be the same
// Ideally I would place this inside the relevant CPP file
// BUT we need it here to enable us to create
// the functional prototype for the various container "constructor" functions!

typedef struct SOBDATA 
{
	GENERICSOB
	CVTBL* cVtbl; 
} SOBDATA ;








#include "sob_top_level_window.h" 



 
#include "sob_con_col_w.h"
 
#include "sob_con_row_w.h"
 

 
#include "sob_PUSHBUTTON.h"
#include "sob_RADIOBUTTON.h"
#include "sob_CHECKBUTTON.h"


#include "sob_menubar.h"
#include "sob_menuH.h"
#include "sob_menuV.h"


#include "sob_COMBO.h"
 


#include "sob_IMAGE.h"

#include "sob_RichTextEdit.h"
 

 
#include "sob_con_ROW.h"
#include "sob_con_ROWWIDTH.h"
#include "sob_con_ROWHEIGHT.h"
 


 
#include "sob_con_COLUMN.h"
#include "sob_con_COLUMNHEIGHT.h"
#include "sob_con_COLUMNWIDTH.h"
#include "sob_con_FRAME.h"
 
#include "sob_con_GRID.h"

#include "sob_con_OVERLAY.h"
 
#include "sob_EDIT.h"
#include "sob_label.h"
#include "sob_ownerdrawn_support.h"

// ----------------------------------------------------------------
//
//     FUNCTION PROTOTYPES 
//
// ----------------------------------------------------------------













SOBDATA* sob_new_new(MAINTYPE sobType, CONTYPE conType, int width, int height);

SOBID sob_get_pSobIndex();
void  sob_set_pSobIndex(SOBID sobId);
 
// void sob_report(SOBDATA * sData);

void sob_set_HWND(SOBID sobId, HWND value);
HWND sob_get_HWND_parent(SOBID sobId);
HWND sob_get_HWND(SOBID sobId);

// void sob_set_HMENU(SOBID sobId, HMENU hMenu);
HMENU sob_get_HMENU(SOBID sobId);

// void sob_set_EVENTHANDLER(SOBDATA * sData, EVENTHANDLER eventHandler);
EVENTHANDLER sob_get_EVENTHANDLER(SOBID sobId);


CONTYPE sob_get_subtype(SOBID sobId);
MAINTYPE sob_get_type(SOBID sobId);

SOBID sob_get_pIndex(SOBID sobId);

SOBDATA* sob_get_base(SOBID sobId);

BOOL sob_index_check(SOBID sobId);

//SOBDATA* sob_menu_bar_new();
SOBDATA* sob_menu_h_new(TCHAR*);
SOBDATA* sob_menu_v_new(TCHAR*);
 


void sob_close();
SOBID sob_find_child(SOBID sobId, int childId);
SOBDATA* sob_find_hwnd(HWND hWnd);
SOBID sob_find_hmenu(HMENU hMenu);

void fnInheritSOBmethods(SOBMETHODSTABLE* pMethodTable);

SOBDATA* sob_get_next_child(SOBDATA* cData);
SOBDATA* sob_get_first_child(SOBDATA* pData);
myUInt sob_SetRGB(SOBDATA* thisSob, COLORREF rgbValue);


void codecontrol_sob(SYS_STATE state);


TCHAR* sob_container_to_text(CONTYPE container);
TCHAR* sob_type_to_text(MAINTYPE type);

void sobObj_delete (SOBDATA * );
void sobObj_SetShow(SOBDATA* sData, myUInt value);

 
TCHAR* sob_get_title(SOBID  sobId);
void sob_CreateWindowExNew(SOBDATA* sData, DWORD dwExStyle, PCWSTR lpClassName, LPCWSTR lpWindowName, DWORD dwStyle);

void sob_display_top_level_window(SOBID sobId);
 
void initialisePVTBL(PVTBL* Table);
void initialiseSOBMETHODSTABLE(CVTBL* Table);
SOBFNC_SETEVENTHANDLER fnSetEventHandlerGeneric;



TCHAR* fnGetTitleGeneric(SOBDATA* cData);
myUInt fnSetTitleGeneric(SOBDATA* cData,  TCHAR* title);

// myUInt fnSetEventHandlerGeneric(SOBDATA* cData, EVENTHANDLER value);
myUInt fnInvalidSobGeneric(SOBDATA* cData);


void int_sob_text_size(SOBDATA* sData, TCHAR* txt, int* w, int* h);

CVTBL* get_container_ctbl_generic();

MAINTYPE int_next_maintype();
void int_return_maintype();


CONTYPE int_next_contype();
void int_return_contype();

void sob_display_sob(SOBDATA*);

myUInt sob_set_stretch(SOBDATA* sData, myUInt value);


 // ----------------------------------------------------------------
//
//     extern  global variables 
//
// ----------------------------------------------------------------

extern SOBDATA* errorRichTextEdit;
extern SOBID sobIndex;
 
extern SOBDATA* menuBarData;
extern HINSTANCE appHInst;
extern HWND appHWND;

// SOB INDEX of the current 
extern SOBID gpSobIndex;
extern void sob_set_pSobObj(SOBDATA* sData);

// used to define the space around a SOB
extern  int lEdge , rEdge , tEdge  , bEdge ;
extern  RECT sobBnd ;

extern UINT ShowState  ; // SWP_HIDEWINDOW  SWP_SHOWWINDOW;

extern MNGR_METHOD_TABLE_GENERIC CONTAINER;

extern  myUInt sobDisplaying;

extern CONTYPE TOPWINDOWId;
extern CONTYPE MENUBARId;
extern CONTYPE MENUHId;
extern MAINTYPE MENUVId;
extern MAINTYPE COMBOId;

extern SOBDATA* TopWindowObj;

#define SOB_OK 0
#define SOB_NOK -1

