// header.h : include file for standard system include files,
// or project specific include files
//

#pragma once


#define DebuggingAid   0
#undef DebuggingAid

#define DeveloperMode 1

#define NULLV 0

#define ProjectTitle  _TEXT("Midi-Controller-As-Event-Trigger")
#define ProjectClass  _TEXT("Midi_in")
 

 
// If you uncomment the following line, then lots of errors relating to VARIANTs will appear!
// #define WIN32_LEAN_AND_MEAN             // Exclude rarely-used stuff from Windows headers
#include <windows.h>



#include <Winuser.h>
#include <commctrl.h>

// C RunTime Header Files
#include <stdlib.h>
#include <stdbool.h>



 
#include <malloc.h>
#include <memory.h>
#include <tchar.h>




// ----------------------------------------------
// general purpose  #defines

#define EQU ==
#define NEQU !=

#define BAND &
#define BOR |
#define LAND &&
#define LOR ||

 
#define CELL_SIZE_IN_BYTES 8

#define bTYPE08  0x0ff
#define bTYPE16  0x0ffff
#define bTYPE32  0x0ffffffff
#define bTYPE64  0x0ffffffffffffffff



               

#define sTYPE08  signed char
#define sTYPE16  __int16
#define sTYPE32  __int32
#define sTYPE64  __int64

//  #define uTYPE08 unsigned sTYPE08
#define uTYPE08  unsigned char

#define uTYPE16 unsigned sTYPE16
#define uTYPE32 unsigned sTYPE32
#define uTYPE64 unsigned sTYPE64
#define myInt sTYPE64
#define myhalfInt sTYPE32
#define myhalfUInt   uTYPE32
#define myUInt unsigned sTYPE64
#define CELL_TYPE unsigned sTYPE64


#define msb08  0x080
#define msb16  0x08000
#define msb32  0x080000000
#define msb64  0x08000000000000000

#define msbInt msb64
#define msbUInt msb64

// ----------------------------------------------


typedef union
{
    myUInt int64;
    unsigned short words[4];
    unsigned char  bytes[8];

} UNION64;



typedef  enum SYS_STATE
{
    SS_POWER_UP = 0
    , SS_POWER_DOWN
    , SS_RESTART
    , SS_RAW_FORTH
}  SYS_STATE;


 
#include <richedit.h>  // careful this is a system HEADER


#include "murmur.h"



// ---------------------------------
 

#include "canvas.h"
#include "lists.h"



#include "sob.h"
#include "usb_change.h"
#include "midi.h"
#include "debug.h"
 
 
#include "date.h"
 
#include "about.h"
 


 
#define szTxtBuffer 512
extern TCHAR txtBuffer[szTxtBuffer + 1];

 

#define MAX_LOADSTRING 100
 
extern WCHAR szWindowClass[MAX_LOADSTRING];
extern WCHAR szTitle[MAX_LOADSTRING];


extern HWND appHWND;
extern  HWND  rtEditHWND   ;


#define msg_handled_by_application 0
#define msg_not_handled_by_application 1

int register_msg_handler(int msgId, LRESULT(*cbFnc)  (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam));
 
myUInt initApplication();
void inform_modules(SYS_STATE state);

typedef LRESULT(*MESSAGEHANDLER)  (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

LRESULT  add_AppMessage(UINT, MESSAGEHANDLER);