#include "project.h"

// --------------------------------------------------------------------------------------------------------------------------------------
// https://stackoverflow.com/questions/7666509/hash-function-for-string
// Murmur One At A Time

#define MurmurOAAT64Factor  0x5bd1e9955bd1e995

// Characters ONE BY ONE

myUInt MurmurOAAT64COBO(myUInt h, TCHAR key)
{
    h ^= key;
    h *= MurmurOAAT64Factor;
    h ^= h >> 47;
    return h;
}

myUInt MurmurOAAT64FollowOn(TCHAR* key , myUInt h )
{
    if (key  EQU NULL) return h;

    for (; *key; ++key)
    {
        h ^= *key;
        h *= MurmurOAAT64Factor;
        h ^= h >> 47;
    }
    return h;
}

myUInt MurmurOAAT64(TCHAR* key)
{
    myUInt h = MurmurOAAT64Seed;
    if (key  EQU NULL) return 0;
    for (; *key; ++key)
    {
        h ^= *key;
        h *= MurmurOAAT64Factor;
        h ^= h >> 47;
    }
    return h;
}
