#pragma once

typedef myUInt  LISTINDEX ;
typedef myUInt  LISTCELLINDEX;


// ------------------------------------------------------------------------------------

struct myLC
{
    myUInt prevCellSize;
 
 
    LISTINDEX index;

     myUInt cellSize; // cell size   64-bit aligned !

    myUInt Key;
    myUInt Value0;
    myUInt Value1;
    
    myUInt nameOffset;
    myUInt nameSizeInTCHAR;
    myUInt blobOffset;
    myUInt blobSizeInBytes;

};

typedef struct myLC ListCell;
// ------------------------------------------------------------------------------------
// FUNCTIONAL PROTOTYPES

void codecontrol_lists(SYS_STATE state);

// note: functions with names like:_
//    lists_find_xxx
//    lists_dnif_xxx
//  are wrappers around
//    lists_cell_get_index_by_bytes
//    lists_cell_get_index_by_text

ListCell* lists_cell_find_by_key(LISTINDEX useListIndex, myUInt wantKey, myInt DirectionFlag,LISTCELLINDEX afterIndex);
ListCell* lists_cell_find_by_value0(LISTINDEX useListIndex, myUInt wantValue0, myInt DirectionFlag, LISTCELLINDEX afterIndex);
ListCell* lists_cell_find_by_value1(LISTINDEX useListIndex, myUInt wantValue1, myInt DirectionFlag, LISTCELLINDEX afterIndex);

void lists_list_initialise(LISTINDEX useListIndex);
myUInt lists_invalid_listIndex_check(LISTINDEX useListIndex);
ListCell* lists_cell_new_of_size(LISTINDEX useListIndex, myUInt nameSize, myUInt blobSize);


LISTCELLINDEX lists_cell_create(LISTINDEX useListIndex, myUInt Key, TCHAR* Caddr, myUInt cCount, myUInt value0, myUInt value1, unsigned char* pBlobSrc, myUInt blobSize);
myUInt lists_cell_get_by_index(LISTINDEX useListIndex, LISTCELLINDEX useCellIndex, myUInt* pKey,  TCHAR** pChar, myUInt* pCharSize, myUInt* pVal0, myUInt* pVal1, unsigned char** pBlob, myUInt* pBlobSize);
ListCell* lists_cell_by_index(LISTINDEX useListIndex, LISTCELLINDEX useCellIndex);


LISTINDEX lists_list_new();

/*
\ help_pos list=open

\\ (-- index)
\\ Returns the index of a  free list
\\ It does NOT automatically select that list !
\\ No input parameters
\\ --
\\ INDEX     0..63
\\           = -1 = no free list
\
*/


// --------------------------------------------------------------------------------------------
 // LISTCELLINDEX lists_cell_new_with_chars(LISTINDEX useListIndex, TCHAR* Caddr, myUInt value0, myUInt value1);

/*
\ help_pos list.chars.data=add
\\ ( xA , xB , c-addr , count , ListId -- u)
\\ If the   CHARACTER string identified by C-ADDR, COUNT is NOT
\\ already a member of the LIST then add it to the LIST.
\\ Return U the zero based index of the array/string.
\\
\\ ValueA    data value associated with CHARACTER string
\\ Valueb    data value associated with CHARACTER string
\\ C-ADDR    Address of CHARACTER    array/string
\\ COUNT     Size of  string  in bytes
\\ LISTID    Identity of list to be added to

\\ --
\\ U         The zero based index of this string
\\           -1 if not found
\
*/


 
// --------------------------------------------------------------------------------------------
 

void lists_list_allow_duplicates(LISTINDEX useListIndex, myInt uniqueFlag);
/*
\ help_pos list=unique
\\ ( bool --)
\\ defines whether the current LIST allows duplicate byte/char arrays
\\ BOOL   = 0  duplicate lines are permitted (default)
\\        else duplicate lines are dropped
\\ --
\\ No output parameters
\
*/

 
// --------------------------------------------------------------------------------------------


void lists_list_delete(LISTINDEX useListIndex);

/*
\ help_pos list=empty
\\ (--)
\\ Release the current LIST resource
\\ No input parameters
\\ --
\\ No output parameters
\
*/

// --------------------------------------------------------------------------------------------


myUInt lists_cell_set_values_by_index(LISTINDEX useListIndex, LISTCELLINDEX myuseCellIndex, myUInt Val0, myUInt Val1);
/*
\ help_pos list=value
\\ ( val0 , val1 , u --  -1 | 0)
\\ Set the user defined values val0, val1  associated with  U the zero based index of the currently active LIST
\\ VAL0      User data
\\ VAL1      User data
\\ U         The zero based index of this array/string
\\ --
\\ -1 | 0    Returns 0 if okay, else ERROR
*/



// --------------------------------------------------------------------------------------------
myUInt lists_cell_count_get(LISTINDEX useListIndex);

void show_CellEntry(ListCell* pLC);

// ------------------------------------------------------------------------------------
