#include "project.h"

#include "debug.h"
void clearText()
{

    if (rtEditHWND EQU NULL) return;

    SendMessage(rtEditHWND, WM_SETTEXT, 0, (LPARAM)L"");
}

void addText(   TCHAR* txt)
{
    //    if (rtEditHWND EQU NULL) return;

    SendMessage(rtEditHWND, EM_SETSEL, -1, -1);
    SendMessage(rtEditHWND, EM_REPLACESEL, 0, (LPARAM)txt);
}

static void addTextRTF(TCHAR* WideString)
{
    if (rtEditHWND EQU NULL) return;

    // example:
    // addTextRTF ( (TCHAR *) L"{\\rtf1\\ansi This is some \\b bold\\b0  text.}");
    // commands  such as  \b  \b0   MUST be followed a a SPACE or a \n
    DWORD WideLength = (DWORD)wcslen(WideString) + 1;
    PSTR Utf8;
    DWORD Length;
    INT ReturnedLength;

    // A utf8 representation shouldn't be longer than 4 times the size
    // of the utf16 one.
    Length = WideLength * 4;
    Utf8 = (PSTR)malloc(Length);
    if (!Utf8) { return; }

    ReturnedLength = WideCharToMultiByte
    (CP_UTF8
    , 0
    , WideString
    , WideLength - 1
    , Utf8
    , Length - 1
    , NULL
    , NULL
    );
    if (ReturnedLength)
    {
        // Need to zero terminate...
        Utf8[ReturnedLength] = 0;
    }
    else { /* TODO: handle failure */ }

    //  Pointer to the null-terminated text to insert. This text is an ANSI string, unless the code page is 1200 (Unicode),

    SETTEXTEX TextInfo = { 0 };

    TextInfo.flags = ST_SELECTION;
    TextInfo.codepage = CP_UTF8;

    SendMessage(rtEditHWND, EM_SETTEXTEX, (WPARAM)&TextInfo, (LPARAM)Utf8);

    free(Utf8);
}

static void addTextBoldA(TCHAR* txt)
{
    DWORD fromPos = 0, toPos = 0;;

    SendMessage(rtEditHWND, EM_SETSEL, -1, -1);
    SendMessage(rtEditHWND, EM_GETSEL, 0, (LPARAM)&fromPos);

    SendMessage(rtEditHWND, EM_REPLACESEL, 0, (LPARAM)txt);
    SendMessage(rtEditHWND, EM_SETSEL, fromPos, -1);

    SendMessage(rtEditHWND, EM_GETSEL, (WPARAM)&fromPos, (LPARAM)&toPos);
    SendMessage(rtEditHWND, EM_SETSEL, fromPos, toPos - 1);

#ifdef __cplusplus
    CHARFORMAT2 boldfont = {   };
#else
    CHARFORMAT2 boldfont = { 0 };
#endif
 
    boldfont.cbSize = sizeof(CHARFORMAT2);
    boldfont.dwMask = CFM_BOLD BOR CFM_COLOR;
    boldfont.dwEffects = CFE_BOLD;
    boldfont.crTextColor = 0x0ff;
    SendMessage(rtEditHWND, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&boldfont);
}

void addTextBold(TCHAR* txt)
{
    if (rtEditHWND EQU NULL) return;

    DWORD fromPos = 0, toPos = 0;;

    addTextBoldA(txt);

#ifdef __cplusplus
    CHARFORMAT2 boldfont = {   };
#else
    CHARFORMAT2 boldfont = { 0 };
#endif
    SendMessage(rtEditHWND, EM_SETSEL, -1, -1);
    SendMessage(rtEditHWND, EM_GETSEL, (WPARAM)&fromPos, (LPARAM)&toPos);
    SendMessage(rtEditHWND, EM_SETSEL, fromPos + 1, -1);

    SendMessage(rtEditHWND, EM_GETCHARFORMAT, SCF_SELECTION, (LPARAM)&boldfont);

    boldfont.cbSize = sizeof(CHARFORMAT2);
    boldfont.dwMask = CFM_BOLD BOR CFM_COLOR;
    boldfont.dwEffects = 0;
    boldfont.crTextColor = 0;
    SendMessage(rtEditHWND, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&boldfont);
}

void ReportError(TCHAR* txt)
{
    if (rtEditHWND EQU NULL)
    {
        //       MessageBox(NULL, txt, NULL, 0);
        return;
    }
    addTextBold(txt);
}

void debugIntdn(myUInt i)
{
    swprintf_s(txtBuffer, szTxtBuffer, L"%lld", i); addText(txtBuffer);
}

void debugIntn(myUInt i)
{
    swprintf_s(txtBuffer, szTxtBuffer, L"%llx", i); addText(txtBuffer);
}
void debugSpaces(myUInt i)
{
    while ( i --)
    addText((TCHAR*)_TEXT(" "));
}
void debugInt(myUInt i)
{
    swprintf_s(txtBuffer, szTxtBuffer, L"%llx\n", i); addText(txtBuffer);
}

void debugIntd(myUInt i)
{
    swprintf_s(txtBuffer, szTxtBuffer, L"%lld\n", i); addText(txtBuffer);
}

void debugn(TCHAR* cp)
{
    addText(cp);
}
void debug(TCHAR* cp)
{
    addText(cp);
    addText((TCHAR*)L"\n");
}

