#if  0
    #include "project.h"

    #include <olectl.h>
    #pragma comment( lib, "OleAut32.lib" )

    // goal: display an image file in a SOB

    // open file to a GDIP bitmap
    // convert GDIP bitmap to standard   bitmap
    // on DRAWITEM
    //     insert bitmap  BitBlt  to DC
    //

    // why use GDIP, consider OLE

int  int_canvas_add_bitmap(canvasHANDLE* pCanvasHandle, LONG targetWidth, LONG targetHeight)
{
    // ------------------------------------------------------------------
    BITMAPINFO bmiDib;
    memset(&bmiDib, 0, sizeof(BITMAPINFO));
    bmiDib.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
    bmiDib.bmiHeader.biWidth = (LONG)targetWidth;          // in pixels
    bmiDib.bmiHeader.biHeight = (LONG)targetHeight;         // in pixels
    bmiDib.bmiHeader.biPlanes = 1;
    bmiDib.bmiHeader.biBitCount = 32;
    bmiDib.bmiHeader.biCompression = BI_RGB;
    bmiDib.bmiHeader.biSizeImage = (((targetWidth * bmiDib.bmiHeader.biBitCount + 31) & ~31) >> 3) * targetHeight;

    // ------------------------------------------------------------------
    HDC hDC = GetDC(NULL);
    HDC memHDCDib = CreateCompatibleDC(hDC);

    BYTE* bitmapDIB_data = NULL;

    HBITMAP bitmap = CreateDIBSection(memHDCDib, &bmiDib, DIB_RGB_COLORS, (void**)&bitmapDIB_data, NULL, 0);
    if (bitmap EQU NULL)  return 0;
    SelectObject(memHDCDib, bitmap);
    ReleaseDC(NULL, hDC);
    DeleteDC(hDC);

    // ------------------------------------------------------------------

    pCanvasHandle->bm = bitmap;
    pCanvasHandle->dc = memHDCDib;
    pCanvasHandle->max_w = targetWidth;
    pCanvasHandle->max_h = targetHeight;

    pCanvasHandle->last_x = 0;
    pCanvasHandle->last_y = 0;

    pCanvasHandle->stride = ((((bmiDib.bmiHeader.biWidth * bmiDib.bmiHeader.biBitCount) + 31) & ~31) >> 3);
    pCanvasHandle->data = bitmapDIB_data;

    HPEN hPen = ( HPEN) GetCurrentObject(pCanvasHandle->dc, OBJ_PEN);
    LOGPEN usePen = { 0 };
    GetObject(hPen, sizeof(LOGPEN), &usePen);
    pCanvasHandle->originalPen = hPen;
    pCanvasHandle->penStyle = usePen.lopnStyle;
    pCanvasHandle->penWidth = usePen.lopnWidth.x;
    pCanvasHandle->penRGB = usePen.lopnColor;

    HBRUSH hBrush = (HBRUSH)GetCurrentObject(pCanvasHandle->dc, OBJ_BRUSH);
    LOGBRUSH useBrush = { 0 };
    GetObject(hBrush, sizeof(LOGBRUSH), &useBrush);
    pCanvasHandle->originalBrush = hBrush;
    pCanvasHandle->brushStyle = useBrush.lbStyle;
    pCanvasHandle->brushHatch = useBrush.lbHatch;
    pCanvasHandle->brushRGB = useBrush.lbColor;

    HFONT hFont = (HFONT) GetCurrentObject(pCanvasHandle->dc, OBJ_FONT);
    pCanvasHandle->originalFont = hFont;

    pCanvasHandle->updateAllowed = 1;
    pCanvasHandle->updatepending = 0;

    return 1;

}

canvasStruct canvasA ;

canvasHANDLE* int_canvas_create_dib(LONG targetWidth, LONG targetHeight)
{   // return 0 on error

    // ------------------------------------------------------------------

    canvasHANDLE* pCanvasHandle;
    pCanvasHandle = (canvasHANDLE*)malloc(sizeof(canvasStruct));
    if (pCanvasHandle EQU NULL)  return NULL;

    if (int_canvas_add_bitmap(pCanvasHandle, targetWidth, targetHeight))
    {
        SetBkMode(pCanvasHandle->dc, 1);  // transparent text background
        return pCanvasHandle;
    }

    return 0;
}

canvasHANDLE* canvas_from_file_ipic( TCHAR * OlePathName)
{
/*
\ help_pos canvas:new.iPic
\\ (   c-addr, u -- uCanvas)
\\ Create a CANVAS from a image file.
\\ Internally uses   OleLoadPicturePath  and   IPICTURE rendering
\\ C-ADDR   Character string at address, the  file name
\\ U        Length of character string
\\ --
\\ U-canvas
\
*/

    // ------------------------------------------------------------------
    // STEP 0 :    read the source IMAGE to a full size bitmap
    // ------------------------------------------------------------------

    // WARNING: written for COM in C++

    myUInt orientation = 0; // pop_ucell  () ;

    IPicture* Ipic = NULL;
    HRESULT hr;
    hr = OleLoadPicturePath
    (OlePathName
    , NULL
    , 0
    , 0
    ,  IID_IPicture   // & IID_IPicture   for plain old C
    , (void**)(&Ipic)
    );

    if ( (FAILED(hr))  LOR(Ipic EQU NULL)  )    return 0 ;

    // ------------------------------------------------------------------
    HDC hDC = GetDC(NULL);

    const int HIMETRIC_PER_INCH = 2540;

    int nPixelsPerInchX = GetDeviceCaps(hDC, LOGPIXELSX);
    int nPixelsPerInchY = GetDeviceCaps(hDC, LOGPIXELSY);

    // get width and height of picture
    SIZE   sizeInHiMetric = { 0 };

    Ipic->get_Width(  &sizeInHiMetric.cx);
    Ipic->get_Height(  &sizeInHiMetric.cy);

    // convert himetric to pixels
    long targetWidth = (nPixelsPerInchX * sizeInHiMetric.cx + HIMETRIC_PER_INCH / 2) / HIMETRIC_PER_INCH;
    long targetHeight = (nPixelsPerInchY * sizeInHiMetric.cy + HIMETRIC_PER_INCH / 2) / HIMETRIC_PER_INCH;

    // ------------------------------------------------------------------

    canvasHANDLE* pSrcCanvasHandle = int_canvas_create_dib(targetWidth, targetHeight);
    if (!pSrcCanvasHandle)
    {
        hr = Ipic->Release();

        return 0;
    }

    // ------------------------------------------------------------------
    // render image

    SetStretchBltMode(pSrcCanvasHandle->dc, HALFTONE);
    SetBrushOrgEx(pSrcCanvasHandle->dc, 0, 0, NULL); ;

    hr = Ipic->Render
    (  pSrcCanvasHandle->dc
    , 0, 0, targetWidth, targetHeight
    , 0                         // src x
    , sizeInHiMetric.cy         // src y
    , sizeInHiMetric.cx
    , -sizeInHiMetric.cy
    , NULL
    );

    hr = Ipic->Release();

    return pSrcCanvasHandle ;

}

canvasHANDLE* canvas_from_file_gdip(TCHAR *fileName )
{
/*
\ help_pos canvas:new.file
\\ (c-addr, u -- u-canvas)
\\ Create a canvas from the image file (bmp/jpg/jpeg/gif) specified by the character string at
\\ address c-addr of length U.
\\ C-ADDR   Character string at address, the  file name
\\ U        Length of character string
\\ --
\\ U-canvas    Identity of created canvas
\\             = 0 on error
\
*/

    HBITMAP  hBitmap = int_create_bitmap_from_file_GDIP(fileName);

    if (hBitmap  EQU NULL)  return NULL;

    canvasHANDLE* pCanvasHandle;
    pCanvasHandle = (canvasHANDLE*)malloc(sizeof(canvasStruct));
    if (pCanvasHandle EQU NULL)  return NULL;

    // ------------------------------------------------------------------

    BITMAP bm = { 0 };
    GetObject(hBitmap, sizeof(BITMAP), &bm);

    // ------------------------------------------------------------------

    HDC hDC = GetDC(NULL);
    HDC memHDCDib = CreateCompatibleDC(hDC);

    SelectObject(memHDCDib, hBitmap);
    ReleaseDC(NULL, hDC);
    DeleteDC(hDC);

    // ------------------------------------------------------------------

    pCanvasHandle->bm = hBitmap;
    pCanvasHandle->dc = memHDCDib;
    pCanvasHandle->max_w = bm.bmWidth;
    pCanvasHandle->max_h = bm.bmHeight;

    pCanvasHandle->DisableHalfTone = 0; // allow halftone handling in  StretchBlt operations

    pCanvasHandle->last_x = 0;
    pCanvasHandle->last_y = 0;

    pCanvasHandle->stride = bm.bmWidthBytes;
    // pCanvasHandle->data = bm.bmBits;

    HPEN hPen = (HPEN) GetCurrentObject(pCanvasHandle->dc, OBJ_PEN);
    LOGPEN usePen = { 0 };
    GetObject(hPen, sizeof(LOGPEN), &usePen);
    pCanvasHandle->originalPen = hPen;
    pCanvasHandle->penStyle = usePen.lopnStyle;
    pCanvasHandle->penWidth = usePen.lopnWidth.x;
    pCanvasHandle->penRGB = usePen.lopnColor;

    HBRUSH hBrush = (HBRUSH) GetCurrentObject(pCanvasHandle->dc, OBJ_BRUSH);
    LOGBRUSH useBrush = { 0 };
    GetObject(hBrush, sizeof(LOGBRUSH), &useBrush);
    pCanvasHandle->originalBrush = hBrush;
    pCanvasHandle->brushStyle = useBrush.lbStyle;
    pCanvasHandle->brushHatch = useBrush.lbHatch;
    pCanvasHandle->brushRGB = useBrush.lbColor;

    return pCanvasHandle ;

}

#endif
