#include "project.h"
HWND  rtEditHWND;

void inform_modules(SYS_STATE state)
{
    if (state EQU SS_POWER_UP)
    {

        (void) CoInitializeEx(NULL, COINIT_APARTMENTTHREADED | COINIT_DISABLE_OLE1DDE);
        (void) CoInitializeSecurity(NULL, -1, NULL, NULL, RPC_C_AUTHN_LEVEL_DEFAULT, RPC_C_IMP_LEVEL_IMPERSONATE, NULL, EOAC_NONE, NULL);
    }

    (void)codecontrol_sob(state);

    if (state EQU SS_POWER_DOWN)
    {

        (void) CoInitializeEx(NULL, COINIT_APARTMENTTHREADED | COINIT_DISABLE_OLE1DDE);
    }
}

// --------------------------------------------------------------------------------------------------------------------------------------

static void file_exit(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam, SOBDATA * sData)
{
    DestroyWindow(hWnd);
}

// --------------------------------------------------------------------------------------------------------------------------------------
SOBDATA* myOvl;
RICHTEXTEDITOBJECT* rte;

SOBDATA* TopWindowObj;

PUSHBUTTONOBJECT* btnStr;

static void comEvent(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam, SOBDATA* sData)
{

    COMBOOBJECT* thisObject = (COMBOOBJECT*)lParam;
    WORD NotificationCode = HIWORD(wParam);
    WORD identifier = LOWORD(wParam);

    if (NotificationCode NEQU CBN_SELCHANGE) return;
    RICHTEXTEDIT.Empty(rte);

    COMBOOBJECT* comObj = (COMBOOBJECT*)sData;
    myUInt itemId = COMBO.GetSelectionIndex(comObj);
    itemId = COMBO.GetItemData(comObj, itemId);
    SOB.Report(sob_get_base((SOBID) itemId));

}

static void grabA(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam, SOBDATA* sData)
{
    PUSHBUTTON.SetUserData(PUSHBUTTON.LastWidget(), (myUInt)IMAGE.LastWidget());

}

static void showshow(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam, SOBDATA* sData)
{
    PUSHBUTTON.SetStretch(btnStr, 1);

    TOPWINDOW.Display(TopWindowObj);
}

// --------------------------------------------------------------------------------------------------------------------------------------

myUInt initApplication()
{
    inform_modules(SS_POWER_UP);

    // ------
    // create the TOP WINDOW for the application

    TopWindowObj =  TOPWINDOW.Create(szTitle, szWindowClass);
    if (TopWindowObj EQU NULL)  return FALSE;

    appHWND = TopWindowObj->hWnd;
    if (!appHWND)  return FALSE;

    // ------
    // to avoid screen flicker, and for performance
    // temporarily hide the main window until
    // the various widgets have been created.

    ShowState = SWP_HIDEWINDOW; // SWP_HIDEWINDOW  SWP_SHOWWINDOW;

    // ------
    // create the TOP WINDOW's   MENUBAR

    SOBDATA * appMenuBar = MENUBAR.Create();

    // ------

    MENUBAR.Open(SOBOBJ appMenuBar);

    MENUH.Create((TCHAR*)L"File");

    MENUV.SetEventHandler(MENUV.Create((TCHAR*)L"Exit"), (EVENTHANDLER)file_exit);

    TOPWINDOW.Open(TopWindowObj);

    SOBDATA * cwA = COLUMNWIDTH.Create();
    COLUMNWIDTH.Stretch(COLUMNWIDTH.LastWidget(), 1);

    // ------

    // capture_init(appMenuBar);
    midi_init(appMenuBar);
    about_init(appMenuBar);

    // ------

    SOB.Open(cwA);

    // ---------------------------------
    COLUMNWIDTH.Create();
    COLUMNWIDTH.Stretch(COLUMNWIDTH.LastWidget(), 1);
    // ------

    // ------

    rte =  RICHTEXTEDIT.Create
    ((TCHAR*)_TEXT("                                                                                       "),
    8
    );

    // make this RICHTEXTEDIT the destination for general purpose OUTPUT  e.g. AddText and the debugX functions
    RICHTEXTEDIT.SetDefault(RICHTEXTEDIT.LastWidget());

    SOB.SetStretch(SOBOBJ RICHTEXTEDIT.LastWidget(), 1);

    // ---------------------------------

    ShowState = SWP_SHOWWINDOW; // SWP_HIDEWINDOW  SWP_SHOWWINDOW;

    TOPWINDOW.Display(TopWindowObj);

    usb_CM_Register_Notification();

    return SOB_OK;

}
