#include "project.h"
#include "about.h"


void about_clear(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam, SOBDATA* sData)
{
    clearText();
}



void about_contact(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam, SOBDATA * sData)
{
    clearText();
    addTextBold((TCHAR*)L"Contact:\n\n");
    addText((TCHAR*)L"E-Mail:   george.salisbury@ripetech.com\n\n");
    addText((TCHAR*)L"Internet: https://www.ripetech.com\n\n");
    addText((TCHAR*)L"YouTube channel: PlodWare\n");
}

void about_source_code(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam, SOBDATA * sData)
{
    clearText();
    addTextBold((TCHAR*)L"Source code:\n\n");
    addText((TCHAR*)L"This executable is available as (plain old) C source code.\n");
    addText((TCHAR*)L"A zip file of the entire solution created for Visual Studio 2022 is available for download at:\n");

    addTextBold((TCHAR*)L"https://ripetech.com/downloads-and-script-files\n");
    addText((TCHAR*)L"Look for the link to    Midi-Controller-As-Event-Trigger-C .\n");

    addTextBold((TCHAR*)L"\nDISCLAIMER\n");
    addText((TCHAR*)L"  This software is provided ");
    addTextBold((TCHAR*)L"AS IS");
    addText((TCHAR*)L" and without any warranty, express or implied, \n");
    addText((TCHAR*)L"  including, but not limited to, the implied warranties of merchantability and fitness\n");
}

void about_text(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam, SOBDATA * sData)
{
    clearText();
    addTextBold((TCHAR*)L"About:\n\n");
    addText((TCHAR*)L"This program was written as an example of how events outside of a PC can be\n");
    addText((TCHAR*)L"passed to a PC executable, and this used to trigger software event handling.\n");

    addText((TCHAR*)L"\n");
    addText((TCHAR*)L"This program received (external) hardware events from a MIDI controller\n");
    addText((TCHAR*)L"and then decodes each MIDI Note On/Off event.\n");

    addText((TCHAR*)L"\n");
    addText((TCHAR*)L"Purely for fun (?) the incoming MIDI messages are sent to the default (index-0) MIDI out device.\n");

    addText((TCHAR*)L"\n");
    addText((TCHAR*)L"Although the MIDI standard is old, it is simple in concept, simple to program at\n");
    addText((TCHAR*)L"the Windows message level, and works ");
    addTextBold((TCHAR*)L"even if");
    addText((TCHAR*)L" the target executable does not have keyboard focus.\n");
    addText((TCHAR*)L"\n");
    addTextBold((TCHAR*)L"Sorry ");
    addText((TCHAR*)L"I should have said, I program at the Win32 API and Windows message level without use of any frameworks.\n");

    addText((TCHAR*)L"\nBuild date: " );
    addText( int_build_date() );

}

void  about_init(SOBDATA* menuBar)
{
    MENUBAR.Open(SOBOBJ menuBar);

    MENUH.Create((TCHAR*)_TEXT("About"));

    MENUV.Create((TCHAR*)_TEXT("This program"));
    MENUV.SetEventHandler(MENUV.LastWidget(), (EVENTHANDLER)about_text);

    MENUV.Create((TCHAR*)_TEXT("Contact"));
    MENUV.SetEventHandler(MENUV.LastWidget(), (EVENTHANDLER)about_contact);

    MENUV.Create((TCHAR*)_TEXT("Source code"));
    MENUV.SetEventHandler(MENUV.LastWidget(), (EVENTHANDLER)about_source_code);

    MENUV.Create((TCHAR*)_TEXT("Clear Screen"));
    MENUV.SetEventHandler(MENUV.LastWidget(), (EVENTHANDLER)about_clear);



}
